/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.scopes;

import com.adobe.flash.compiler.asdoc.IASDocComment;
import com.adobe.flash.compiler.definitions.IDocumentableDefinition;
import com.adobe.flash.compiler.internal.projects.ASProject;
import com.adobe.flash.compiler.internal.projects.LibraryPathManager;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.units.SWCCompilationUnit;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IFileScopeProvider;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import com.google.common.base.Strings;

public final class SWCFileScopeProvider
implements IFileScopeProvider {
    private static final SWCFileScopeProvider instance = new SWCFileScopeProvider();

    public static SWCFileScopeProvider getInstance() {
        return instance;
    }

    private SWCFileScopeProvider() {
    }

    @Override
    public ASFileScope createFileScope(IWorkspace workspace, String filePath) {
        return new SWCFileScope(workspace, filePath);
    }

    public static final class SWCFileScope
    extends ASFileScope {
        public SWCFileScope(IWorkspace workspace, String filePath) {
            super(workspace, filePath);
        }

        @Override
        public String getContainingSourcePath(String qName, ICompilerProject project) {
            assert (!Strings.isNullOrEmpty((String)qName)) : "Expected QName.";
            assert (project != null);
            if (!(project instanceof ASProject)) {
                return null;
            }
            ASProject flashProject = (ASProject)project;
            String swcFilePath = this.filePath;
            String attachedSourceDirectory = flashProject.getAttachedSourceDirectory(swcFilePath);
            if (attachedSourceDirectory == null) {
                return null;
            }
            return LibraryPathManager.getAttachedSourceFilename(attachedSourceDirectory, qName);
        }

        public IASDocComment getComment(ICompilerProject project, IDocumentableDefinition def) {
            if (!(project instanceof ASProject)) {
                return null;
            }
            ASProject flashProject = (ASProject)project;
            return flashProject.getASDocBundleDelegate().getComment(def, this.getContainingPath());
        }

        @Override
        public boolean isSWC() {
            return true;
        }

        @Override
        public boolean setCompilationUnit(ICompilationUnit compilationUnit) {
            assert (compilationUnit == null || compilationUnit instanceof SWCCompilationUnit) : "non SWCCompilationUnit passed to SWCFileScopeProvider";
            return false;
        }

        @Override
        public ICompilationUnit getCompilationUnit() {
            return null;
        }
    }
}

