/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.scopes;

import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.internal.scopes.ASScopeBase;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.google.common.base.Predicate;
import java.util.Set;

public class NamespaceSetPredicate
implements Predicate<IDefinition> {
    private final ICompilerProject project;
    private final Set<INamespaceDefinition> namespaceSet;
    private INamespaceDefinition extraNamespace;

    public NamespaceSetPredicate(ICompilerProject project, Set<INamespaceDefinition> namespaceSet) {
        this.project = project;
        this.namespaceSet = namespaceSet;
    }

    public boolean apply(IDefinition definition) {
        INamespaceReference nsRef = definition.getNamespaceReference();
        if (this.namespaceSet == ASScopeBase.allNamespacesSet) {
            return true;
        }
        if (this.extraNamespace != null && nsRef == this.extraNamespace) {
            return true;
        }
        INamespaceDefinition namespace = definition.resolveNamespace(this.project);
        if (this.namespaceSet.contains(namespace)) {
            return true;
        }
        return this.extraNamespace != null && (namespace == this.extraNamespace || this.extraNamespace.equals(namespace));
    }

    public boolean containsNamespace(INamespaceDefinition d) {
        return this.namespaceSet != null && this.namespaceSet.contains(d);
    }

    public void setExtraNamespace(INamespaceDefinition extra) {
        this.extraNamespace = extra;
    }

    public Set<INamespaceDefinition> getNamespaceSet() {
        return this.namespaceSet;
    }
}

