/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.scopes;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.IFileSpecificationGetter;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.IPackageDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.ScopedDefinitionBase;
import com.adobe.flash.compiler.internal.parsing.as.OffsetLookup;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.ASScopeCache;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IDefinitionSet;
import com.adobe.flash.compiler.scopes.IFileScope;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import com.adobe.flash.utils.FastStack;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FilenameUtils;

public class ASFileScope
extends ASScope
implements IFileScope {
    private static Collection<String> IMPLICIT_IMPORTS_FOR_AS = Collections.singleton(IASLanguageConstants.Vector_qname);
    protected String filePath;
    protected Boolean isEditableFile;
    private final INamespaceDefinition.IFilePrivateNamespaceDefinition filePrivateNamespace;
    private final IFileSpecificationGetter fileSpecGetter;
    protected WeakReference<ICompilationUnit> compilationUnitReference;
    private ConcurrentHashMap<FunctionNode, Object> parsedFunctionBodies;
    private OffsetLookup offsetLookup;

    public static Collection<String> getImplicitImportsForAS() {
        return IMPLICIT_IMPORTS_FOR_AS;
    }

    public ASFileScope(IFileSpecificationGetter fileSpecGetter, String filePath) {
        super(null);
        this.filePath = filePath;
        String uri = "FilePrivateNS";
        this.filePrivateNamespace = NamespaceDefinition.createFilePrivateNamespaceDefinition(uri);
        this.fileSpecGetter = fileSpecGetter;
        this.compilationUnitReference = null;
        this.addImplicitImportsForAS();
        this.parsedFunctionBodies = new ConcurrentHashMap();
    }

    public ASFileScope(FileNode fileNode) {
        super(null, fileNode);
        this.filePath = fileNode.getSourcePath();
        String uri = "FilePrivateNS:" + FilenameUtils.getBaseName((String)this.filePath);
        this.filePrivateNamespace = NamespaceDefinition.createFilePrivateNamespaceDefinition(uri);
        this.fileSpecGetter = fileNode.getFileSpecificaitonGetter();
        this.compilationUnitReference = null;
        this.addImplicitImportsForAS();
        this.parsedFunctionBodies = new ConcurrentHashMap();
    }

    private void addImplicitImportsForAS() {
        for (String implicitImport : ASFileScope.getImplicitImportsForAS()) {
            this.addImport(implicitImport);
        }
    }

    protected boolean isEditableFile() {
        if (this.isEditableFile == null) {
            boolean isEditable = true;
            if (this.filePath != null && this.filePath.endsWith(".swc")) {
                isEditable = false;
            }
            this.isEditableFile = isEditable;
        }
        return this.isEditableFile;
    }

    @Override
    protected String toStringHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toStringHeader());
        if (this.filePath != null) {
            sb.append(" for \"");
            sb.append(this.filePath);
            sb.append("\"");
        }
        return sb.toString();
    }

    @Override
    public boolean isPackageName(String p) {
        if (super.isPackageName(p)) {
            return true;
        }
        IDefinitionSet defSet = this.getLocalDefinitionSetByName(p);
        if (defSet != null) {
            int n = defSet.getSize();
            for (int i = 0; i < n; ++i) {
                IPackageDefinition packageDef;
                IDefinition def = defSet.getDefinition(i);
                if (!(def instanceof IPackageDefinition) || !p.equals((packageDef = (IPackageDefinition)def).getBaseName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean namespaceSetSameAsContainingScopeNamespaceSet() {
        return false;
    }

    public INamespaceDefinition.ILanguageNamespaceDefinition getFilePrivateNamespaceReference() {
        return this.filePrivateNamespace;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this.fileSpecGetter.getWorkspace();
    }

    @Override
    public String getContainingSourcePath(String qName, ICompilerProject project) {
        return this.filePath;
    }

    @Override
    public String getContainingPath() {
        return this.filePath;
    }

    @Override
    public void collectExternallyVisibleDefinitions(Collection<IDefinition> defs, boolean includePrivateDefinitions) {
        FastStack<ASScope> scopesToVisit = new FastStack<ASScope>();
        scopesToVisit.push(this);
        while (scopesToVisit.size() > 0) {
            ASScope currentScope = (ASScope)scopesToVisit.pop();
            for (IDefinitionSet defSet : currentScope.getAllLocalDefinitionSets()) {
                int n = defSet.getSize();
                for (int i = 0; i < n; ++i) {
                    IDefinition def = defSet.getDefinition(i);
                    if (def instanceof IPackageDefinition) {
                        IPackageDefinition packageDef = (IPackageDefinition)def;
                        ASScope packageScope = (ASScope)packageDef.getContainedScope();
                        scopesToVisit.push(packageScope);
                        continue;
                    }
                    if (def.getContainingScope() != currentScope || !includePrivateDefinitions && !def.getNamespaceReference().isPublicOrInternalNamespace()) continue;
                    defs.add(def);
                }
            }
        }
    }

    @Override
    public void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        result.add(this.getFilePrivateNamespaceReference());
        compilerProject.addGlobalUsedNamespacesToNamespaceSet(result);
    }

    public IASNode reparseFile() throws InterruptedException {
        return this.getCompilationUnit().getSyntaxTreeRequest().get().getAST();
    }

    public void setOffsetLookup(OffsetLookup offsetLookup) {
        assert (offsetLookup != null) : "Offset lookup can't be null";
        this.offsetLookup = offsetLookup;
    }

    public OffsetLookup getOffsetLookup() {
        return this.offsetLookup;
    }

    @Override
    public final ScopedDefinitionBase getContainingDefinition() {
        return null;
    }

    @Override
    public boolean isSWC() {
        return false;
    }

    public IASNode getNode() {
        IASNode node = null;
        try {
            node = this.reparseFile();
        }
        catch (InterruptedException ie) {
            node = null;
        }
        return node;
    }

    public boolean setCompilationUnit(ICompilationUnit compilationUnit) {
        if (compilationUnit == null) {
            this.compilationUnitReference = null;
            return true;
        }
        this.compilationUnitReference = new WeakReference<ICompilationUnit>(compilationUnit);
        return true;
    }

    public ICompilationUnit getCompilationUnit() {
        if (this.compilationUnitReference == null) {
            return null;
        }
        return (ICompilationUnit)this.compilationUnitReference.get();
    }

    public void addParsedFunctionBodies(FunctionNode functionNode) {
        this.parsedFunctionBodies.put(functionNode, Object.class);
    }

    public void removeParsedFunctionBodies(FunctionNode functionNode) {
        this.parsedFunctionBodies.remove(functionNode);
    }

    @Override
    public void addDependencyOnBuiltinType(ICompilerProject project, IASLanguageConstants.BuiltinType builtinType, DependencyType dependencyType) {
        ASScopeCache cache = ((CompilerProject)project).getCacheForScope(this);
        cache.addDependencyOnBuiltinType(builtinType, dependencyType);
    }
}

