/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.resourcebundles;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.config.QNameNormalization;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.units.ResourceBundleCompilationUnit;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.ResourceBundleNotFoundForLocaleProblem;
import com.adobe.flash.compiler.problems.ResourceBundleNotFoundProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceBundleUtils {
    public static final String CLASS_SUFFIX = "_properties";

    public static String getQualifiedName(String locale, String bundleName) {
        String normalizedBundleName = QNameNormalization.normalize(bundleName);
        String packageName = Multiname.getPackageNameForQName(normalizedBundleName);
        String className = Multiname.getBaseNameForQName(normalizedBundleName);
        StringBuilder sb = new StringBuilder();
        if (packageName != null && packageName.length() > 0) {
            sb.append(packageName);
            sb.append(".");
        }
        sb.append(locale);
        sb.append("$");
        sb.append(className);
        sb.append(CLASS_SUFFIX);
        return sb.toString();
    }

    public static String getLocale(String qualifiedName) {
        String className = Multiname.getBaseNameForQName(qualifiedName);
        int indexOf = className.indexOf(36);
        if (indexOf > 0) {
            return className.substring(0, indexOf);
        }
        return null;
    }

    public static String convertBundleNameToColonSyntax(String bundleName) {
        String normalizedName = QNameNormalization.normalize(bundleName);
        String packageName = Multiname.getPackageNameForQName(normalizedName);
        if (packageName == null || packageName.length() == 0) {
            return bundleName;
        }
        String className = Multiname.getBaseNameForQName(normalizedName);
        return packageName + ":" + className;
    }

    public static void resolveDependencies(String bundleName, ICompilationUnit refCompUnit, ICompilerProject project, ISourceLocation location, Collection<ICompilerProblem> errors) throws InterruptedException {
        Map<String, ICompilationUnit> qualifiedNameMap = ResourceBundleUtils.findCompilationUnits(bundleName, project, refCompUnit.getAbsoluteFilename(), location, errors);
        for (Map.Entry<String, ICompilationUnit> entry : qualifiedNameMap.entrySet()) {
            ((FlexProject)project).addDependency(refCompUnit, entry.getValue(), DependencyType.EXPRESSION, entry.getKey());
        }
    }

    public static Collection<ICompilationUnit> findCompilationUnits(String bundleName, ICompilerProject project, Collection<ICompilerProblem> errors) throws InterruptedException {
        return ResourceBundleUtils.findCompilationUnits(bundleName, project, null, null, errors).values();
    }

    private static Map<String, ICompilationUnit> findCompilationUnits(String bundleName, ICompilerProject project, String refFilePath, ISourceLocation location, Collection<ICompilerProblem> errors) throws InterruptedException {
        HashMap<String, ICompilationUnit> compilationUnits = new HashMap<String, ICompilationUnit>();
        if (project instanceof FlexProject) {
            String normalizedBundleName = QNameNormalization.normalize(bundleName);
            FlexProject flexProject = (FlexProject)project;
            ASProjectScope scope = flexProject.getScope();
            Collection<String> locales = flexProject.getLocales();
            if (locales.size() == 0) {
                return Collections.emptyMap();
            }
            ArrayList<String> unresolvedLocales = new ArrayList<String>(locales);
            for (String locale : locales) {
                ICompilationUnit compUnit;
                String qualifiedName = ResourceBundleUtils.getQualifiedName(locale, normalizedBundleName);
                IDefinition def = scope.findDefinitionByName(qualifiedName);
                if (def == null || !ResourceBundleUtils.isValidCompilationUnit(compUnit = scope.getCompilationUnitForDefinition(def), project, bundleName)) continue;
                compilationUnits.put(def.getQualifiedName(), compUnit);
                unresolvedLocales.remove(locale);
            }
            if (unresolvedLocales.size() > 0 || locales.size() == 0) {
                ICompilationUnit compUnit;
                IDefinition def = scope.findDefinitionByName(normalizedBundleName);
                if (def != null && ResourceBundleUtils.isValidCompilationUnit(compUnit = scope.getCompilationUnitForDefinition(def), project, bundleName)) {
                    compilationUnits.put(def.getQualifiedName(), compUnit);
                    return compilationUnits;
                }
                if (unresolvedLocales.size() == locales.size()) {
                    ResourceBundleNotFoundProblem problem = location != null ? new ResourceBundleNotFoundProblem(location, bundleName) : new ResourceBundleNotFoundProblem(bundleName);
                    errors.add(problem);
                } else {
                    for (String locale : unresolvedLocales) {
                        ResourceBundleNotFoundForLocaleProblem problem = location != null ? new ResourceBundleNotFoundForLocaleProblem(location, bundleName, locale) : new ResourceBundleNotFoundForLocaleProblem(bundleName, locale);
                        errors.add(problem);
                    }
                }
            }
        }
        return compilationUnits;
    }

    private static boolean isValidCompilationUnit(ICompilationUnit compUnit, ICompilerProject project, String bundleName) throws InterruptedException {
        if (compUnit != null) {
            if (compUnit instanceof ResourceBundleCompilationUnit) {
                if (((ResourceBundleCompilationUnit)compUnit).getBundleNameInColonSyntax().equals(bundleName)) {
                    return true;
                }
            } else {
                IFileScopeRequestResult result = compUnit.getFileScopeRequest().get();
                for (IDefinition def : result.getExternallyVisibleDefinitions()) {
                    if (!(def instanceof ClassDefinition) || !(project instanceof FlexProject) || !((ClassDefinition)def).isInstanceOf(((FlexProject)project).getResourceBundleClass(), project)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

