/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.projects;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.asdoc.IASDocBundleDelegate;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.config.RSLSettings;
import com.adobe.flash.compiler.css.ICSSManager;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IEffectDefinition;
import com.adobe.flash.compiler.definitions.IEventDefinition;
import com.adobe.flash.compiler.definitions.IGetterDefinition;
import com.adobe.flash.compiler.definitions.IStyleDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.exceptions.LibraryCircularDependencyException;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.css.CSSManager;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.PackageDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.mxml.MXMLManifestManager;
import com.adobe.flash.compiler.internal.projects.ASProject;
import com.adobe.flash.compiler.internal.projects.DependencyGraph;
import com.adobe.flash.compiler.internal.projects.FXGSourceFileHandler;
import com.adobe.flash.compiler.internal.projects.LibraryDependencyGraph;
import com.adobe.flash.compiler.internal.projects.MXMLSourceFileHandler;
import com.adobe.flash.compiler.internal.projects.ResourceBundleSourceFileHandler;
import com.adobe.flash.compiler.internal.projects.ThemeUtilities;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.targets.AppSWFTarget;
import com.adobe.flash.compiler.internal.targets.FlexAppSWFTarget;
import com.adobe.flash.compiler.internal.targets.SWCTarget;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLImplicitImportNode;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.IMXMLNamespaceMapping;
import com.adobe.flash.compiler.mxml.MXMLNamespaceMapping;
import com.adobe.flash.compiler.projects.IFlexProject;
import com.adobe.flash.compiler.scopes.IDefinitionSet;
import com.adobe.flash.compiler.targets.ISWCTarget;
import com.adobe.flash.compiler.targets.ISWFTarget;
import com.adobe.flash.compiler.targets.ITargetProgressMonitor;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.tree.as.IImportNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IOutgoingDependenciesRequestResult;
import com.adobe.flash.compiler.units.requests.IRequest;
import com.adobe.flash.swc.ISWC;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class FlexProject
extends ASProject
implements IFlexProject {
    private final ICSSManager cssManager;
    private Collection<String> locales;
    private final Map<String, String> localeDependentPaths;
    private String componentTagType;
    private String stateClass;
    private String stateClientInterface;
    private String instanceOverrideClass;
    private Name instanceOverrideClassName;
    private String propertyOverrideClass;
    private Name propertyOverrideClassName;
    private String styleOverrideClass;
    private Name styleOverrideClassName;
    private String eventOverrideClass;
    private Name eventOverrideClassName;
    private String deferredInstanceInterface;
    private String transientDeferredInstanceInterface;
    private String deferredInstanceFromClassClass;
    private String deferredInstanceFromFunctionClass;
    private Name deferredInstanceFromFunctionName;
    private String factoryInterface;
    private String classFactoryClass;
    private String mxmlObjectInterface;
    private String containerInterface;
    private String visualElementContainerInterface;
    private String resourceBundleClass;
    private String resourceManagerClass;
    private String resourceModuleBaseClass;
    private Name resourceManagerClassName;
    private String bindingManagerClass;
    private Name bindingManagerClassName;
    private String bindingClass;
    private Name bindingClassName;
    private List<RSLSettings> rslSettingsList;
    private ImmutableList<IFileSpecification> themeFiles = ImmutableList.of();
    private String propertyWatcherClass;
    private String staticPropertyWatcherClass;
    private Name propertyWatcherClassName;
    private Name staticPropertyWatcherClassName;
    private String functionReturnWatcherClass;
    private Name functionReturnWatcherClassName;
    private String objectProxyClass;
    private String xmlWatcherClass;
    private Name xmlWatcherClassName;
    private String uiComponentDescriptorClass;
    private Name uiComponentDescriptorClassName;
    private String modelClass;
    private Name modelClassName;
    private String cssStyleDeclarationClass;
    private Name cssStyleDeclarationClassName;
    private String flexModuleInterface;
    private String deferredInstantiationUIComponentInterface;
    private Map<String, Integer> namedColors;
    private String[] implicitImportsForMXML;
    private List<IImportNode> implicitImportNodesForMXML;
    private IMXMLNamespaceMapping[] namespaceMappings = new MXMLNamespaceMapping[0];
    private MXMLManifestManager manifestManager;
    private String xmlUtilClass;
    private Name xmlUtilClassName;
    private String servicesXMLPath;
    private String servicesContextRoot;
    private String webServiceQName;
    private String webServiceOperationQName;
    private String remoteObjectQName;
    private String remoteObjectMethodQName;
    private String actionScriptFileEncoding = "utf-8";
    private Map<File, List<String>> extensions;
    private boolean isFlex = false;
    private String httpServiceQName;
    private String designLayerQName;

    public FlexProject(Workspace workspace, IASDocBundleDelegate asDocBundleDelegate) {
        super(workspace, true, asDocBundleDelegate);
        this.implicitImportsForMXML = new String[0];
        this.implicitImportNodesForMXML = new ArrayList<IImportNode>();
        this.cssManager = new CSSManager(this);
        this.localeDependentPaths = new HashMap<String, String>();
        this.locales = Collections.unmodifiableCollection(Collections.emptySet());
    }

    public FlexProject(Workspace workspace) {
        this(workspace, IASDocBundleDelegate.NIL_DELEGATE);
    }

    @Override
    public ISWFTarget createSWFTarget(ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        AppSWFTarget target;
        if (this.isFlex()) {
            String rootClassName = targetSettings.getRootClassName();
            target = new FlexAppSWFTarget(ReferenceFactory.packageQualifiedReference(this.getWorkspace(), rootClassName, true), this, targetSettings, progressMonitor);
        } else {
            target = new AppSWFTarget(this, targetSettings, progressMonitor);
        }
        return target;
    }

    @Override
    public ISWCTarget createSWCTarget(ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        return new SWCTarget(this, targetSettings, progressMonitor);
    }

    public int getColorAsInt(String colorValue) throws NumberFormatException {
        Integer value;
        if (colorValue == null) {
            throw new NullPointerException("colorValue may not be null");
        }
        if (this.namedColors != null && (value = this.namedColors.get(colorValue)) != null) {
            return value;
        }
        return Integer.decode(colorValue);
    }

    public String getComponentTagType() {
        return this.componentTagType;
    }

    public void setComponentTagType(String componentTagType) {
        this.componentTagType = componentTagType;
    }

    public String getStateClass() {
        return this.stateClass;
    }

    public void setStateClass(String stateClass) {
        this.stateClass = stateClass;
    }

    public String getStateClientInterface() {
        return this.stateClientInterface;
    }

    public void setStateClientInterface(String stateClientInterface) {
        this.stateClientInterface = stateClientInterface;
    }

    public String getInstanceOverrideClass() {
        return this.instanceOverrideClass;
    }

    public Name getInstanceOverrideClassName() {
        return this.instanceOverrideClassName;
    }

    public void setInstanceOverrideClass(String instanceOverrideClass) {
        this.instanceOverrideClass = instanceOverrideClass;
        this.instanceOverrideClassName = this.getMNameForQName(instanceOverrideClass);
    }

    public String getPropertyOverrideClass() {
        return this.propertyOverrideClass;
    }

    public Name getPropertyOverrideClassName() {
        return this.propertyOverrideClassName;
    }

    public void setPropertyOverrideClass(String propertyOverrideClass) {
        this.propertyOverrideClass = propertyOverrideClass;
        this.propertyOverrideClassName = this.getMNameForQName(propertyOverrideClass);
    }

    public String getStyleOverrideClass() {
        return this.styleOverrideClass;
    }

    public Name getStyleOverrideClassName() {
        return this.styleOverrideClassName;
    }

    public void setStyleOverrideClass(String styleOverrideClass) {
        this.styleOverrideClass = styleOverrideClass;
        this.styleOverrideClassName = this.getMNameForQName(styleOverrideClass);
    }

    public String getEventOverrideClass() {
        return this.eventOverrideClass;
    }

    public Name getEventOverrideClassName() {
        return this.eventOverrideClassName;
    }

    public void setEventOverrideClass(String eventOverrideClass) {
        this.eventOverrideClass = eventOverrideClass;
        this.eventOverrideClassName = this.getMNameForQName(eventOverrideClass);
    }

    public String getDeferredInstanceInterface() {
        return this.deferredInstanceInterface;
    }

    public void setDeferredInstanceInterface(String deferredInstanceInterface) {
        this.deferredInstanceInterface = deferredInstanceInterface;
    }

    public String getTransientDeferredInstanceInterface() {
        return this.transientDeferredInstanceInterface;
    }

    public void setTransientDeferredInstanceInterface(String transientDeferredInstanceInterface) {
        this.transientDeferredInstanceInterface = transientDeferredInstanceInterface;
    }

    public String getDeferredInstanceFromClassClass() {
        return this.deferredInstanceFromClassClass;
    }

    public void setDeferredInstanceFromClassClass(String deferredInstanceFromClassClass) {
        this.deferredInstanceFromClassClass = deferredInstanceFromClassClass;
    }

    public String getDeferredInstanceFromFunctionClass() {
        return this.deferredInstanceFromFunctionClass;
    }

    public Name getDeferredInstanceFromFunctionName() {
        return this.deferredInstanceFromFunctionName;
    }

    public void setDeferredInstanceFromFunctionClass(String deferredInstanceFromFunctionClass) {
        this.deferredInstanceFromFunctionClass = deferredInstanceFromFunctionClass;
        this.deferredInstanceFromFunctionName = this.getMNameForQName(deferredInstanceFromFunctionClass);
    }

    public String getFactoryInterface() {
        return this.factoryInterface;
    }

    public void setFactoryInterface(String factoryInterface) {
        this.factoryInterface = factoryInterface;
    }

    public String getMXMLObjectInterface() {
        return this.mxmlObjectInterface;
    }

    public void setMXMLObjectInterface(String mxmlObjectInterface) {
        this.mxmlObjectInterface = mxmlObjectInterface;
    }

    public String getClassFactoryClass() {
        return this.classFactoryClass;
    }

    public void setClassFactoryClass(String classFactoryClass) {
        this.classFactoryClass = classFactoryClass;
    }

    public String getContainerInterface() {
        return this.containerInterface;
    }

    public void setContainerInterface(String containerInterface) {
        this.containerInterface = containerInterface;
    }

    public String getVisualElementContainerInterface() {
        return this.visualElementContainerInterface;
    }

    public void setVisualElementContainerInterface(String visualElementContainerInterface) {
        this.visualElementContainerInterface = visualElementContainerInterface;
    }

    public String getResourceBundleClass() {
        return this.resourceBundleClass;
    }

    public void setResourceBundleClass(String resourceBundleClass) {
        this.resourceBundleClass = resourceBundleClass;
    }

    public String getResourceManagerClass() {
        return this.resourceManagerClass;
    }

    public Name getResourceManagerClassName() {
        return this.resourceManagerClassName;
    }

    public void setResourceManagerClass(String resourceManagerClass) {
        this.resourceManagerClass = resourceManagerClass;
        this.resourceManagerClassName = this.getMNameForQName(resourceManagerClass);
    }

    public String getBindingManagerClass() {
        return this.bindingManagerClass;
    }

    public Name getBindingManagerClassName() {
        return this.bindingManagerClassName;
    }

    public String getResourceModuleBaseClass() {
        return this.resourceModuleBaseClass;
    }

    public void setResourceModuleBaseClass(String resourceModuleBaseClass) {
        this.resourceModuleBaseClass = resourceModuleBaseClass;
    }

    public void setBindingManagerClass(String bindingManagerClass) {
        this.bindingManagerClass = bindingManagerClass;
        this.bindingManagerClassName = this.getMNameForQName(bindingManagerClass);
    }

    public String getXMLUtilClass() {
        return this.xmlUtilClass;
    }

    public Name getXMLUtilClassName() {
        return this.xmlUtilClassName;
    }

    public void setXMLUtilClass(String xmlUtilClass) {
        this.xmlUtilClass = xmlUtilClass;
        this.xmlUtilClassName = this.getMNameForQName(xmlUtilClass);
    }

    public String getBindingClass() {
        return this.bindingClass;
    }

    public Name getBindingClassName() {
        assert (this.bindingClassName != null);
        return this.bindingClassName;
    }

    public void setBindingClass(String bindingClass) {
        this.bindingClass = bindingClass;
        this.bindingClassName = this.getMNameForQName(bindingClass);
    }

    public String getPropertyWatcherClass() {
        return this.propertyWatcherClass;
    }

    public String getObjectProxyClass() {
        return this.objectProxyClass;
    }

    public void setObjectProxyClass(String objectProxyClass) {
        this.objectProxyClass = objectProxyClass;
    }

    public Name getPropertyWatcherClassName() {
        assert (this.propertyWatcherClassName != null);
        return this.propertyWatcherClassName;
    }

    public void setPropertyWatcherClass(String propertyWatcherClass) {
        this.propertyWatcherClass = propertyWatcherClass;
        this.propertyWatcherClassName = this.getMNameForQName(propertyWatcherClass);
    }

    public String getStaticPropertyWatcherClass() {
        return this.staticPropertyWatcherClass;
    }

    public Name getStaticPropertyWatcherClassName() {
        assert (this.staticPropertyWatcherClassName != null);
        return this.staticPropertyWatcherClassName;
    }

    public void setStaticPropertyWatcherClass(String staticPropertyWatcherClass) {
        this.staticPropertyWatcherClass = staticPropertyWatcherClass;
        this.staticPropertyWatcherClassName = this.getMNameForQName(staticPropertyWatcherClass);
    }

    public Name getXMLWatcherClassName() {
        return this.xmlWatcherClassName;
    }

    public String getXMLWatcherClass() {
        return this.xmlWatcherClass;
    }

    public void setXMLWatcherClass(String xmlWatcherClass) {
        this.xmlWatcherClass = xmlWatcherClass;
        this.xmlWatcherClassName = this.getMNameForQName(xmlWatcherClass);
    }

    public String getFunctionReturnWatcherClass() {
        return this.functionReturnWatcherClass;
    }

    public Name getFunctionReturnWatcherClassName() {
        assert (this.functionReturnWatcherClassName != null);
        return this.functionReturnWatcherClassName;
    }

    public void setFunctionReturnWatcherClass(String staticPropertyWatcherClass) {
        this.functionReturnWatcherClass = staticPropertyWatcherClass;
        this.functionReturnWatcherClassName = this.getMNameForQName(staticPropertyWatcherClass);
    }

    public String getUIComponentDescriptorClass() {
        return this.uiComponentDescriptorClass;
    }

    public Name getUIComponentDescriptorClassName() {
        return this.uiComponentDescriptorClassName;
    }

    public void setUIComponentDescriptorClass(String uiComponentDescriptorClass) {
        this.uiComponentDescriptorClass = uiComponentDescriptorClass;
        this.uiComponentDescriptorClassName = this.getMNameForQName(uiComponentDescriptorClass);
    }

    public String getModelClass() {
        return this.modelClass;
    }

    public Name getModelClassName() {
        return this.modelClassName;
    }

    public void setModelClass(String modelClass) {
        this.modelClass = modelClass;
        this.modelClassName = this.getMNameForQName(modelClass);
    }

    public String getCSSStyleDeclarationClass() {
        return this.cssStyleDeclarationClass;
    }

    public Name getCSSStyleDeclarationClassName() {
        return this.cssStyleDeclarationClassName;
    }

    public void setCSSStyleDeclarationClass(String cssStyleDeclarationClass) {
        this.cssStyleDeclarationClass = cssStyleDeclarationClass;
        this.cssStyleDeclarationClassName = this.getMNameForQName(cssStyleDeclarationClass);
    }

    public String getFlexModuleInterface() {
        return this.flexModuleInterface;
    }

    public void setFlexModuleInterface(String flexModuleInterface) {
        this.flexModuleInterface = flexModuleInterface;
    }

    public String getDeferredInstantiationUIComponentInterface() {
        return this.deferredInstantiationUIComponentInterface;
    }

    public void setDeferredInstantiationUIComponentInterface(String deferredInstantiationUIComponentInterface) {
        this.deferredInstantiationUIComponentInterface = deferredInstantiationUIComponentInterface;
    }

    public Integer getNamedColor(String colorName) {
        return this.namedColors.get(colorName);
    }

    public void setNamedColors(Map<String, Integer> namedColors) {
        this.namedColors = namedColors;
    }

    public String[] getImplicitImportsForMXML() {
        return this.implicitImportsForMXML;
    }

    public List<IImportNode> getImplicitImportNodesForMXML() {
        return this.implicitImportNodesForMXML;
    }

    public void setImplicitImportsForMXML(String[] implicitImportsForMXML) {
        this.implicitImportsForMXML = implicitImportsForMXML;
        this.implicitImportNodesForMXML = new ArrayList<IImportNode>(implicitImportsForMXML.length);
        for (String implicitImport : implicitImportsForMXML) {
            this.implicitImportNodesForMXML.add(new MXMLImplicitImportNode(this, implicitImport));
        }
    }

    @Override
    public IMXMLNamespaceMapping[] getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public void invalidateManifestManager() {
        this.manifestManager = null;
    }

    private MXMLManifestManager getMXMLManifestManager() {
        if (this.manifestManager == null) {
            this.manifestManager = new MXMLManifestManager(this);
        }
        return this.manifestManager;
    }

    @Override
    public String resolveXMLNameToQualifiedName(XMLName xmlName, MXMLDialect mxmlDialect) {
        XMLName componentTag;
        String qname = this.getMXMLManifestManager().resolve(xmlName);
        if (qname == null) {
            String shortName = xmlName.getName();
            String uri = xmlName.getXMLNamespace();
            String packageName = PackageDefinition.getQualifiedPackageNameFromNamespaceURI(uri);
            if (packageName != null) {
                String string = qname = packageName.length() == 0 ? shortName : packageName + "." + shortName;
            }
        }
        if (qname == null && xmlName.getName().equals("State") && (mxmlDialect.isEqualToOrAfter(MXMLDialect.MXML_2009) && xmlName.getXMLNamespace().equals("library://ns.adobe.com/flex/spark") || mxmlDialect == MXMLDialect.MXML_2006 && xmlName.getXMLNamespace().equals("http://www.adobe.com/2006/mxml"))) {
            qname = this.stateClass;
        }
        if (qname == null && xmlName.equals(componentTag = mxmlDialect.resolveComponent())) {
            qname = this.componentTagType;
        }
        return qname;
    }

    @Override
    public IDefinition resolveXMLNameToDefinition(XMLName xmlName, MXMLDialect mxmlDialect) {
        String qName = this.resolveXMLNameToQualifiedName(xmlName, mxmlDialect);
        if (qName != null) {
            return this.resolveQNameToDefinition(qName);
        }
        return null;
    }

    public IDefinition resolveSpecifier(IClassDefinition classDefinition, String specifierName) {
        IDefinition definition = null;
        definition = this.resolveEvent(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveProperty(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveEffect(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        definition = this.resolveStyle(classDefinition, specifierName);
        if (definition != null) {
            return definition;
        }
        return null;
    }

    public IDefinition resolveProperty(IClassDefinition classDefinition, String propertyName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            ASScope classScope = ((ClassDefinition)c).getContainedScope();
            IDefinitionSet definitionSet = classScope.getLocalDefinitionSetByName(propertyName);
            if (definitionSet == null) continue;
            int n = definitionSet.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition definition = definitionSet.getDefinition(i);
                if (!(definition instanceof IVariableDefinition) || definition instanceof IGetterDefinition) continue;
                return definition;
            }
        }
        return null;
    }

    public IEventDefinition resolveEvent(IClassDefinition classDefinition, String eventName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IEventDefinition eventDefinition = c.getEventDefinition(this.getWorkspace(), eventName);
            if (eventDefinition == null) continue;
            return eventDefinition;
        }
        return null;
    }

    public IStyleDefinition resolveStyle(IClassDefinition classDefinition, String styleName) {
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        Workspace w = this.getWorkspace();
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IStyleDefinition styleDefinition = c.getStyleDefinition(w, styleName);
            if (styleDefinition == null) continue;
            return styleDefinition;
        }
        return null;
    }

    public IEffectDefinition resolveEffect(IClassDefinition classDefinition, String effectName) {
        Workspace w = this.getWorkspace();
        IClassDefinition.IClassIterator classIterator = classDefinition.classIterator(this, true);
        while (classIterator.hasNext()) {
            IClassDefinition c = (IClassDefinition)classIterator.next();
            IEffectDefinition effectDefinition = c.getEffectDefinition(w, effectName);
            if (effectDefinition == null) continue;
            return effectDefinition;
        }
        return null;
    }

    @Override
    public Collection<XMLName> getTagNamesForClass(String className) {
        return this.getMXMLManifestManager().getTagNamesForClass(className);
    }

    public Collection<String> getQualifiedClassNamesForManifestNamespaces(Set<String> namespaceURIs) {
        return this.getMXMLManifestManager().getQualifiedNamesForNamespaces(namespaceURIs, true);
    }

    public boolean isManifestComponentLookupOnly(XMLName tagName) {
        return this.getMXMLManifestManager().isLookupOnly(tagName);
    }

    @Override
    public ICSSManager getCSSManager() {
        return this.cssManager;
    }

    public String getServciesContextRoot() {
        return this.servicesContextRoot;
    }

    @Override
    public String getServicesXMLPath() {
        return this.servicesXMLPath;
    }

    @Override
    public void setServicesXMLPath(String path, String contextRoot) {
    }

    @Override
    public Collection<String> getLocales() {
        return this.locales;
    }

    @Override
    public void setLocales(Collection<String> locales) {
        assert (locales != null) : "Locales cannot be set to null";
        this.locales = Collections.unmodifiableCollection(locales);
        this.clean();
    }

    @Override
    public String getResourceLocale(String path) {
        return this.localeDependentPaths.get(path);
    }

    @Override
    public void setLocaleDependentResources(Map<String, String> localeDependentResources) {
        this.localeDependentPaths.clear();
        this.localeDependentPaths.putAll(localeDependentResources);
        this.clean();
    }

    private Name getMNameForQName(String qname) {
        Workspace workspace = this.getWorkspace();
        IResolvedQualifiersReference reference = ReferenceFactory.packageQualifiedReference(workspace, qname);
        return reference.getMName();
    }

    public void setWebServiceClass(String name) {
        this.webServiceQName = name;
    }

    public String getWebServiceQName() {
        return this.webServiceQName;
    }

    public void setWebServiceOperationClass(String name) {
        this.webServiceOperationQName = name;
    }

    public String getWebServiceOperationQName() {
        return this.webServiceOperationQName;
    }

    public void setRemoteObjectMethodClass(String name) {
        this.remoteObjectMethodQName = name;
    }

    public String getRemoteObjectMethodQName() {
        return this.remoteObjectMethodQName;
    }

    public void setRemoteObjectClass(String name) {
        this.remoteObjectQName = name;
    }

    public String getRemoteObjectQName() {
        return this.remoteObjectQName;
    }

    public void setHTTPServiceClass(String name) {
        this.httpServiceQName = name;
    }

    public String getHTTPServiceQName() {
        return this.httpServiceQName;
    }

    public void setDesignLayerClass(String name) {
        this.designLayerQName = name;
    }

    public String getDesignLayerQName() {
        return this.designLayerQName;
    }

    @Override
    public void setIncludeSources(Collection<File> sources) throws InterruptedException {
        Set<File> files = this.populateIncludedSourceFiles(sources);
        super.setIncludeSources(files.toArray(new File[files.size()]));
    }

    @Override
    public void setActionScriptFileEncoding(String encoding) {
        this.actionScriptFileEncoding = encoding;
        this.clean();
    }

    @Override
    public String getActionScriptFileEncoding() {
        return this.actionScriptFileEncoding;
    }

    @Override
    public void setDefineDirectives(Map<String, String> defines) {
        this.addConfigVariables(defines);
        this.clean();
    }

    @Override
    public void setExtensionLibraries(Map<File, List<String>> extensions) {
        this.extensions = extensions;
        this.clean();
    }

    @Override
    public Map<File, List<String>> getExtensionLibraries() {
        return this.extensions != null ? this.extensions : Collections.emptyMap();
    }

    private static boolean namespaceMappingsDiffer(IMXMLNamespaceMapping[] oldMappings, List<? extends IMXMLNamespaceMapping> newMappings) {
        if (oldMappings.length != newMappings.size()) {
            return true;
        }
        int nMappings = oldMappings.length;
        for (int i = 0; i < nMappings; ++i) {
            IMXMLNamespaceMapping oldMapping = oldMappings[i];
            IMXMLNamespaceMapping newMapping = newMappings.get(i);
            if (!oldMapping.getManifestFileName().equals(newMapping.getManifestFileName())) {
                return true;
            }
            if (oldMapping.getURI().equals(newMapping.getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setNamespaceMappings(List<? extends IMXMLNamespaceMapping> namespaceMappings) {
        if (FlexProject.namespaceMappingsDiffer(this.namespaceMappings, namespaceMappings)) {
            this.namespaceMappings = namespaceMappings.toArray(new MXMLNamespaceMapping[namespaceMappings.size()]);
            this.clean();
        }
    }

    @Override
    public List<RSLSettings> getRuntimeSharedLibraryPath() {
        return this.rslSettingsList != null ? this.rslSettingsList : Collections.emptyList();
    }

    @Override
    public void setRuntimeSharedLibraryPath(List<RSLSettings> rslSettings) {
        this.rslSettingsList = rslSettings;
        this.clean();
    }

    public void setThemeFiles(List<IFileSpecification> files) {
        this.themeFiles = files != null ? ImmutableList.copyOf(files) : ImmutableList.of();
        this.clean();
    }

    public List<IFileSpecification> getThemeFiles() {
        return this.themeFiles;
    }

    @Override
    public Set<String> computeLibraryDependencies(File targetLibrary, DependencyTypeSet dependencySet) throws LibraryCircularDependencyException {
        assert (targetLibrary != null) : "targetLibrary may not be null";
        LibraryDependencyGraph libraryGraph = this.createLibraryDependencyGraph(dependencySet);
        return libraryGraph.getDependencies(targetLibrary.getAbsolutePath());
    }

    @Override
    public List<String> computeLibraryDependencyOrder(DependencyTypeSet dependencySet) throws LibraryCircularDependencyException {
        LibraryDependencyGraph libraryGraph = this.createLibraryDependencyGraph(dependencySet);
        return libraryGraph.getDependencyOrder();
    }

    public LibraryDependencyGraph createLibraryDependencyGraph(DependencyTypeSet dependencySet) {
        List<ISWC> swcs = this.getLibraries();
        Workspace w = this.getWorkspace();
        ArrayList<IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit>> requests = new ArrayList<IRequest<IOutgoingDependenciesRequestResult, ICompilationUnit>>();
        HashSet<ICompilationUnit> swcUnits = new HashSet<ICompilationUnit>();
        for (ISWC iSWC : swcs) {
            String path = iSWC.getSWCFile().getAbsolutePath();
            Collection<ICompilationUnit> units = w.getCompilationUnits(path, this);
            swcUnits.addAll(units);
            for (ICompilationUnit unit : units) {
                requests.add(unit.getOutgoingDependenciesRequest());
            }
        }
        for (IRequest iRequest : requests) {
            try {
                iRequest.get();
            }
            catch (InterruptedException e) {
                assert (false) : "Unexpected interruption";
                return null;
            }
        }
        DependencyGraph unitGraph = this.getDependencyGraph();
        LibraryDependencyGraph libraryDependencyGraph = new LibraryDependencyGraph();
        for (ICompilationUnit unit : swcUnits) {
            Set<DependencyGraph.Edge> dependencies = unitGraph.getOutgoingEdges(unit);
            if (dependencies.size() == 0) {
                libraryDependencyGraph.addLibrary(unit.getAbsoluteFilename());
            }
            for (DependencyGraph.Edge dependency : dependencies) {
                ICompilationUnit to;
                ICompilationUnit from = (ICompilationUnit)dependency.getFrom();
                if (!this.isInterSWCDependency(from, to = (ICompilationUnit)dependency.getTo()) || dependencySet != null && !dependency.typeInSet(dependencySet) && !dependencySet.isEmpty()) continue;
                libraryDependencyGraph.addLibrary(from.getAbsoluteFilename());
                libraryDependencyGraph.addLibrary(to.getAbsoluteFilename());
                libraryDependencyGraph.addDependency(from.getAbsoluteFilename(), to.getAbsoluteFilename(), dependency.getNamedDependencies());
            }
        }
        return libraryDependencyGraph;
    }

    private boolean isInterSWCDependency(ICompilationUnit from, ICompilationUnit to) {
        if (from.getAbsoluteFilename() != null && !from.getAbsoluteFilename().equals(to.getAbsoluteFilename())) {
            if (this.hasShadowedCompulationUnit(to, from.getAbsoluteFilename())) {
                return false;
            }
            return !this.hasShadowedCompulationUnit(from, to.getAbsoluteFilename());
        }
        return false;
    }

    private boolean hasShadowedCompulationUnit(ICompilationUnit unit, String swcPath) {
        List<IDefinition> definitionPromises = unit.getDefinitionPromises();
        if (definitionPromises == null || definitionPromises.size() == 0) {
            return false;
        }
        ASProjectScope scope = this.getScope();
        Set<IDefinition> toDefs = scope.getShadowedDefinitions(definitionPromises.get(0));
        if (toDefs != null) {
            for (IDefinition def : toDefs) {
                ICompilationUnit shadowedUnit = scope.getCompilationUnitForDefinition(def);
                if (!swcPath.equals(shadowedUnit.getAbsoluteFilename())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<File> populateIncludedSourceFiles(Collection<File> includedSources) {
        HashSet<File> includedSourceFiles = new HashSet<File>();
        for (File file : includedSources) {
            if (file.isFile()) {
                includedSourceFiles.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            for (File fileInFolder : FileUtils.listFiles((File)file, (String[])new String[]{"as", "mxml"}, (boolean)true)) {
                includedSourceFiles.add(fileInFolder);
            }
        }
        return includedSourceFiles;
    }

    @Override
    public List<String> getThemeNames() {
        return Lists.transform(this.getThemeFiles(), ThemeUtilities.THEME_FILE_TO_NAME);
    }

    @Override
    public void clean() {
        super.clean();
        this.manifestManager = null;
    }

    @Override
    public boolean isFlex() {
        return this.isFlex;
    }

    @Override
    public void setFlex(boolean value) {
        this.isFlex = value;
        if (value) {
            this.getSourceCompilationUnitFactory().addHandler(MXMLSourceFileHandler.INSTANCE);
            this.getSourceCompilationUnitFactory().addHandler(ResourceBundleSourceFileHandler.INSTANCE);
            this.getSourceCompilationUnitFactory().addHandler(FXGSourceFileHandler.INSTANCE);
        }
    }
}

