/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.projects;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.parsing.as.IProjectConfigVariables;
import com.adobe.flash.compiler.internal.projects.ConfigManager;
import com.adobe.flash.compiler.internal.projects.DependencyGraph;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.ASScopeCache;
import com.adobe.flash.compiler.internal.targets.AppSWFTarget;
import com.adobe.flash.compiler.internal.targets.Target;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.internal.units.IntrinsicsCompilationUnit;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MissingBuiltinProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.targets.ISWFTarget;
import com.adobe.flash.compiler.targets.ITargetProgressMonitor;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.compiler.units.requests.IRequest;
import com.adobe.flash.utils.FilenameNormalization;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class CompilerProject
implements ICompilerProject {
    private final ASProjectScope projectScope;
    private final Workspace workspace;
    protected Set<Target> targets;
    private final ReadWriteLock unfoundDependenciesLock;
    private final Map<String, Map<ICompilationUnit, Object>> unfoundDefinitionDependencies;
    private final Map<String, Map<ICompilationUnit, Object>> unfoundReferencedSourceFileDependencies;
    private final Map<EmbedData, EmbedCompilationUnit> embedCompilationUnits;
    private ConcurrentMap<ASScope, ASScopeCache> scopeCaches = new MapMaker().weakKeys().softValues().makeComputingMap((Function)new ScopeMakerFunction(this));
    private ThreadLocal<Map<ASScope, WeakReference<ASScopeCache>>> threadLocalScopeCache;
    protected final DependencyGraph dependencyGraph;
    private boolean useParallelCodeGen;
    private boolean enableInlining;
    private final boolean useAS3;
    private final ConfigManager configManager;
    private static final IASLanguageConstants.BuiltinType[] REQUIRED_BUILTINS = new IASLanguageConstants.BuiltinType[]{IASLanguageConstants.BuiltinType.OBJECT, IASLanguageConstants.BuiltinType.ARRAY, IASLanguageConstants.BuiltinType.STRING, IASLanguageConstants.BuiltinType.ANY_TYPE, IASLanguageConstants.BuiltinType.VOID, IASLanguageConstants.BuiltinType.NUMBER, IASLanguageConstants.BuiltinType.INT, IASLanguageConstants.BuiltinType.UINT};

    public CompilerProject(Workspace workspace, boolean useAS3) {
        this.workspace = workspace;
        this.targets = new HashSet<Target>();
        this.unfoundDependenciesLock = new ReentrantReadWriteLock();
        this.unfoundDefinitionDependencies = new HashMap<String, Map<ICompilationUnit, Object>>();
        this.unfoundReferencedSourceFileDependencies = new HashMap<String, Map<ICompilationUnit, Object>>();
        this.embedCompilationUnits = new HashMap<EmbedData, EmbedCompilationUnit>();
        this.dependencyGraph = new DependencyGraph();
        this.projectScope = this.initProjectScope(this);
        this.useAS3 = useAS3;
        this.initThreadLocalCaches();
        this.configManager = new ConfigManager();
        this.useParallelCodeGen = false;
        this.enableInlining = false;
        workspace.addProject(this);
        this.initBuiltinCompilationUnits();
    }

    protected ASProjectScope initProjectScope(CompilerProject project) {
        return new ASProjectScope(project);
    }

    private void initThreadLocalCaches() {
        this.threadLocalScopeCache = new ThreadLocal<Map<ASScope, WeakReference<ASScopeCache>>>(){

            @Override
            protected Map<ASScope, WeakReference<ASScopeCache>> initialValue() {
                return new WeakHashMap<ASScope, WeakReference<ASScopeCache>>();
            }
        };
    }

    public void initBuiltinCompilationUnits() {
        block2: {
            IntrinsicsCompilationUnit intrinsicsCompilationUnit = new IntrinsicsCompilationUnit(this);
            try {
                this.addCompilationUnitsAndUpdateDefinitions(Collections.singleton(intrinsicsCompilationUnit));
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Project construction should never be interrupted");
            }
        }
    }

    @Override
    public ASProjectScope getScope() {
        return this.projectScope;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public List<ICompilationUnit> getReachableCompilationUnitsInSWFOrder(Collection<ICompilationUnit> roots) {
        return this.dependencyGraph.topologicalSort(roots);
    }

    public void updatePublicAndInternalDefinitions(Collection<ICompilationUnit> units) throws InterruptedException {
        if (units.isEmpty()) {
            return;
        }
        ArrayList<IRequest<IFileScopeRequestResult, ICompilationUnit>> scopeRequests = new ArrayList<IRequest<IFileScopeRequestResult, ICompilationUnit>>(units.size());
        for (ICompilationUnit unit : units) {
            ICompilerProject unitProject = unit.getProject();
            assert (unitProject == this || unitProject == null) : "ICompilationUnit should be in this project or not in any project";
            if (unitProject != this) continue;
            scopeRequests.add(unit.getFileScopeRequest());
        }
        this.scopeCaches.clear();
        this.initThreadLocalCaches();
        this.projectScope.addAllExternallyVisibleDefinitions(scopeRequests);
    }

    public void addCompilationUnitsAndUpdateDefinitions(Collection<ICompilationUnit> compilationUnits) throws InterruptedException {
        this.addCompilationUnits(compilationUnits);
        this.updatePublicAndInternalDefinitions(compilationUnits);
    }

    public void addEmbedCompilationUnit(EmbedCompilationUnit unit) throws InterruptedException {
        this.dependencyGraph.addEmbedCompilationUnit(unit);
        this.workspace.addCompilationUnit(unit);
        this.embedCompilationUnits.put(unit.getEmbedData(), unit);
        this.updatePublicAndInternalDefinitions(Collections.singletonList(unit));
    }

    public void addCompilationUnit(ICompilationUnit unit) {
        assert (!(unit instanceof EmbedCompilationUnit)) : "Embed compilation unit should be added with addEmbedCompilationUnit!";
        this.dependencyGraph.addCompilationUnit(unit);
        this.workspace.addCompilationUnit(unit);
    }

    public void addCompilationUnits(Collection<ICompilationUnit> units) {
        for (ICompilationUnit compilationUnit : units) {
            this.addCompilationUnit(compilationUnit);
        }
    }

    public void removeCompilationUnit(ICompilationUnit unit) {
        if (unit.isBuiltinCompilationUnit()) {
            return;
        }
        this.dependencyGraph.removeCompilationUnit(unit);
        this.workspace.removeCompilationUnit(unit);
        unit.clearProject();
        if (unit instanceof EmbedCompilationUnit) {
            EmbedData embedData = ((EmbedCompilationUnit)unit).getEmbedData();
            this.embedCompilationUnits.remove(embedData);
        }
    }

    public void unitTestingEntryPointForRemovingCompilationUnit(ICompilationUnit unit) {
        this.removeCompilationUnits(Collections.singleton(unit));
    }

    public void removeCompilationUnits(Collection<ICompilationUnit> unitsToRemove) {
        if (unitsToRemove == null || unitsToRemove.size() == 0) {
            return;
        }
        this.invalidateDependentScopeCaches(unitsToRemove);
        this.projectScope.removeCompilationUnits(unitsToRemove);
        for (ICompilationUnit unit : unitsToRemove) {
            this.removeCompilationUnit(unit);
        }
    }

    private void invalidateDependentScopeCaches(Collection<ICompilationUnit> unitsToRemove) {
        Set<ICompilationUnit> unitsToClean = DependencyGraph.computeInvalidationSet(unitsToRemove);
        for (ICompilationUnit cu : unitsToClean) {
            this.clearScopeCacheForCompilationUnit(cu);
        }
    }

    @Override
    public Collection<ICompilationUnit> getCompilationUnits() {
        return this.dependencyGraph.getCompilationUnits();
    }

    @Override
    public Collection<ICompilationUnit> getCompilationUnits(String filename) {
        return this.workspace.getCompilationUnits(FilenameNormalization.normalize(filename), this);
    }

    @Override
    public Collection<ICompilationUnit> getIncludingCompilationUnits(String filename) {
        return this.workspace.getIncludingCompilationUnits(FilenameNormalization.normalize(filename), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnfoundDefinitionDependency(String definitionBaseName, ICompilationUnit compilationUnit) {
        this.unfoundDependenciesLock.writeLock().lock();
        try {
            Map<ICompilationUnit, Object> dependentUnits = this.unfoundDefinitionDependencies.get(definitionBaseName);
            if (dependentUnits == null) {
                dependentUnits = new WeakHashMap<ICompilationUnit, Object>();
                this.unfoundDefinitionDependencies.put(definitionBaseName, dependentUnits);
            }
            dependentUnits.put(compilationUnit, null);
        }
        finally {
            this.unfoundDependenciesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ICompilationUnit> getDependenciesOnUnfoundDefinition(String definitionBaseName) {
        this.unfoundDependenciesLock.readLock().lock();
        try {
            Map<ICompilationUnit, Object> dependentUnits = this.unfoundDefinitionDependencies.get(definitionBaseName);
            if (dependentUnits == null) {
                dependentUnits = Collections.emptyMap();
            }
            Set<ICompilationUnit> set = dependentUnits.keySet();
            return set;
        }
        finally {
            this.unfoundDependenciesLock.readLock().unlock();
        }
    }

    private void removeAnyUnfoundDefinitionDependency(ICompilationUnit compilationUnit) {
        for (Map<ICompilationUnit, Object> dependentUnits : this.unfoundDefinitionDependencies.values()) {
            dependentUnits.remove(compilationUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUnfoundReferencedSourceFileDependency(String sourceFilename, ICompilationUnit compilationUnit) {
        this.unfoundDependenciesLock.writeLock().lock();
        try {
            String filenameNoPath = new File(sourceFilename).getName();
            Map<ICompilationUnit, Object> dependentUnits = this.unfoundReferencedSourceFileDependencies.get(filenameNoPath);
            if (dependentUnits == null) {
                dependentUnits = new WeakHashMap<ICompilationUnit, Object>();
                this.unfoundReferencedSourceFileDependencies.put(filenameNoPath, dependentUnits);
            }
            dependentUnits.put(compilationUnit, null);
        }
        finally {
            this.unfoundDependenciesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ICompilationUnit> getDependenciesOnUnfoundReferencedSourceFile(String sourceFilename) {
        this.unfoundDependenciesLock.readLock().lock();
        try {
            String filenameNoPath = new File(sourceFilename).getName();
            Map<ICompilationUnit, Object> dependentUnits = this.unfoundReferencedSourceFileDependencies.get(filenameNoPath);
            if (dependentUnits == null) {
                dependentUnits = Collections.emptyMap();
            }
            Set<ICompilationUnit> set = dependentUnits.keySet();
            return set;
        }
        finally {
            this.unfoundDependenciesLock.readLock().unlock();
        }
    }

    private void removeAnyUnfoundReferencedSourceFileDependency(ICompilationUnit compilationUnit) {
        for (Map<ICompilationUnit, Object> dependentUnits : this.unfoundReferencedSourceFileDependencies.values()) {
            dependentUnits.remove(compilationUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnyUnfoundDependencies(ICompilationUnit compilationUnit) {
        this.unfoundDependenciesLock.writeLock().lock();
        try {
            this.removeAnyUnfoundDefinitionDependency(compilationUnit);
            this.removeAnyUnfoundReferencedSourceFileDependency(compilationUnit);
        }
        finally {
            this.unfoundDependenciesLock.writeLock().unlock();
        }
    }

    public Set<ICompilationUnit> getDependenciesOnDefinition(String definitionBaseName) {
        HashSet<ICompilationUnit> dependentUnits = new HashSet<ICompilationUnit>();
        Set<ICompilationUnit> definingUnits = this.projectScope.getCompilationUnitsByDefinitionName(definitionBaseName);
        DependencyTypeSet dependencyTypes = DependencyTypeSet.allOf();
        for (ICompilationUnit definingUnit : definingUnits) {
            dependentUnits.addAll(this.dependencyGraph.getDirectReverseDependencies(definingUnit, dependencyTypes));
        }
        return dependentUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() {
        HashMap<ICompilerProject, Set<ICompilationUnit>> cusToUpdate = new HashMap<ICompilerProject, Set<ICompilationUnit>>();
        this.workspace.startIdleState();
        try {
            Collection<ICompilationUnit> compilationUnits = this.getCompilationUnits();
            this.workspace.notifyInvalidationListener(compilationUnits);
            for (ICompilationUnit compilationUnit : compilationUnits) {
                compilationUnit.clean(null, cusToUpdate, true);
            }
            this.scopeCaches.clear();
            this.initThreadLocalCaches();
        }
        finally {
            this.workspace.endIdleState(cusToUpdate);
        }
    }

    @Override
    public void delete() {
        Collection<ICompilationUnit> compilationUnits = this.getCompilationUnits();
        for (ICompilationUnit compilationUnit : compilationUnits) {
            this.workspace.removeCompilationUnit(compilationUnit);
        }
        this.workspace.deleteProject(this);
    }

    @Override
    public ISWFTarget createSWFTarget(ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) throws InterruptedException {
        return new AppSWFTarget(this, targetSettings, progressMonitor);
    }

    public void addDependency(ICompilationUnit from, ICompilationUnit to, DependencyTypeSet dt, String qname) {
        this.dependencyGraph.addDependency(from, to, dt, qname);
    }

    public void addDependency(ICompilationUnit from, ICompilationUnit to, DependencyType dt, String qname) {
        this.dependencyGraph.addDependency(from, to, dt, qname);
    }

    public void addDependency(ICompilationUnit from, ICompilationUnit to, DependencyType dt) {
        this.dependencyGraph.addDependency(from, to, dt);
    }

    public void removeDependencies(Collection<ICompilationUnit> units) {
        for (ICompilationUnit unit : units) {
            this.dependencyGraph.removeDependencies(unit);
        }
    }

    public Set<ICompilationUnit> getDependencies(ICompilationUnit cu) throws InterruptedException {
        cu.getOutgoingDependenciesRequest().get();
        return this.dependencyGraph.getDirectDependencies(cu);
    }

    public abstract void collectProblems(Collection<ICompilerProblem> var1);

    protected void collectConfigProblems(Collection<ICompilerProblem> problems) {
        problems.addAll(this.configManager.getProjectConfig(this).getProblems());
    }

    public ASScopeCache getCacheForScope(ASScope scope) {
        ASScopeCache scopeCache = null;
        Map<ASScope, WeakReference<ASScopeCache>> cache = this.threadLocalScopeCache.get();
        WeakReference<ASScopeCache> ref = cache.get(scope);
        ASScopeCache aSScopeCache = scopeCache = ref != null ? (ASScopeCache)ref.get() : null;
        if (scopeCache == null) {
            scopeCache = (ASScopeCache)this.scopeCaches.get(scope);
            cache.put(scope, new WeakReference<ASScopeCache>(scopeCache));
        }
        return scopeCache;
    }

    public void clearScopeCacheForCompilationUnit(ICompilationUnit compilationUnit) {
        Collection<IASScope> relatedScopes = this.projectScope.clearCompilationUnitScopeList(compilationUnit);
        if (relatedScopes == null) {
            return;
        }
        this.resetScopeCaches(relatedScopes);
    }

    public void resetScopeCacheForCompilationUnit(ICompilationUnit compilationUnit) {
        Collection<IASScope> relatedScopes = this.projectScope.getCompilationUnitScopeList(compilationUnit);
        assert (relatedScopes != null);
        if (relatedScopes.isEmpty()) {
            return;
        }
        this.resetScopeCaches(relatedScopes);
    }

    public void resetScopeCaches(Iterable<IASScope> scopes) {
        assert (scopes != null);
        for (IASScope scope : scopes) {
            this.scopeCaches.remove(scope);
        }
        this.initThreadLocalCaches();
    }

    public void addGlobalUsedNamespacesToNamespaceSet(Set<INamespaceDefinition> nsSet) {
        nsSet.add(NamespaceDefinition.getPublicNamespaceDefinition());
        if (this.useAS3) {
            nsSet.add(NamespaceDefinition.getAS3NamespaceDefinition());
        }
    }

    public abstract boolean handleAddedFile(File var1);

    public EmbedCompilationUnit getCompilationUnit(EmbedData data) {
        return this.embedCompilationUnits.get(data);
    }

    public final DependencyGraph getDependencyGraph() {
        return this.dependencyGraph;
    }

    public void addConfigVariables(Map<String, String> map) {
        this.configManager.addConfigVariables(map);
        this.clean();
    }

    public void addConfigVariable(String namespace, String expression) {
        this.configManager.addConfigVariable(namespace, expression);
        this.clean();
    }

    public IProjectConfigVariables getProjectConfigVariables() {
        return this.configManager.getProjectConfig(this);
    }

    @Override
    public IDefinition resolveQNameToDefinition(String qName) {
        assert (qName != null) : "qName can't be null.";
        Multiname multiname = Multiname.crackDottedQName(this, qName);
        return this.getScope().findDefinitionByName(multiname, false);
    }

    @Override
    public ICompilationUnit resolveQNameToCompilationUnit(String qName) {
        IDefinition definition = this.resolveQNameToDefinition(qName);
        if (definition == null) {
            return null;
        }
        return this.projectScope.getCompilationUnitForDefinition(definition);
    }

    public Collection<ICompilerProblem> getFatalProblems() {
        ArrayList<MissingBuiltinProblem> fatalProblems = null;
        for (IASLanguageConstants.BuiltinType builtinType : REQUIRED_BUILTINS) {
            if (this.getBuiltinType(builtinType) != null) continue;
            if (fatalProblems == null) {
                fatalProblems = new ArrayList<MissingBuiltinProblem>();
            }
            fatalProblems.add(new MissingBuiltinProblem(builtinType.getName()));
            break;
        }
        return fatalProblems == null ? Collections.emptyList() : fatalProblems;
    }

    @Override
    public ITypeDefinition getBuiltinType(IASLanguageConstants.BuiltinType type) {
        switch (type) {
            case OBJECT: {
                return this.projectScope.getObjectDefinition();
            }
            case STRING: {
                return this.projectScope.getStringDefinition();
            }
            case ARRAY: {
                return this.projectScope.getArrayDefinition();
            }
            case XML: {
                return this.projectScope.getXMLDefinition();
            }
            case XMLLIST: {
                return this.projectScope.getXMLListDefinition();
            }
            case BOOLEAN: {
                return this.projectScope.getBooleanDefinition();
            }
            case INT: {
                return this.projectScope.getIntDefinition();
            }
            case UINT: {
                return this.projectScope.getUIntDefinition();
            }
            case NUMBER: {
                return this.projectScope.getNumberDefinition();
            }
            case CLASS: {
                return this.projectScope.getClassDefinition();
            }
            case FUNCTION: {
                return this.projectScope.getFunctionDefinition();
            }
            case NAMESPACE: {
                return this.projectScope.getNamespaceDefinition();
            }
            case VECTOR: {
                return this.projectScope.getVectorDefinition();
            }
            case NULL: {
                return ClassDefinition.getNullClassDefinition();
            }
            case VOID: {
                return ClassDefinition.getVoidClassDefinition();
            }
            case Undefined: {
                return ClassDefinition.getUndefinedClassDefinition();
            }
            case ANY_TYPE: {
                return ClassDefinition.getAnyTypeClassDefinition();
            }
        }
        String name = type.getName();
        ITypeDefinition definition = (ITypeDefinition)this.getScope().findDefinitionByName(name);
        assert (definition != null || type == IASLanguageConstants.BuiltinType.FLOAT) : "Error, builtin type '" + type.getName() + "' can't be found!";
        return definition;
    }

    @Override
    public IDefinition getUndefinedValue() {
        return this.projectScope.getUndefinedValueDefinition();
    }

    public boolean getUseParallelCodeGeneration() {
        return this.useParallelCodeGen;
    }

    @Override
    public void setUseParallelCodeGeneration(boolean useParallelCodeGeneration) {
        this.useParallelCodeGen = useParallelCodeGeneration;
    }

    @Override
    public Set<ICompilationUnit> getDirectDependencies(ICompilationUnit cu) {
        return this.dependencyGraph.getDirectDependencies(cu);
    }

    @Override
    public Set<ICompilationUnit> getDirectReverseDependencies(ICompilationUnit cu, DependencyTypeSet types) {
        return this.dependencyGraph.getDirectReverseDependencies(cu, types);
    }

    @Override
    public boolean isInliningEnabled() {
        return this.enableInlining;
    }

    public void setEnableInlining(boolean enableInlining) {
        this.enableInlining = enableInlining;
        this.clean();
    }

    static class ScopeMakerFunction
    implements Function<ASScope, ASScopeCache> {
        CompilerProject project;

        public ScopeMakerFunction(CompilerProject project) {
            this.project = project;
        }

        public ASScopeCache apply(ASScope scope) {
            ASScopeCache cache = new ASScopeCache(this.project, scope);
            this.project.projectScope.addScopeToCompilationUnitScopeList(scope);
            return cache;
        }
    }
}

