/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.projects;

import com.adobe.flash.compiler.asdoc.IASDocBundleDelegate;
import com.adobe.flash.compiler.common.IFileSpecificationGetter;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.projects.ASSourceFileHandler;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DefinitionPriority;
import com.adobe.flash.compiler.internal.projects.LibraryPathManager;
import com.adobe.flash.compiler.internal.projects.SourceListManager;
import com.adobe.flash.compiler.internal.projects.SourcePathManager;
import com.adobe.flash.compiler.internal.units.CompilationUnitBase;
import com.adobe.flash.compiler.internal.units.InvisibleCompilationUnit;
import com.adobe.flash.compiler.internal.units.SourceCompilationUnitFactory;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.IASProject;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.IInvisibleCompilationUnit;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCFileEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ASProject
extends CompilerProject
implements IASProject {
    private final SourceListManager sourceListManager;
    private final SourcePathManager sourcePathManager = new SourcePathManager(this);
    private final SourceCompilationUnitFactory sourceCompilationUnitFactory;
    private final LibraryPathManager libraryPathManager;
    private final Map<IASProject, String> projectDependencies;
    private final Set<IASProject> dependingProjects;
    private final IASDocBundleDelegate asDocBundleDelegate;
    private int compatibilityVersionMajor;
    private int compatibilityVersionMinor;
    private int compatibilityVersionRevision;

    public ASProject(Workspace workspace, boolean useAS3) {
        this(workspace, useAS3, IASDocBundleDelegate.NIL_DELEGATE);
    }

    public ASProject(Workspace workspace, boolean useAS3, IASDocBundleDelegate asDocBundleDelegate) {
        super(workspace, useAS3);
        this.sourceListManager = new SourceListManager(this, this.sourcePathManager);
        this.sourceCompilationUnitFactory = new SourceCompilationUnitFactory(this);
        this.sourceCompilationUnitFactory.addHandler(ASSourceFileHandler.INSTANCE);
        this.libraryPathManager = new LibraryPathManager(this);
        this.projectDependencies = new HashMap<IASProject, String>();
        this.dependingProjects = new HashSet<IASProject>();
        this.asDocBundleDelegate = asDocBundleDelegate;
    }

    @Override
    public List<ISWC> getLibraries() {
        ImmutableList result = new ImmutableList.Builder().addAll(this.libraryPathManager.getLibrarySWCs()).build();
        return result;
    }

    @Override
    public void attachInternalLibrarySourcePath(File library, File sourceDir) {
        this.libraryPathManager.setLibrarySourcePath(library, sourceDir);
    }

    @Override
    public void attachExternalLibrarySourcePath(File library, File sourceDir) {
        this.libraryPathManager.setLibrarySourcePath(library, sourceDir);
    }

    @Override
    public String getAttachedSourceDirectory(String libraryFilename) {
        String result = this.libraryPathManager.getAttachedSourceDirectory(libraryFilename);
        return result;
    }

    @Override
    public void setSourcePath(List<File> paths) {
        this.sourcePathManager.setSourcePath(paths.toArray(new File[paths.size()]));
    }

    @Override
    public List<File> getSourcePath() {
        return this.sourcePathManager.getSourcePath();
    }

    public boolean addSourcePathFile(File f) {
        return this.sourcePathManager.addFile(f);
    }

    public boolean isFileOnSourcePath(File f) {
        return this.sourcePathManager.isFileOnSourcePath(f);
    }

    @Override
    public void setIncludeSources(File[] files) throws InterruptedException {
        this.sourceListManager.setSourceList(files);
    }

    @Override
    public void addIncludeSourceFile(File file) throws InterruptedException {
        this.addIncludeSourceFile(file, false);
    }

    @Override
    public void addIncludeSourceFile(File file, boolean overrideSourcePath) throws InterruptedException {
        this.sourceListManager.addSource(file, overrideSourcePath);
    }

    @Override
    public void removeIncludeSourceFile(File file) throws InterruptedException {
        this.sourceListManager.removeSource(file);
    }

    public void removeSourceFile(File f) {
        try {
            this.sourceListManager.removeSource(f);
            this.sourcePathManager.removeFile(f);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public SourceCompilationUnitFactory getSourceCompilationUnitFactory() {
        return this.sourceCompilationUnitFactory;
    }

    void updateCompilationUnitsForPathChange(Collection<ICompilationUnit> toRemove, Collection<ICompilationUnit> toAdd) {
        assert (toRemove != null);
        assert (toAdd != null);
        this.removeCompilationUnits(toRemove);
        this.addCompilationUnits(toAdd);
        for (ICompilationUnit unit : toAdd) {
            for (IDefinition definitionPromise : unit.getDefinitionPromises()) {
                this.getScope().addDefinition(definitionPromise);
            }
        }
    }

    @Override
    public Set<IASProject> getDependingProjects() {
        return this.dependingProjects;
    }

    @Override
    public void addProjectDependeny(IASProject project, String swcFilename) {
        assert (project instanceof ASProject) : "project dependency must be of type ASProject";
        ((ASProject)project).dependingProjects.add(this);
        this.projectDependencies.put(project, swcFilename);
    }

    @Override
    public void removeProjectDependeny(IASProject project) {
        assert (project instanceof ASProject) : "project dependency must be of type ASProject";
        ((ASProject)project).dependingProjects.remove(this);
        this.projectDependencies.remove(project);
    }

    @Override
    public void setDependencies(Map<IASProject, String> newIProjectsDependencies) {
        ImmutableSet newProjectDependencies = ImmutableSet.copyOf(newIProjectsDependencies.keySet());
        ImmutableSet dependenciesToRemove = ImmutableSet.copyOf((Collection)Sets.difference(this.projectDependencies.keySet(), (Set)newProjectDependencies));
        ImmutableSet dependenciesToAdd = ImmutableSet.copyOf((Collection)Sets.difference((Set)newProjectDependencies, this.projectDependencies.keySet()));
        for (IASProject projectDependency : dependenciesToRemove) {
            this.removeProjectDependeny(projectDependency);
        }
        for (IASProject projectDependency : dependenciesToAdd) {
            String swcFilename = newIProjectsDependencies.get(projectDependency);
            this.addProjectDependeny(projectDependency, swcFilename);
        }
    }

    void sourceListChange(Collection<ICompilationUnit> toRemove, Collection<ICompilationUnit> toAdd) throws InterruptedException {
        if (!toRemove.isEmpty() || !toAdd.isEmpty()) {
            this.removeCompilationUnits(toRemove);
            this.addCompilationUnitsAndUpdateDefinitions(toAdd);
        }
    }

    @Override
    public void collectProblems(Collection<ICompilerProblem> problems) {
        this.sourcePathManager.collectProblems(problems);
        this.sourceListManager.collectProblems(problems);
        this.libraryPathManager.collectProblems(problems);
        this.collectConfigProblems(problems);
    }

    public void collectionCompilationUnitsForRootSourceFile(File rootSourceFile, Collection<ICompilationUnit> units) {
        this.sourcePathManager.collectionCompilationUnitsForRootSourceFile(rootSourceFile, units);
        this.sourceListManager.collectionCompilationUnitsForRootSourceFile(rootSourceFile, units);
    }

    public boolean hasCompilationUnitForRootSourceFile(File rootSourceFile) {
        return this.sourcePathManager.hasCompilationUnitsForRootSourceFile(rootSourceFile) || this.sourceListManager.hasCompilationUnitsForRootSourceFile(rootSourceFile);
    }

    @Override
    public boolean invalidateLibraries(Collection<File> swcFiles) {
        return this.libraryPathManager.invalidate(swcFiles);
    }

    @Override
    public void invalidateLibrary(ISWC swc) {
        this.libraryPathManager.invalidate(swc);
    }

    @Override
    public boolean handleAddedFile(File addedFile) {
        return this.addSourcePathFile(addedFile);
    }

    @Override
    public String getSourceFileFromSourcePath(String file) {
        return this.sourcePathManager.getSourceFileFromSourcePath(file);
    }

    public ISWCFileEntry getSourceFileFromLibraryPath(String file) {
        return this.libraryPathManager.getFileEntryFromLibraryPath(file);
    }

    public IASDocBundleDelegate getASDocBundleDelegate() {
        return this.asDocBundleDelegate;
    }

    @Override
    public void setLibraries(List<File> libraries) {
        assert (libraries != null) : "Libraries may not be null";
        this.libraryPathManager.setLibraryPath(libraries.toArray(new File[libraries.size()]));
    }

    public void setCompatibilityVersion(int major, int minor, int revision) {
        this.compatibilityVersionMajor = major;
        this.compatibilityVersionMinor = minor;
        this.compatibilityVersionRevision = revision;
        this.clean();
    }

    @Override
    public Integer getCompatibilityVersion() {
        int compatibilityVersion = (this.compatibilityVersionMajor << 24) + (this.compatibilityVersionMinor << 16) + this.compatibilityVersionRevision;
        return compatibilityVersion != 0 ? Integer.valueOf(compatibilityVersion) : null;
    }

    @Override
    public String getCompatibilityVersionString() {
        int sum = this.compatibilityVersionMajor + this.compatibilityVersionMinor + this.compatibilityVersionRevision;
        if (sum == 0) {
            return null;
        }
        return this.compatibilityVersionMajor + "." + this.compatibilityVersionMinor + "." + this.compatibilityVersionRevision;
    }

    @Override
    public IInvisibleCompilationUnit createInvisibleCompilationUnit(String rootSourceFile, IFileSpecificationGetter fileSpecGetter) {
        SourcePathManager.QNameFile qNameFile = this.sourcePathManager.computeQNameForFilename(rootSourceFile);
        if (qNameFile == null) {
            return null;
        }
        CompilationUnitBase invisibleCUDelegate = this.createInvisibleCompilationUnit(qNameFile);
        if (invisibleCUDelegate == null) {
            return null;
        }
        return new InvisibleCompilationUnit(invisibleCUDelegate, fileSpecGetter);
    }

    @Override
    public IInvisibleCompilationUnit createInvisibleCompilationUnit(String rootSourceFile, IFileSpecificationGetter fileSpecGetter, String qName) {
        SourcePathManager.QNameFile qNameFile = new SourcePathManager.QNameFile(qName, new File(rootSourceFile), null, 0);
        CompilationUnitBase invisibleCUDelegate = this.createInvisibleCompilationUnit(qNameFile);
        if (invisibleCUDelegate == null) {
            return null;
        }
        return new InvisibleCompilationUnit(invisibleCUDelegate, fileSpecGetter);
    }

    private CompilationUnitBase createInvisibleCompilationUnit(SourcePathManager.QNameFile qNameFile) {
        SourceCompilationUnitFactory compilationUnitFactory = this.getSourceCompilationUnitFactory();
        if (!compilationUnitFactory.canCreateCompilationUnit(qNameFile.file)) {
            return null;
        }
        CompilationUnitBase newCU = (CompilationUnitBase)this.getSourceCompilationUnitFactory().createCompilationUnit(qNameFile.file, DefinitionPriority.BasePriority.SOURCE_PATH, 0, qNameFile.qName, qNameFile.locale);
        assert (newCU != null) : "canCreateCompilationUnit should have returned false if createCompilationUnit returns null!";
        this.addCompilationUnit(newCU);
        return newCU;
    }

    @Override
    public boolean isAssetEmbeddingSupported() {
        return true;
    }

    @Override
    public boolean isSupportedSourceFileType(String fileExtension) {
        return this.sourceCompilationUnitFactory.canCreateCompilationUnitForFileType(fileExtension);
    }
}

