/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.mxml;

import com.adobe.flash.compiler.common.MutablePrefixMap;
import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.filespecs.FileSpecification;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLToken;
import com.adobe.flash.compiler.internal.parsing.mxml.PrivateTagDetector;
import com.adobe.flash.compiler.internal.parsing.mxml.RawMXMLTokenizer;
import com.adobe.flash.compiler.parsing.IMXMLToken;
import com.adobe.flash.compiler.parsing.IMXMLTokenizer;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem2;
import com.adobe.flash.utils.NonLockingStringReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class MXMLTokenizer
implements IMXMLTokenizer,
Closeable {
    protected int startOffset;
    private int tagDepth = -1;
    private boolean inTagContent = false;
    private RawMXMLTokenizer tokenizer = new RawMXMLTokenizer();
    private PrivateTagDetector detector;
    protected MXMLToken xmlNSToken = null;
    protected MutablePrefixMap rootPrefixMap;
    private MXMLToken postRepairToken = null;
    private boolean isRepairing = true;
    private boolean wasRepaired = false;
    private static final int SIZE = 100;
    private List<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
    private String path;
    private MXMLToken lastToken = null;
    private static final String SUB_SYSTEM = "MXMLTokenizer";

    public MXMLTokenizer(String path) {
        this.setDetector(new PrivateTagDetector());
        this.rootPrefixMap = new MutablePrefixMap();
        this.path = path;
    }

    public MXMLTokenizer() {
        this("");
    }

    public MXMLTokenizer(IFileSpecification specification) {
        this(specification.getPath());
    }

    public MXMLTokenizer(int startOffset) {
        this("");
        this.startOffset = startOffset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setReader(Reader reader) {
        this.tokenizer.reset();
        this.tokenizer.yyreset(reader);
    }

    @Override
    public void close() throws IOException {
        if (this.tokenizer != null) {
            this.tokenizer.reset();
            this.tokenizer.yyclose();
        }
    }

    public PrefixMap getPrefixMap() {
        return this.rootPrefixMap;
    }

    @Override
    public void setIsRepairing(boolean isRepairing) {
        this.isRepairing = isRepairing;
    }

    protected void setDetector(PrivateTagDetector detector) {
        this.detector = detector;
    }

    protected void addPrefix(String prefix, String ns) {
        this.detector.addPrefix(prefix, ns);
    }

    @Override
    public IMXMLToken[] getTokens(Reader reader) {
        List<MXMLToken> parseTokens = this.parseTokens(reader);
        return parseTokens.toArray(new IMXMLToken[0]);
    }

    @Override
    public IMXMLToken[] getTokens(String range) {
        List<MXMLToken> parseTokens = this.parseTokens(new NonLockingStringReader(range));
        return parseTokens.toArray(new IMXMLToken[0]);
    }

    public boolean hasTokenizationProblems() {
        return this.tokenizer.hasProblems() || this.problems.size() > 0;
    }

    public PrefixMap getRootTagPrefixMap() {
        boolean cont = true;
        do {
            MXMLToken token;
            if ((token = this.nextToken()) != null && !token.isTagEnd()) continue;
            cont = false;
        } while (cont);
        return this.rootPrefixMap;
    }

    public List<ICompilerProblem> getTokenizationProblems() {
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>(this.problems);
        problems.addAll(this.tokenizer.getProblems());
        return problems;
    }

    private final MXMLToken nextTokenInternal() {
        MXMLToken retVal = null;
        boolean cont = true;
        while (cont) {
            InternalCompilerProblem2 problem;
            try {
                MXMLToken token;
                MXMLToken mXMLToken = token = this.tokenizer.hasBufferToken() ? (MXMLToken)this.tokenizer.getBufferToken() : (MXMLToken)this.tokenizer.nextToken();
                if (token == null) {
                    return null;
                }
                MXMLToken mxmlToken = this.processToken(token);
                if (mxmlToken == null) continue;
                retVal = mxmlToken;
                return retVal;
            }
            catch (Exception e) {
                problem = new InternalCompilerProblem2(this.path, e, SUB_SYSTEM);
                this.problems.add(problem);
                return null;
            }
            catch (Error e) {
                problem = new InternalCompilerProblem2(this.path, e, SUB_SYSTEM);
                this.problems.add(problem);
                return null;
            }
        }
        return null;
    }

    public MXMLToken nextToken() {
        if (this.isRepairing) {
            if (this.postRepairToken != null) {
                MXMLToken retVal = this.postRepairToken;
                this.postRepairToken = null;
                return retVal;
            }
            MXMLToken mxmlToken = this.nextTokenInternal();
            MXMLToken addedToken = this.analyzeForEndTagProblems(mxmlToken);
            if (addedToken != null) {
                this.postRepairToken = mxmlToken;
                this.wasRepaired = true;
                return addedToken;
            }
            return mxmlToken;
        }
        return this.nextTokenInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MXMLToken> parseTokens(Reader input) {
        this.wasRepaired = false;
        this.setReader(input);
        this.tokenizer.setOffset(this.startOffset);
        MXMLToken token = null;
        ArrayList<MXMLToken> list = new ArrayList<MXMLToken>(100);
        try {
            do {
                if ((token = this.nextToken()) == null) continue;
                this.buildTokenList(token.clone(), list);
            } while (token != null);
            this.lastToken = null;
            ArrayList<MXMLToken> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                this.detector = null;
                this.tokenizer.yyclose();
            }
            catch (IOException e) {
                InternalCompilerProblem2 problem = new InternalCompilerProblem2(this.path, e, SUB_SYSTEM);
                this.problems.add(problem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MXMLToken analyzeForEndTagProblems(MXMLToken currentToken) {
        if (currentToken == null) {
            return null;
        }
        try {
            if (currentToken.isTagStart() && this.lastToken != null) {
                switch (this.lastToken.getType()) {
                    case -1: 
                    case 28: 
                    case 30: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 136: 
                    case 137: 
                    case 142: 
                    case 143: {
                        MXMLToken mXMLToken = null;
                        return mXMLToken;
                    }
                }
                MXMLToken mXMLToken = null;
                return mXMLToken;
            }
            MXMLToken mXMLToken = null;
            return mXMLToken;
        }
        finally {
            this.lastToken = currentToken;
        }
    }

    public boolean tokensWereRepaired() {
        return this.wasRepaired;
    }

    private MXMLToken processToken(MXMLToken token) {
        switch (token.getType()) {
            case 138: {
                ++this.tagDepth;
                this.inTagContent = true;
                return token;
            }
            case 139: {
                --this.tagDepth;
                this.inTagContent = true;
                return token;
            }
            case 142: 
            case 143: {
                this.inTagContent = false;
                return token;
            }
            case 30: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 144: 
            case 147: {
                return token;
            }
            case 141: {
                this.xmlNSToken = null;
                return token;
            }
            case 145: {
                token.setType(141);
                this.xmlNSToken = token;
                return token;
            }
            case 137: {
                if (this.xmlNSToken != null && this.tagDepth == 0) {
                    String nsText;
                    String prefix = "";
                    String text = this.xmlNSToken.getText();
                    if (text.length() > 5) {
                        prefix = text.substring(6);
                    }
                    String ns = (nsText = token.getText()).length() > 1 ? nsText.substring(1, nsText.length() - 1) : "";
                    this.rootPrefixMap.add(prefix, ns);
                    if (this.detector != null) {
                        this.detector.addPrefix(prefix, ns);
                    }
                }
                return token;
            }
            case 146: {
                return null;
            }
        }
        if (!(this.tagDepth == 0 || this.tokenizer.isInE4XDatabinding() || this.inTagContent || !token.isLiteral() && token.getType() != 15)) {
            token.setType(136);
        }
        return token;
    }

    protected void buildTokenList(MXMLToken token, List<MXMLToken> list) {
        if (token != null) {
            list.add(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileSpecification fileSpec = new FileSpecification(args[0]);
        MXMLTokenizer tokenizer = new MXMLTokenizer(fileSpec.getPath());
        try {
            List<MXMLToken> tokens = tokenizer.parseTokens(fileSpec.createReader());
            for (MXMLToken token : tokens) {
                System.out.println(token.toDumpString());
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)tokenizer);
        }
    }
}

