/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.mxml;

import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.parsing.ICMToken;
import com.adobe.flash.compiler.parsing.IMXMLToken;

public class MXMLToken
extends ASToken
implements IMXMLToken {
    public MXMLToken(int tokenType, int start, int end, int line, int column, CharSequence tokenText) {
        super(tokenType, start, end, line, column, tokenText);
    }

    public MXMLToken(MXMLToken other) {
        super(other);
    }

    public MXMLToken(ASToken other) {
        super(other);
    }

    @Override
    public ICMToken changeType(int type) {
        return new MXMLToken(type, this.getStart(), this.getEnd(), this.getLine(), this.getColumn(), this.getText());
    }

    @Override
    public MXMLToken clone() {
        return new MXMLToken(this);
    }

    public final boolean isASToken() {
        return !MXMLToken.isE4X(this.type);
    }

    public final boolean isEntity() {
        switch (this.type) {
            case 133: 
            case 134: 
            case 135: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IMXMLToken.MXMLTokenKind getMXMLTokenKind() {
        switch (this.getType()) {
            case 138: {
                return IMXMLToken.MXMLTokenKind.TAG_OPEN_START;
            }
            case 139: {
                return IMXMLToken.MXMLTokenKind.TAG_CLOSE_START;
            }
            case 142: {
                return IMXMLToken.MXMLTokenKind.TAG_END;
            }
            case 143: {
                return IMXMLToken.MXMLTokenKind.EMPTY_TAG_END;
            }
            case 30: {
                return IMXMLToken.MXMLTokenKind.MXML_BLOB;
            }
            case 141: {
                return IMXMLToken.MXMLTokenKind.NAME;
            }
            case 144: {
                return IMXMLToken.MXMLTokenKind.EQUALS;
            }
            case 137: {
                return IMXMLToken.MXMLTokenKind.STRING;
            }
            case 136: {
                return IMXMLToken.MXMLTokenKind.TEXT;
            }
            case 130: {
                return IMXMLToken.MXMLTokenKind.COMMENT;
            }
            case 131: {
                return IMXMLToken.MXMLTokenKind.CDATA;
            }
            case 28: {
                return IMXMLToken.MXMLTokenKind.COMMENT;
            }
            case 147: {
                return IMXMLToken.MXMLTokenKind.STATE_NAME;
            }
            case 133: 
            case 134: 
            case 135: {
                return IMXMLToken.MXMLTokenKind.ENTITY;
            }
            case 129: {
                return IMXMLToken.MXMLTokenKind.WHITESPACE;
            }
        }
        if (this.isASToken()) {
            return IMXMLToken.MXMLTokenKind.ACTIONSCRIPT;
        }
        return IMXMLToken.MXMLTokenKind.UNKNOWN;
    }

    public static final boolean isTagStart(int type) {
        switch (type) {
            case 138: 
            case 139: {
                return true;
            }
        }
        return false;
    }

    public final boolean isTagStart() {
        return MXMLToken.isTagStart(this.getType());
    }

    public static final boolean isTagEnd(int type) {
        switch (type) {
            case 142: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    public final boolean isTagEnd() {
        return MXMLToken.isTagEnd(this.getType());
    }

    public static final boolean isStructureTag(int type) {
        switch (type) {
            case 138: 
            case 139: 
            case 142: 
            case 143: {
                return true;
            }
        }
        return false;
    }

    public final boolean isStructureTag() {
        return MXMLToken.isStructureTag(this.getType());
    }

    public static final boolean canFollowCloseTag(int type) {
        switch (type) {
            case 28: 
            case 30: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 136: 
            case 138: 
            case 139: {
                return true;
            }
        }
        return false;
    }

    public final boolean canFollowCloseTag() {
        return MXMLToken.canFollowCloseTag(this.getType());
    }

    @Override
    public String getTypeString() {
        switch (this.getType()) {
            case 129: {
                return "TOKEN_WHITESPACE";
            }
            case 138: {
                return "TOKEN_OPEN_TAG_START";
            }
            case 139: {
                return "TOKEN_CLOSE_TAG_START";
            }
            case 142: {
                return "TOKEN_TAG_END";
            }
            case 143: {
                return "TOKEN_EMPTY_TAG_END";
            }
            case 141: {
                return "TOKEN_NAME";
            }
            case 144: {
                return "TOKEN_EQUALS";
            }
            case 137: {
                return "TOKEN_STRING";
            }
            case 136: {
                return "TOKEN_TEXT";
            }
            case 131: {
                return "TOKEN_CDATA";
            }
            case 28: {
                return "TOKEN_ASDOC_COMMENT";
            }
            case 130: {
                return "TOKEN_COMMENT";
            }
            case 30: {
                return "MXML_BLOB";
            }
            case 147: {
                return "TOKEN_STATE_NAME";
            }
            case 133: 
            case 134: 
            case 135: {
                return "TOKEN_ENTITY";
            }
            case 132: {
                return "TOKEN_PROCESSING_INSTRUCTION";
            }
        }
        return super.getTypeString();
    }
}

