/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.mxml;

import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTagDataPayload;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.SyntaxProblem;
import com.adobe.flash.utils.FastStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class MXMLTagDataDepth {
    private static final MXMLTagAttributeData[] MXML_TAG_ATTRIBUTE_DATAS = new MXMLTagAttributeData[0];
    private MXMLTagDataDepth parent;
    private ArrayList<MXMLTagData> openTags;
    private FastStack<MXMLTagData> closeTags;
    private int depth;

    public MXMLTagDataDepth(int depth) {
        this.depth = depth;
        this.openTags = new ArrayList();
        this.closeTags = new FastStack();
    }

    public final void addOpenTag(MXMLTagData openTag) {
        this.openTags.add(openTag);
    }

    public final void addCloseTag(MXMLTagData closeTag) {
        this.closeTags.push(closeTag);
    }

    public final void setParent(MXMLTagDataDepth parent) {
        this.parent = parent;
    }

    public final int getDepth() {
        return this.depth;
    }

    final void ensureOrder() {
        Collections.sort(this.openTags, new MXMLTagDataComparator());
        Collections.sort(this.closeTags, Collections.reverseOrder(new MXMLTagDataComparator()));
    }

    public final boolean balance(List<MXMLTagDataPayload> payload, Map<MXMLTagData, PrefixMap> prefixMap, MXMLData mxmlData, MXMLUnitData[] data, Collection<ICompilerProblem> problems, IFileSpecification fileSpec) {
        this.ensureOrder();
        int size = this.openTags.size();
        boolean didNonPayloadRepair = false;
        block0: for (int i = 0; i < size; ++i) {
            MXMLTagData openTag = this.openTags.get(i);
            if (!this.closeTags.isEmpty()) {
                MXMLTagData closeTag = this.closeTags.peek();
                if (closeTag.getName().compareTo(openTag.getName()) != 0) {
                    int insertOffset = -1;
                    while (!this.closeTags.isEmpty()) {
                        MXMLTagData pop = this.closeTags.pop();
                        if (pop.getName().compareTo(openTag.getName()) != 0) {
                            insertOffset = pop.getIndex();
                            if (this.parent != null) {
                                this.parent.addCloseTag(pop);
                                continue;
                            }
                            FakeMXMLTagData tagData = new FakeMXMLTagData(pop.getName(), false, false);
                            tagData.setOffsets(pop.getAbsoluteEnd(), pop.getAbsoluteEnd());
                            tagData.setLine(pop.getLine());
                            tagData.setColumn(pop.getColumn());
                            payload.add(new MXMLTagDataPayload(tagData, insertOffset - 1));
                            problems.add(this.produceProblemFromToken(tagData, fileSpec));
                            if (i + 1 >= size) continue;
                            openTag = this.openTags.get(++i);
                            continue;
                        }
                        insertOffset = -1;
                        break;
                    }
                    if (insertOffset == -1) continue;
                    if (!openTag.hasExplicitCloseTag()) {
                        openTag.setEmptyTag();
                        didNonPayloadRepair = true;
                        problems.add(this.produceProblemFromToken(openTag, fileSpec));
                        continue;
                    }
                    FakeMXMLTagData tagData = new FakeMXMLTagData(openTag.getName(), true, false);
                    tagData.setOffsets(openTag.getAbsoluteEnd(), openTag.getAbsoluteEnd());
                    tagData.setLine(openTag.getLine());
                    tagData.setColumn(openTag.getColumn());
                    payload.add(new MXMLTagDataPayload(tagData, insertOffset));
                    problems.add(this.produceProblemFromToken(tagData, fileSpec));
                    continue;
                }
                this.closeTags.pop();
                continue;
            }
            if (this.parent != null) {
                this.parent.addOpenTag(openTag);
                continue;
            }
            int tokenSize = data.length;
            for (int pos = openTag.getIndex(); pos < tokenSize; ++pos) {
                MXMLUnitData currToken = data[pos];
                if (!(currToken instanceof MXMLTagData) || ((MXMLTagData)currToken).hasExplicitCloseTag()) continue;
                problems.add(new SyntaxProblem(currToken, ((MXMLTagData)currToken).getName()));
                FakeMXMLTagData fakeMXMLTagData = new FakeMXMLTagData((MXMLTagData)currToken, true);
                data[pos] = fakeMXMLTagData;
                prefixMap.remove((MXMLTagData)currToken);
                didNonPayloadRepair = true;
                PrefixMap map = ((MXMLTagData)currToken).getPrefixMap();
                if (map == null) continue block0;
                prefixMap.put(fakeMXMLTagData, map);
                continue block0;
            }
        }
        if (this.parent != null) {
            while (!this.closeTags.isEmpty()) {
                this.parent.addCloseTag(this.closeTags.pop());
            }
        }
        return didNonPayloadRepair;
    }

    private ICompilerProblem produceProblemFromToken(MXMLTagData tagData, IFileSpecification fileSpec) {
        return new SyntaxProblem(tagData, tagData.getName());
    }

    private class FakeMXMLTagData
    extends MXMLTagData {
        public FakeMXMLTagData(String tagName, boolean closeTag, boolean emptyTag) {
            this.tagName = tagName;
            this.nameType = closeTag ? 139 : 138;
            this.emptyTag = emptyTag;
        }

        public FakeMXMLTagData(MXMLTagData data, boolean emptyTag) {
            super(data);
            this.emptyTag = emptyTag;
        }

        @Override
        public String getRawAttributeValue(String attributeName) {
            return null;
        }

        @Override
        public MXMLTagAttributeData[] getAttributeDatas() {
            return MXML_TAG_ATTRIBUTE_DATAS;
        }

        @Override
        public boolean isImplicit() {
            return true;
        }
    }

    final class MXMLTagDataComparator
    implements Comparator<MXMLTagData> {
        MXMLTagDataComparator() {
        }

        @Override
        public final int compare(MXMLTagData o1, MXMLTagData o2) {
            if (o1.getIndex() == o2.getIndex()) {
                return 0;
            }
            if (o1.getIndex() < o2.getIndex()) {
                return -1;
            }
            return 1;
        }
    }
}

