/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.mxml;

import com.adobe.flash.compiler.common.PrefixMap;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTagDataDepth;
import com.adobe.flash.compiler.internal.parsing.mxml.MXMLTagDataPayload;
import com.adobe.flash.compiler.mxml.MXMLData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class BalancingMXMLProcessor {
    private ArrayList<MXMLTagDataDepth> depths = new ArrayList();
    private Collection<ICompilerProblem> problems;
    private IFileSpecification spec;
    private boolean wasRepaired = false;

    public BalancingMXMLProcessor(IFileSpecification specification, Collection<ICompilerProblem> problems) {
        this.setFileSpecification(specification);
        this.problems = problems;
    }

    public void initialize(MXMLUnitData[] data) {
        int index = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] instanceof MXMLTagData) || ((MXMLTagData)data[i]).isEmptyTag()) continue;
            if (((MXMLTagData)data[i]).isOpenTag()) {
                this.addOpenTag((MXMLTagData)data[i], index);
                ++index;
                continue;
            }
            this.addCloseTag((MXMLTagData)data[i], --index);
        }
    }

    public final void setFileSpecification(IFileSpecification specification) {
        this.spec = specification;
    }

    public MXMLUnitData[] balance(MXMLUnitData[] data, MXMLData mxmlData, Map<MXMLTagData, PrefixMap> map) {
        ArrayList<MXMLTagDataPayload> payload = new ArrayList<MXMLTagDataPayload>();
        for (int i = this.depths.size() - 1; i >= 0; --i) {
            boolean b = this.depths.get(i).balance(payload, map, mxmlData, data, this.problems, this.spec);
            if (!b) continue;
            this.wasRepaired = true;
        }
        Collections.sort(payload, Collections.reverseOrder());
        if (payload.size() > 0) {
            this.wasRepaired = true;
            ArrayList<MXMLUnitData> newTags = new ArrayList<MXMLUnitData>(Arrays.asList(data));
            for (int i = payload.size() - 1; i >= 0; --i) {
                MXMLTagDataPayload tokenPayload = payload.get(i);
                newTags.add(tokenPayload.getPosition(), tokenPayload.getTagData());
            }
            return newTags.toArray(new MXMLUnitData[0]);
        }
        return data;
    }

    public boolean wasRepaired() {
        return this.wasRepaired;
    }

    private final MXMLTagDataDepth getDepth(int depth) {
        MXMLTagDataDepth dep = null;
        if (depth < 0) {
            depth *= -1;
        }
        if (this.depths.size() > depth) {
            dep = this.depths.get(depth);
        } else {
            dep = new MXMLTagDataDepth(depth);
            if (depth - 1 >= 0 && depth - 1 < this.depths.size()) {
                dep.setParent(this.depths.get(depth - 1));
            }
            this.depths.add(dep);
        }
        return dep;
    }

    public void addOpenTag(MXMLTagData openTag, int depth) {
        MXMLTagDataDepth dep = this.getDepth(depth);
        dep.addOpenTag(openTag);
    }

    public void addCloseTag(MXMLTagData closeTag, int depth) {
        MXMLTagDataDepth dep = this.getDepth(depth);
        dep.addCloseTag(closeTag);
    }
}

