/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.as;

import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.BaseRepairingTokenBuffer;
import com.adobe.flash.compiler.internal.parsing.as.IRepairingTokenBuffer;
import com.adobe.flash.compiler.internal.parsing.as.StreamingASTokenizer;
import com.adobe.flash.compiler.parsing.IASToken;
import java.util.ArrayList;
import java.util.HashMap;

public final class StreamingTokenBuffer
extends BaseRepairingTokenBuffer
implements IRepairingTokenBuffer {
    private static final int REWIND_BUFFER_SIZE = 10;
    private final StreamingASTokenizer tokenizer;
    private final ArrayList<ASToken> buffer;
    private final HashMap<Integer, ASToken> asdocs;

    public StreamingTokenBuffer(StreamingASTokenizer tokenizer) {
        super(tokenizer.getSourcePath());
        this.tokenizer = tokenizer;
        this.buffer = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            this.buffer.add(this.eofToken);
        }
        this.asdocs = new HashMap();
    }

    public String getSourcePath() {
        return this.tokenizer.getSourcePath();
    }

    @Override
    public final boolean insertSemicolon(boolean isNextToken) {
        if (!this.insertSemis) {
            return false;
        }
        if (isNextToken) {
            this.onSemicolonInserted();
        }
        return true;
    }

    private final void fill(int toSize) {
        while (10 + toSize > this.buffer.size()) {
            ASToken next = this.tokenizer.next();
            if (next != null && next.getType() == 28) {
                this.asdocs.put(this.position + this.buffer.size() - 10, next);
                continue;
            }
            this.buffer.add(next != null ? next : this.eofToken);
        }
    }

    @Override
    public void rewind(int toPosition) {
        int steps = this.position - toPosition;
        assert (steps >= 0) : "invalid rewind position";
        if (steps > 10) {
            throw new IllegalStateException(String.format("Token buffer can't rewind that far. Max rewind is %d, but got %d.", 10, steps));
        }
        for (int i = 0; i < steps; ++i) {
            this.buffer.add(0, this.eofToken);
        }
        this.position = toPosition;
    }

    @Override
    public final void consume() {
        if (this.nextIsSemicolon) {
            this.nextIsSemicolon = false;
        } else {
            this.buffer.remove(0);
        }
        ++this.position;
    }

    @Override
    protected ASToken lookAheadSkipInsertedSemicolon(int i) {
        this.fill(i);
        ASToken result = this.buffer.get(10 + i - 1);
        result.lock();
        return result;
    }

    @Override
    public ASToken previous() {
        return this.buffer.get(9);
    }

    @Override
    public boolean matchOptionalSemicolon() {
        ASToken nextToken = this.LT(1);
        if (nextToken != null && nextToken.getType() != 1) {
            if (nextToken.getType() == 54) {
                this.consume();
            } else if (nextToken.getTokenKind() != IASToken.ASTokenKind.SCOPE_CLOSE) {
                if (nextToken.getLine() > this.previous().getLine()) {
                    this.insertSemicolon(false);
                } else if (!nextToken.getSourcePath().equals(this.previous().getSourcePath())) {
                    this.insertSemicolon(false);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public final boolean handlesASDocSpecially() {
        return true;
    }

    @Override
    public final ASToken getASDocToken(int i) {
        return this.asdocs.get(this.position + i - 1);
    }
}

