/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.as;

import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.MetadataToken;
import com.adobe.flash.compiler.internal.parsing.as.MetadataTokenizer;
import com.adobe.flash.compiler.parsing.ICMToken;
import java.util.ArrayList;
import java.util.List;

public class MetaDataPayloadToken
extends ASToken {
    private List<MetadataToken> payload;
    private MetadataTokenizer tokenTransformer;

    public MetaDataPayloadToken(ASToken token) {
        super(36, token.getStart(), token.getEnd(), token.getLine(), token.getColumn(), "");
        this.setSourcePath(token.getSourcePath());
        this.payload = new ArrayList<MetadataToken>(5);
        this.tokenTransformer = new MetadataTokenizer();
        this.addToken(token, null);
    }

    public MetaDataPayloadToken(MetaDataPayloadToken token) {
        super(36, token.getStart(), token.getEnd(), token.getLine(), token.getColumn(), "");
        this.setSourcePath(token.getSourcePath());
        this.payload = token.payload;
    }

    @Override
    public ASToken clone() {
        return new MetaDataPayloadToken(this);
    }

    public void addToken(ASToken token, ASToken followingToken) {
        MetadataToken metadataToken = this.tokenTransformer.transformToken(token, followingToken);
        if (metadataToken != null) {
            this.payload.add(metadataToken);
            this.setEnd(token.getEnd());
        }
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (MetadataToken token : this.payload) {
            builder.append(token.getText());
        }
        return builder.toString();
    }

    public List<MetadataToken> getPayload() {
        return this.payload;
    }

    @Override
    public ICMToken changeType(int type) {
        return this;
    }

    @Override
    public void adjustLocation(int offsetAdjustment, int lineAdjustment, int columnAdjustment) {
        super.adjustLocation(offsetAdjustment, lineAdjustment, columnAdjustment);
        for (MetadataToken token : this.getPayload()) {
            token.adjustLocation(offsetAdjustment, lineAdjustment, columnAdjustment);
        }
    }
}

