/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.as;

import antlr.Token;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.internal.parsing.TokenBase;
import com.adobe.flash.compiler.parsing.ICMToken;
import com.adobe.flash.compiler.problems.BadCharacterProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRawTokenizer<T extends TokenBase> {
    protected int aggregateStart;
    protected int aggregateStartLine;
    protected int aggregateStartColumn;
    protected StringBuilder aggregateContents;
    private T lastToken = null;
    private final List<ICompilerProblem> problems;
    private final T[] tokenPool = this.initTokenPool();
    private int tokenPoolIndex = 5;
    private String sourcePath;

    public BaseRawTokenizer() {
        this.problems = new ArrayList<ICompilerProblem>();
    }

    protected abstract T[] initTokenPool();

    protected abstract String yytext();

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    protected abstract int getOffset();

    protected abstract int getLine();

    protected abstract int getColumn();

    protected void addBadCharacterProblem(String badChar) {
        ISourceLocation location = this.getCurrentSourceLocation(badChar.length());
        BadCharacterProblem problem = new BadCharacterProblem(location, badChar);
        this.problems.add(problem);
    }

    protected final ISourceLocation getCurrentSourceLocation(int tokenLength) {
        return new SourceLocation(this.getSourcePath(), this.getOffset(), this.getOffset() + tokenLength, this.getLine(), this.getColumn());
    }

    public boolean hasProblems() {
        return this.problems.size() > 0;
    }

    public List<ICompilerProblem> getProblems() {
        return this.problems;
    }

    protected T buildToken(int type, int start, int end, int line, int column, CharSequence text) {
        T token = this.fetchToken(type, start, start + text.length(), this.getLine(), this.getColumn(), text);
        this.setLastToken(token);
        return token;
    }

    public void reset() {
        this.lastToken = null;
        this.aggregateContents = null;
        this.aggregateStart = -1;
        this.aggregateStartLine = -1;
        this.aggregateStartColumn = -1;
    }

    public final int getLastTokenType() {
        return this.lastToken != null ? ((Token)this.lastToken).getType() : -1;
    }

    public final String getLastTokenText() {
        return this.lastToken != null ? ((TokenBase)this.lastToken).getText() : "";
    }

    protected void setLastToken(T token) {
        this.lastToken = token;
    }

    protected final void startAggregate() {
        this.aggregateStart = this.getOffset();
        this.aggregateStartLine = this.getLine();
        this.aggregateStartColumn = this.getColumn();
        this.aggregateContents = new StringBuilder();
        this.fillBuffer(this.aggregateContents);
    }

    protected final void startAggregate(Token token) {
        this.aggregateStart = ((ICMToken)((Object)token)).getStart();
        this.aggregateStartLine = ((ICMToken)((Object)token)).getLine();
        this.aggregateStartColumn = ((ICMToken)((Object)token)).getColumn();
        this.aggregateContents = new StringBuilder();
        this.aggregateContents.append(token.getText());
    }

    protected void continueAggregate() {
        if (this.aggregateContents != null) {
            this.fillBuffer(this.aggregateContents);
        }
    }

    protected final void continueAggregate(Token token) {
        if (this.aggregateContents != null) {
            this.aggregateContents.append(token.getText());
        }
    }

    protected final void continueAggregate(String text) {
        if (this.aggregateContents != null) {
            this.aggregateContents.append(text);
        }
    }

    protected final void continueAggregate(char c) {
        if (this.aggregateContents != null) {
            this.aggregateContents.append(c);
        }
    }

    protected final void continueAggregate(char[] chars) {
        if (this.aggregateContents != null) {
            this.aggregateContents.append(chars);
        }
    }

    protected abstract void fillBuffer(StringBuilder var1);

    protected final boolean hasAggregateContents() {
        return this.aggregateContents != null;
    }

    public final void setReuseLastToken() {
        if (this.tokenPoolIndex > 0) {
            --this.tokenPoolIndex;
        }
    }

    protected final T fetchToken(int type, int start, int end, int line, int column, CharSequence text) {
        T potential;
        if (this.tokenPool.length == 0) {
            return this.newToken(type, start, end, line, column, text);
        }
        if (this.tokenPoolIndex >= this.tokenPool.length) {
            this.tokenPoolIndex = 0;
        }
        if ((potential = this.tokenPool[this.tokenPoolIndex]) != null && !((TokenBase)potential).isLocked()) {
            ((TokenBase)potential).reuse(type, start, end, line, column, text);
        } else {
            this.tokenPool[this.tokenPoolIndex] = this.newToken(type, start, end, line, column, text);
        }
        return this.tokenPool[this.tokenPoolIndex++];
    }

    protected abstract T newToken(int var1, int var2, int var3, int var4, int var5, CharSequence var6);

    public T buildAggregateToken(int type) {
        if (this.aggregateContents == null) {
            return null;
        }
        T token = this.fetchToken(type, this.aggregateStart, this.aggregateStart + this.aggregateContents.length(), this.aggregateStartLine, this.aggregateStartColumn, this.aggregateContents.toString());
        this.aggregateContents = null;
        this.setLastToken(token);
        return token;
    }

    public final T buildToken(int type) {
        String text = this.yytext();
        int start = this.getOffset();
        T token = this.fetchToken(type, start, start + text.length(), this.getLine(), this.getColumn(), text);
        this.setLastToken(token);
        return token;
    }

    public T buildToken(int type, String text) {
        int start = this.getOffset();
        T token = this.fetchToken(type, start, start + text.length(), this.getLine(), this.getColumn(), text);
        this.setLastToken(token);
        return token;
    }

    protected String getContext(int line) {
        return this.yytext() + " (" + line + ")";
    }
}

