/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.as;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.BaseRawTokenizer;
import com.adobe.flash.compiler.internal.parsing.as.RawASTokenizer;
import com.adobe.flash.compiler.problems.ASDocNotClosedProblem;
import com.adobe.flash.compiler.problems.StringLiteralMustBeTerminatedBeforeLineBreakProblem;
import com.adobe.flash.compiler.problems.StringLiteralNotClosedProblem;
import com.adobe.flash.compiler.problems.UnbalancedRegexProblem;

public abstract class BaseRawASTokenizer
extends BaseRawTokenizer<ASToken> {
    protected boolean isInCloseTag = false;
    protected int e4xTagDepth = 0;
    protected int e4xBraceBalance = 0;
    protected int e4xReturnState = 14;
    protected int typedDepth = 0;
    protected int docTypeLevel;
    protected boolean collectComments = false;
    protected ASToken bufferToken;
    static final String PATTERN_U4 = "\\\\u[a-fA-F0-9]{4}";
    private static final String PATTERN_X2 = "\\\\x[a-fA-F0-9]{2}";
    private static final String PATTERN_UNICODE = String.format("(%s)|(%s)", "\\\\u[a-fA-F0-9]{4}", "\\\\x[a-fA-F0-9]{2}");

    @Override
    protected void continueAggregate() {
        if (!this.hasAggregateContents()) {
            super.startAggregate();
        } else {
            super.continueAggregate();
        }
    }

    protected final void aggregateEscapedUnicodeChar(String escapeSequence) {
        int unicode = BaseRawASTokenizer.decodeEscapedUnicode(escapeSequence);
        if (!Character.isValidCodePoint(unicode)) {
            this.addBadCharacterProblem(this.yytext());
        } else {
            this.continueAggregate(Character.toChars(unicode));
        }
    }

    @Override
    public final ASToken buildAggregateToken(int type) {
        ASToken token = (ASToken)this.fetchToken(type, this.aggregateStart, this.getOffset() + (this.markedPosition() - this.readStart()), this.aggregateStartLine, this.aggregateStartColumn, this.aggregateContents);
        this.aggregateContents = null;
        this.setLastToken(token);
        return token;
    }

    protected final ASToken buildE4XTextToken(int type) {
        ASToken token = (ASToken)this.buildToken(type);
        if (this.hasAggregateContents()) {
            this.bufferToken = token;
            int ttype = ((RawASTokenizer)this).yystate() == 38 ? 136 : 137;
            return this.buildAggregateToken(ttype);
        }
        this.aggregateContents = null;
        return token;
    }

    @Override
    protected final void fillBuffer(StringBuilder builder) {
        builder.append(this.buffer(), this.readStart(), this.markedPosition() - this.readStart());
    }

    protected abstract int readStart();

    protected abstract int markedPosition();

    protected abstract int readEnd();

    protected abstract char[] buffer();

    public void setCollectComments(boolean collect) {
        this.collectComments = collect;
    }

    protected abstract void setAllowLTInE4XStringLiterals(boolean var1);

    protected ASToken[] initTokenPool() {
        return new ASToken[10];
    }

    public boolean isInXML() {
        return this.e4xTagDepth > 0 && this.e4xBraceBalance == 0;
    }

    public boolean isInE4XDatabinding() {
        return this.e4xBraceBalance > 0;
    }

    protected abstract void yybegin(int var1);

    protected abstract char yycharat(int var1);

    protected abstract int yylength();

    @Override
    protected final ASToken newToken(int type, int start, int end, int line, int column, CharSequence text) {
        return new ASToken(type, start, end, line, column, text);
    }

    public final boolean isCollectingComments() {
        return this.collectComments;
    }

    public final ASToken getBufferToken() {
        ASToken retVal = this.bufferToken.clone();
        this.bufferToken = null;
        return retVal;
    }

    public final boolean hasBufferToken() {
        return this.bufferToken != null;
    }

    @Override
    public void reset() {
        super.reset();
        this.e4xBraceBalance = 0;
        this.e4xTagDepth = 0;
    }

    protected String escapedUnicodeToHtmlEntity(String escapedUnicode) {
        int unicode = BaseRawASTokenizer.decodeEscapedUnicode(escapedUnicode);
        return String.format("&#x%H;", unicode);
    }

    protected final void reportUnbalancedRegex() {
        ISourceLocation location = this.getCurrentSourceLocation(0);
        UnbalancedRegexProblem problem = new UnbalancedRegexProblem(location);
        this.getProblems().add(problem);
    }

    protected final void reportInvalidLineTerminatorInStringLiteral() {
        ISourceLocation location = this.getCurrentSourceLocation(0);
        StringLiteralMustBeTerminatedBeforeLineBreakProblem problem = new StringLiteralMustBeTerminatedBeforeLineBreakProblem(location);
        this.getProblems().add(problem);
    }

    protected final void reportUnclosedStringLiteral() {
        ISourceLocation location = this.getCurrentSourceLocation(0);
        StringLiteralNotClosedProblem problem = new StringLiteralNotClosedProblem(location);
        this.getProblems().add(problem);
    }

    protected final void reportUnclosedASDoc() {
        ISourceLocation location = this.getCurrentSourceLocation(0);
        ASDocNotClosedProblem problem = new ASDocNotClosedProblem(location);
        this.getProblems().add(problem);
    }

    protected static int decodeEscapedUnicode(String escapedUnicode) {
        if (escapedUnicode == null) {
            throw new IllegalArgumentException("Escape sequence can't be null");
        }
        if (!escapedUnicode.matches(PATTERN_UNICODE)) {
            throw new IllegalStateException("Only call this method from a lexer rule that matches unicode sequence pattern.");
        }
        return Integer.parseInt(escapedUnicode.substring(2), 16);
    }
}

