/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing.as;

import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.RawASTokenizer;
import com.adobe.flash.compiler.parsing.IASBalancingScanner;
import com.adobe.flash.utils.NonLockingStringReader;
import java.io.IOException;
import java.io.Reader;

public class ASBalancingScanner
implements IASBalancingScanner {
    private int countBraces(Reader input) throws IOException {
        ASToken token;
        RawASTokenizer tokenizer = new RawASTokenizer(input);
        int counter = 0;
        do {
            if ((token = tokenizer.nextToken()) == null) continue;
            switch (token.getType()) {
                case 20: {
                    --counter;
                    break;
                }
                case 19: {
                    ++counter;
                    break;
                }
            }
        } while (token != null);
        return counter;
    }

    @Override
    public boolean areBracesBalanced(Reader input) {
        int braceCount = 0;
        try {
            braceCount = this.countBraces(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return braceCount == 0;
    }

    @Override
    public boolean areBracesBalanced(String range) {
        return this.areBracesBalanced(new NonLockingStringReader(range));
    }

    @Override
    public boolean areBracesBalancedOrOverbalanced(Reader input) {
        int braceCount = 0;
        try {
            braceCount = this.countBraces(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return braceCount <= 0;
    }

    @Override
    public boolean areBracesBalancedOrOverbalanced(String range) {
        return this.areBracesBalancedOrOverbalanced(new NonLockingStringReader(range));
    }
}

