/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.parsing;

import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.TokenBase;
import java.io.StringReader;

public class SourceFragmentsReader
extends StringReader {
    private String sourcePath;
    private ISourceFragment[] sourceFragments;
    private int[] logicalFragmentBoundaries;

    public static String concatLogicalText(ISourceFragment[] sourceFragments) {
        StringBuilder sb = new StringBuilder();
        for (ISourceFragment sourceFragment : sourceFragments) {
            sb.append(sourceFragment.getLogicalText());
        }
        return sb.toString();
    }

    SourceFragmentsReader(ISourceFragment[] sourceFragments) {
        super(SourceFragmentsReader.concatLogicalText(sourceFragments));
        this.sourceFragments = sourceFragments;
        int n = sourceFragments.length;
        this.logicalFragmentBoundaries = new int[n + 1];
        this.logicalFragmentBoundaries[0] = 0;
        for (int i = 0; i < n; ++i) {
            this.logicalFragmentBoundaries[i + 1] = this.logicalFragmentBoundaries[i] + sourceFragments[i].getLogicalText().length();
        }
    }

    public SourceFragmentsReader(String sourcePath, ISourceFragment[] sourceFragments) {
        this(sourceFragments);
        this.sourcePath = sourcePath;
    }

    public void adjustLocation(TokenBase token) {
        token.setSourcePath(this.sourcePath);
        int logicalStart = token.getStart();
        int i = this.getFragmentIndexForStart(logicalStart);
        int startDelta = logicalStart - this.logicalFragmentBoundaries[i];
        int physicalStart = this.sourceFragments[i].getPhysicalStart();
        token.setStart(physicalStart += startDelta);
        int logicalEnd = token.getEnd();
        int j = this.getFragmentIndexForEnd(logicalEnd);
        int endDelta = this.logicalFragmentBoundaries[j + 1] - logicalEnd;
        int physicalEnd = this.sourceFragments[j].getPhysicalStart() + this.sourceFragments[j].getPhysicalText().length();
        token.setEnd(physicalEnd -= endDelta);
        int logicalLine = token.getLine();
        int physicalLine = logicalLine + this.sourceFragments[i].getPhysicalLine();
        token.setLine(physicalLine);
        int logicalColumn = token.getColumn();
        int physicalColumn = logicalColumn + this.sourceFragments[i].getPhysicalColumn();
        token.setColumn(physicalColumn);
    }

    private int getFragmentIndexForStart(int start) {
        int n = this.logicalFragmentBoundaries.length;
        for (int i = n - 1; i >= 0; --i) {
            if (this.logicalFragmentBoundaries[i] > start) continue;
            return i;
        }
        return -1;
    }

    private int getFragmentIndexForEnd(int end) {
        int n = this.logicalFragmentBoundaries.length;
        for (int i = 0; i < n; ++i) {
            if (this.logicalFragmentBoundaries[i] < end) continue;
            return i - 1;
        }
        return -1;
    }

    public int getLogicalEnd() {
        int n = this.logicalFragmentBoundaries.length;
        return this.logicalFragmentBoundaries[n - 1];
    }

    public String toString() {
        return SourceFragmentsReader.concatLogicalText(this.sourceFragments);
    }
}

