/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.mxml;

import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.mxml.IMXMLNamespaceMapping;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.ManifestProblem;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCComponent;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MXMLManifestManager {
    private Map<XMLName, ClassInfo> lookupMap = new HashMap<XMLName, ClassInfo>();
    private Map<XMLName, String> lookupOnlyMap = new HashMap<XMLName, String>();
    private SetMultimap<String, XMLName> reverseLookupMap = HashMultimap.create();
    private HashMap<XMLName, ArrayList<ProblemEntry>> problemMap = new HashMap();

    static String getClassName(ClassInfo classInfo) {
        return classInfo != null ? classInfo.className : null;
    }

    public MXMLManifestManager(FlexProject project) {
        for (ISWC swc : project.getLibraries()) {
            this.addSWC(swc);
        }
        for (IMXMLNamespaceMapping namespaceMapping : project.getNamespaceMappings()) {
            this.addManifest(project, namespaceMapping.getURI(), namespaceMapping.getManifestFileName());
        }
    }

    private void addSWC(ISWC swc) {
        File swcFile = swc.getSWCFile();
        for (ISWCComponent component : swc.getComponents()) {
            String uri = component.getURI();
            String name = component.getName();
            XMLName tagName = new XMLName(uri, name);
            String qname = component.getQName();
            this.add(tagName, qname, swcFile.getAbsolutePath(), false);
        }
    }

    private void addManifest(FlexProject project, String uri, String manifestFileName) {
        Document manifestDocument = null;
        IFileSpecification manifestFileSpec = project.getWorkspace().getFileSpecification(manifestFileName);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setCoalescing(true);
            documentBuilderFactory.setIgnoringComments(true);
            manifestDocument = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(manifestFileSpec.createReader()));
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (manifestDocument != null) {
            NodeList components = manifestDocument.getElementsByTagName("component");
            for (int i = 0; i < components.getLength(); ++i) {
                String lookupOnlyStr;
                boolean lookupOnly;
                int lastDot;
                Element component = (Element)components.item(i);
                if (component == null) continue;
                String id = component.getAttribute("id");
                if (id != null && (lastDot = id.lastIndexOf(".")) != -1) {
                    id = id.substring(lastDot + 1);
                }
                XMLName tagName = new XMLName(uri, id);
                String className = component.getAttribute("class");
                if (className != null) {
                    className = className.replaceAll("/", ".");
                }
                boolean bl = lookupOnly = (lookupOnlyStr = component.getAttribute("lookupOnly")) == null ? false : Boolean.valueOf(lookupOnlyStr);
                if (id == null || className == null) continue;
                this.add(tagName, className, manifestFileName, true);
                if (!lookupOnly) continue;
                this.addLookupOnly(tagName, className);
            }
        }
    }

    private void add(XMLName tagName, String className, String fileName, boolean fromManifest) {
        String oldClassName;
        if (!this.lookupMap.containsKey(tagName)) {
            this.lookupMap.put(tagName, new ClassInfo(className, fromManifest));
            this.reverseLookupMap.put((Object)className, (Object)tagName);
            return;
        }
        if (fromManifest) {
            this.lookupMap.get((Object)tagName).fromManifest = true;
        }
        if (className.equals(oldClassName = MXMLManifestManager.getClassName(this.lookupMap.get(tagName)))) {
            return;
        }
        this.lookupMap.put(tagName, null);
        this.reverseLookupMap.remove((Object)oldClassName, (Object)tagName);
        ProblemEntry entry = new ProblemEntry(className, fileName);
        ArrayList<ProblemEntry> list = this.problemMap.get(tagName);
        if (list == null) {
            list = new ArrayList();
            this.problemMap.put(tagName, list);
        }
        list.add(entry);
    }

    private void addLookupOnly(XMLName tagName, String className) {
        if (!this.lookupOnlyMap.containsKey(tagName)) {
            this.lookupOnlyMap.put(tagName, className);
        }
    }

    public Collection<ICompilerProblem> getProblems() {
        HashSet<ICompilerProblem> problems = new HashSet<ICompilerProblem>();
        for (XMLName key : this.lookupMap.keySet()) {
            if (this.lookupMap.get(key) != null) continue;
            List list = this.problemMap.get(key);
            ManifestProblem problem = new ManifestProblem(list);
            problems.add(problem);
        }
        return problems;
    }

    public String resolve(XMLName tagName) {
        return MXMLManifestManager.getClassName(this.lookupMap.get(tagName));
    }

    public boolean isLookupOnly(XMLName tagName) {
        return this.lookupOnlyMap.get(tagName) != null;
    }

    public Collection<XMLName> getTagNamesForClass(String className) {
        Set result = this.reverseLookupMap.get((Object)className);
        if (result == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(result);
    }

    public Collection<String> getQualifiedNamesForNamespaces(Set<String> namespaceURIs, boolean manifestEntriesOnly) {
        HashSet<String> qualifiedNames = new HashSet<String>();
        for (Map.Entry<XMLName, ClassInfo> entry : this.lookupMap.entrySet()) {
            ClassInfo classInfo;
            if (!namespaceURIs.contains(entry.getKey().getXMLNamespace()) || (classInfo = entry.getValue()) == null || manifestEntriesOnly && (!manifestEntriesOnly || !classInfo.fromManifest)) continue;
            qualifiedNames.add(classInfo.className);
        }
        return qualifiedNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        TreeSet<XMLName> keys = new TreeSet<XMLName>(this.lookupMap.keySet());
        for (XMLName key : keys) {
            sb.append(key);
            sb.append(" -> ");
            sb.append(this.lookupMap.get(key));
            sb.append(", lookupOnly = ");
            sb.append(this.isLookupOnly(key));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static class ClassInfo {
        public String className;
        public boolean fromManifest;

        ClassInfo(String className, boolean fromManifest) {
            this.className = className;
            this.fromManifest = fromManifest;
        }
    }

    private static class ProblemEntry {
        public String className;
        public String fileName;

        ProblemEntry(String className, String fileName) {
            this.className = className;
            this.fileName = fileName;
        }
    }
}

