/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.mxml;

import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class MXMLDialect2006
extends MXMLDialect {
    private static final MXMLDialect INSTANCE = new MXMLDialect2006("http://www.adobe.com/2006/mxml", 2006);

    public static MXMLDialect getInstance() {
        return INSTANCE;
    }

    protected MXMLDialect2006(String languageNamespace, int year) {
        super(languageNamespace, year);
        this.bindingXMLName = new XMLName(languageNamespace, "Binding");
        this.componentXMLName = new XMLName(languageNamespace, "Component");
        this.metadataXMLName = new XMLName(languageNamespace, "Metadata");
        this.modelXMLName = new XMLName(languageNamespace, "Model");
        this.scriptXMLName = new XMLName(languageNamespace, "Script");
        this.styleXMLName = new XMLName(languageNamespace, "Style");
    }

    @Override
    public boolean isWhitespace(char c) {
        return c <= ' ';
    }

    @Override
    public boolean isWhitespace(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (this.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String collapseWhitespace(String s, char replacementChar) {
        StringBuilder sb = new StringBuilder();
        boolean lastWasSpace = true;
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c;
            boolean ws;
            if (ws = Character.isWhitespace(c = s.charAt(i++))) {
                if (!lastWasSpace) {
                    sb.append(replacementChar);
                }
                lastWasSpace = true;
                continue;
            }
            sb.append(c);
            lastWasSpace = false;
        }
        return this.trim(sb.toString());
    }

    @Override
    public String trim(String s) {
        return s.trim();
    }

    @Override
    public String[] splitAndTrim(String s) {
        String[] a = s.split(",");
        if (a == null) {
            return null;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = this.trim(a[i]);
        }
        return a;
    }

    @Override
    public Boolean parseBoolean(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        s = this.trim(s);
        if ((s = s.toLowerCase()).equals("false")) {
            return Boolean.FALSE;
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public Integer parseInt(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (this.hasLeadingZeros(s = this.trim(s))) {
            return null;
        }
        Integer value = null;
        try {
            value = Integer.decode(s);
            if (value != null) {
                return value;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (flags != null && flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_COLOR_NAME) && (value = project.getNamedColor(s)) != null) {
            return value;
        }
        return null;
    }

    @Override
    public Long parseUint(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (this.hasLeadingZeros(s = this.trim(s))) {
            return null;
        }
        Long value = null;
        try {
            value = Long.decode(s);
            long longValue = value;
            return longValue == Math.abs(longValue) && longValue <= 0xFFFFFFFFL ? value : longValue;
        }
        catch (NumberFormatException e) {
            Integer colorValue;
            if (flags != null && flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_COLOR_NAME) && (colorValue = project.getNamedColor(s)) != null) {
                return colorValue.longValue();
            }
            return null;
        }
    }

    @Override
    public Number parseNumber(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (this.hasLeadingZeros(s)) {
            return null;
        }
        Integer value = this.parseInt(project, s, flags);
        if (value != null) {
            return value;
        }
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String parseString(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (flags != null && flags.contains((Object)MXMLDialect.TextParsingFlags.COLLAPSE_WHITE_SPACE)) {
            s = this.collapseWhitespace(s, ' ');
        }
        return s;
    }

    @Override
    public List<Object> parseArray(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        if (flags != null && flags.contains((Object)MXMLDialect.TextParsingFlags.ALLOW_ARRAY)) {
            String trimmed = this.trim(s);
            if (!this.isArray(trimmed)) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.isEmptyArray(trimmed)) {
                return list;
            }
            StringBuilder buffer = new StringBuilder();
            char quoteChar = '\'';
            boolean inQuotes = false;
            int n = trimmed.length();
            block5: for (int i = 1; i < n; ++i) {
                char c = trimmed.charAt(i);
                switch (c) {
                    case '[': {
                        if (!inQuotes) continue block5;
                        buffer.append(c);
                        continue block5;
                    }
                    case '\"': 
                    case '\'': {
                        if (inQuotes) {
                            if (quoteChar == c) {
                                inQuotes = false;
                                continue block5;
                            }
                            buffer.append(c);
                            continue block5;
                        }
                        inQuotes = true;
                        quoteChar = c;
                        continue block5;
                    }
                    case ',': 
                    case ']': {
                        if (inQuotes) {
                            buffer.append(c);
                            continue block5;
                        }
                        String elementText = this.trim(buffer.toString());
                        buffer = new StringBuilder();
                        Object element = this.parseObject(project, elementText, null);
                        if (element != null) {
                            list.add(element);
                            continue block5;
                        }
                        return null;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public Object parseObject(FlexProject project, String s, EnumSet<MXMLDialect.TextParsingFlags> flags) {
        String trimmed = this.trim(s);
        Object result = this.parseBoolean(project, trimmed, flags);
        if (result != null) {
            return result;
        }
        result = this.parseArray(project, trimmed, flags);
        if (result != null) {
            return result;
        }
        result = this.parseNumber(project, trimmed, flags);
        if (result != null) {
            return result;
        }
        return s;
    }

    private boolean hasLeadingZeros(String s) {
        boolean result = false;
        int n = s.length();
        if (!(n <= 1 || s.charAt(0) != '0' || s.startsWith("0x") || s.startsWith("0X") || s.startsWith("0."))) {
            result = true;
        }
        return result;
    }

    protected boolean isArray(String s) {
        assert (s.equals(this.trim(s)));
        int n = s.length();
        return n >= 2 && s.charAt(0) == '[' && s.charAt(n - 1) == ']';
    }

    private boolean isEmptyArray(String s) {
        assert (s.equals(this.trim(s)));
        boolean result = false;
        if (this.isArray(s) && s.substring(1, s.length() - 1).trim().length() == 0) {
            result = true;
        }
        return result;
    }
}

