/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.mxml;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragment;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidEntityProblem;
import com.adobe.flash.compiler.problems.MXMLUnterminatedEntityProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EntityProcessor {
    private static final char AMPERSAND = '&';
    private static final char SEMICOLON = ';';
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("#(\\d+)");
    private static final Pattern HEX_PATTERN = Pattern.compile("#x([A-Fa-f\\d]+)");

    public static ISourceFragment[] parse(String s, ISourceLocation location, MXMLDialect mxmlDialect, Collection<ICompilerProblem> problems) {
        ArrayList<SourceFragment> fragmentList;
        block4: {
            SourceFragment fragment;
            int ampersandIndex;
            block5: {
                fragmentList = new ArrayList<SourceFragment>();
                ampersandIndex = s.indexOf(38);
                if (ampersandIndex != -1) break block5;
                if (s.length() <= 0) break block4;
                SourceFragment fragment2 = new SourceFragment(s, location);
                fragmentList.add(fragment2);
                break block4;
            }
            int semicolonIndex = -1;
            int start = location.getStart();
            int line = location.getLine();
            int column = location.getColumn();
            do {
                if (ampersandIndex > semicolonIndex + 1) {
                    String text = s.substring(semicolonIndex + 1, ampersandIndex);
                    fragment = new SourceFragment(text, text, start + semicolonIndex + 1, line, column + semicolonIndex + 1);
                    fragmentList.add(fragment);
                }
                if ((semicolonIndex = s.indexOf(59, ampersandIndex + 1)) == -1) {
                    MXMLUnterminatedEntityProblem problem = new MXMLUnterminatedEntityProblem(location);
                    problems.add(problem);
                    break block4;
                }
                String physicalText = s.substring(ampersandIndex, semicolonIndex + 1);
                String entityName = s.substring(ampersandIndex + 1, semicolonIndex);
                int c = EntityProcessor.convertEntity(entityName, mxmlDialect);
                if (c == -1) {
                    MXMLInvalidEntityProblem problem = new MXMLInvalidEntityProblem(location, physicalText);
                    problems.add(problem);
                    continue;
                }
                String logicalText = String.copyValueOf(new char[]{(char)c});
                fragment = new SourceFragment(physicalText, logicalText, start + ampersandIndex, line, column + ampersandIndex);
                fragmentList.add(fragment);
            } while ((ampersandIndex = s.indexOf(38, semicolonIndex + 1)) != -1);
            if (semicolonIndex + 1 >= s.length()) break block4;
            String text = s.substring(semicolonIndex + 1);
            fragment = new SourceFragment(text, text, start + semicolonIndex + 1, line, column + semicolonIndex + 1);
            fragmentList.add(fragment);
        }
        return fragmentList.toArray(new ISourceFragment[0]);
    }

    private static int convertEntity(String entityName, MXMLDialect mxmlDialect) {
        Character ch = mxmlDialect.getNamedEntity(entityName);
        if (ch != null) {
            return ch.charValue();
        }
        Matcher m = HEX_PATTERN.matcher(entityName);
        if (m.matches()) {
            return Integer.parseInt(m.group(1), 16);
        }
        m = DECIMAL_PATTERN.matcher(entityName);
        if (m.matches()) {
            return Integer.parseInt(m.group(1));
        }
        return -1;
    }
}

