/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.graph;

import com.adobe.flash.compiler.internal.projects.DependencyGraph;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IABCBytesRequestResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InvalidationBytesCalculator {
    public static Map<ICompilationUnit, Integer> calculateBytesChanged(Collection<ICompilationUnit> units) throws InterruptedException {
        HashMap<ICompilationUnit, Integer> bytesChanged = new HashMap<ICompilationUnit, Integer>();
        for (ICompilationUnit unit : units) {
            assert (unit != null);
            IABCBytesRequestResult res = unit.getABCBytesRequest().get();
            assert (res != null);
            bytesChanged.put(unit, res.getABCBytes().length);
        }
        return bytesChanged;
    }

    public static Map<ICompilationUnit, Integer> calculateTotalInvalidatedBytesChanged(Collection<ICompilationUnit> units) throws InterruptedException {
        Map<ICompilationUnit, Integer> bytesChanged = InvalidationBytesCalculator.calculateBytesChanged(units);
        HashMap<ICompilationUnit, Integer> totalBytesChanged = new HashMap<ICompilationUnit, Integer>();
        ArrayList<ICompilationUnit> singleUnit = new ArrayList<ICompilationUnit>();
        singleUnit.add(null);
        for (ICompilationUnit unit : units) {
            singleUnit.set(0, unit);
            Set<ICompilationUnit> invalidatedUnits = DependencyGraph.computeInvalidationSet(singleUnit);
            int byteTotal = 0;
            for (ICompilationUnit invalidatedUnit : invalidatedUnits) {
                if (!bytesChanged.containsKey(invalidatedUnit)) {
                    bytesChanged.put(invalidatedUnit, invalidatedUnit.getABCBytesRequest().get().getABCBytes().length);
                }
                byteTotal += bytesChanged.get(invalidatedUnit).intValue();
            }
            totalBytesChanged.put(unit, byteTotal);
        }
        return totalBytesChanged;
    }
}

