/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.graph;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.internal.graph.IReportWriter;
import com.adobe.flash.compiler.internal.graph.InvalidationBytesCalculator;
import com.adobe.flash.compiler.internal.graph.XMLGraphWriter;
import com.adobe.flash.compiler.internal.projects.DependencyGraph;
import com.adobe.flash.compiler.internal.targets.LinkageChecker;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.UnableToBuildReportProblem;
import com.adobe.flash.compiler.units.ICompilationUnit;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;

public class GraphMLWriter
extends XMLGraphWriter
implements IReportWriter {
    private boolean useExternalDependencies;
    private String yNSuri;
    private LinkageChecker linkageChecker;

    public GraphMLWriter(DependencyGraph graph, Collection<ICompilationUnit> roots, boolean useExternalDependencies, LinkageChecker linkageChecker) {
        super(graph, roots);
        assert (linkageChecker != null) : "linkageChecker may not be null";
        this.useExternalDependencies = useExternalDependencies;
        this.linkageChecker = linkageChecker;
    }

    private Element readGraph() throws InterruptedException {
        Element graphTag = this.doc.createElement("graph");
        Map<ICompilationUnit, Integer> bytesChanged = InvalidationBytesCalculator.calculateBytesChanged(this.roots);
        Map<ICompilationUnit, Integer> totalBytesChanged = InvalidationBytesCalculator.calculateTotalInvalidatedBytesChanged(this.roots);
        ArrayList<ICompilationUnit> visibleVertices = !this.useExternalDependencies ? new ArrayList<ICompilationUnit>(this.readVisibleInternalVertices(this.roots)) : new ArrayList<ICompilationUnit>(this.readVisibleExternalVertices(this.roots));
        int nodeIndex = 0;
        class EdgePair {
            int fromIndex;
            int toIndex;
            DependencyTypeSet typeSet;

            public EdgePair(int fromIndex, int toIndex, DependencyTypeSet typeSet) {
                this.fromIndex = fromIndex;
                this.toIndex = toIndex;
                this.typeSet = typeSet;
            }
        }
        ArrayList<EdgePair> edges = new ArrayList<EdgePair>();
        for (int i = 0; i < visibleVertices.size(); ++i) {
            ICompilationUnit vertex = visibleVertices.get(i);
            Element nodeTag = this.doc.createElement("node");
            nodeTag.setAttribute("id", "n" + Integer.toString(nodeIndex));
            String labelName = vertex.getName();
            String label = labelName + "[" + bytesChanged.get(vertex) + " bytes | " + totalBytesChanged.get(vertex) + " total invalidated bytes]";
            nodeTag.appendChild(this.createNodeDataTag(label, this.isExternal(vertex)));
            graphTag.appendChild(nodeTag);
            if (this.useExternalDependencies || !this.isExternal(vertex)) {
                Set<ICompilationUnit> dependentUnits = this.graph.getDirectDependencies(vertex);
                for (ICompilationUnit toVertex : dependentUnits) {
                    edges.add(new EdgePair(i, visibleVertices.indexOf(toVertex), this.graph.getDependencyTypes(vertex, toVertex)));
                }
            }
            ++nodeIndex;
        }
        int edgeIndex = 0;
        for (EdgePair edge : edges) {
            int from = edge.fromIndex;
            int to = edge.toIndex;
            assert (from > -1);
            assert (to > -1);
            Element edgeTag = this.doc.createElement("edge");
            edgeTag.setAttribute("id", "e" + Integer.toString(edgeIndex));
            edgeTag.setAttribute("source", "n" + Integer.toString(from));
            edgeTag.setAttribute("target", "n" + Integer.toString(to));
            edgeTag.appendChild(this.createEdgeDataTag(edge.typeSet));
            graphTag.appendChild(edgeTag);
            ++edgeIndex;
        }
        return graphTag;
    }

    private boolean isExternal(ICompilationUnit vertex) throws InterruptedException {
        return vertex.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT && this.linkageChecker.isExternal(vertex);
    }

    private Element createNodeDataTag(String label, boolean external) {
        Element dataTag = this.doc.createElement("data");
        dataTag.setAttribute("key", "d0");
        Element shapeNodeTag = this.doc.createElementNS(this.yNSuri, "y:ShapeNode");
        String colorString = external ? "#FFCC00" : "#CCCCFF";
        Element fillTag = this.doc.createElementNS(this.yNSuri, "y:Fill");
        fillTag.setAttribute("color", colorString);
        fillTag.setAttribute("transparent", "false");
        Element labelTag = this.doc.createElementNS(this.yNSuri, "y:NodeLabel");
        labelTag.setTextContent(label);
        shapeNodeTag.appendChild(fillTag);
        shapeNodeTag.appendChild(labelTag);
        dataTag.appendChild(shapeNodeTag);
        return dataTag;
    }

    private Element createEdgeDataTag(DependencyTypeSet typeSet) {
        Element dataTag = this.doc.createElement("data");
        dataTag.setAttribute("key", "d1");
        Element polyLineEdgeTag = this.doc.createElementNS(this.yNSuri, "y:PolyLineEdge");
        String lineStyle = DependencyType.INHERITANCE.existsIn(typeSet) ? "solid" : (DependencyType.NAMESPACE.existsIn(typeSet) || DependencyType.SIGNATURE.existsIn(typeSet) ? "dashed" : "dotted");
        Element lineStyleTag = this.doc.createElementNS(this.yNSuri, "y:LineStyle");
        lineStyleTag.setAttribute("type", lineStyle);
        Element arrowsTag = this.doc.createElementNS(this.yNSuri, "y:Arrows");
        arrowsTag.setAttribute("target", "standard");
        arrowsTag.setAttribute("source", "none");
        Element labelTag = this.doc.createElementNS(this.yNSuri, "y:EdgeLabel");
        labelTag.setTextContent(DependencyType.getTypeString(typeSet));
        polyLineEdgeTag.appendChild(lineStyleTag);
        polyLineEdgeTag.appendChild(arrowsTag);
        polyLineEdgeTag.appendChild(labelTag);
        dataTag.appendChild(polyLineEdgeTag);
        return dataTag;
    }

    private Set<ICompilationUnit> readVisibleExternalVertices(Collection<ICompilationUnit> roots) {
        HashSet<ICompilationUnit> dependentVertices = new HashSet<ICompilationUnit>();
        Stack<ICompilationUnit> unsearched = new Stack<ICompilationUnit>();
        unsearched.addAll(roots);
        while (!unsearched.isEmpty()) {
            unsearched.addAll(this.readDependencies(dependentVertices, (ICompilationUnit)unsearched.pop()));
        }
        return dependentVertices;
    }

    private Set<ICompilationUnit> readVisibleInternalVertices(Collection<ICompilationUnit> roots) throws InterruptedException {
        HashSet<ICompilationUnit> dependentVertices = new HashSet<ICompilationUnit>();
        ArrayList<ICompilationUnit> internalVertices = new ArrayList<ICompilationUnit>();
        for (ICompilationUnit vertex : roots) {
            if (this.isExternal(vertex)) continue;
            internalVertices.add(vertex);
        }
        for (ICompilationUnit vertex : internalVertices) {
            dependentVertices.addAll(this.readDependencies(dependentVertices, vertex));
        }
        return dependentVertices;
    }

    private Set<ICompilationUnit> readDependencies(Set<ICompilationUnit> dependentVertices, ICompilationUnit vertex) {
        dependentVertices.add(vertex);
        HashSet<ICompilationUnit> newDependencies = new HashSet<ICompilationUnit>();
        Set<ICompilationUnit> dependencies = this.graph.getDirectDependencies(vertex);
        for (ICompilationUnit dependency : dependencies) {
            if (dependentVertices.contains(dependency)) continue;
            newDependencies.add(dependency);
        }
        return newDependencies;
    }

    @Override
    public void writeToStream(OutputStream outStream, Collection<ICompilerProblem> problems) throws InterruptedException {
        String uri_xmlns = "http://graphml.graphdrawing.org/xmlns";
        String defaultns = "http://www.w3.org/2000/xmlns/";
        String uri_xsi = "http://www.w3.org/2001/XMLSchema-instance";
        String uri_yed = "http://www.yworks.com/xml/yed/3";
        String uri_schema = "http://graphml.graphdrawing.org/xmlns http://www.yworks.com/xml/schema/graphml/1.1/ygraphml.xsd";
        this.yNSuri = "http://www.yworks.com/xml/graphml";
        Element graphmlTag = this.doc.createElement("graphml");
        graphmlTag.setAttribute("xmlns", uri_xmlns);
        graphmlTag.setAttributeNS(defaultns, "xmlns:xsi", uri_xsi);
        graphmlTag.setAttributeNS(defaultns, "xmlns:y", this.yNSuri);
        graphmlTag.setAttributeNS(defaultns, "xmlns:yed", uri_yed);
        graphmlTag.setAttributeNS(uri_xsi, "xsi:schemaLocation", uri_schema);
        Element key0 = this.doc.createElement("key");
        key0.setAttribute("for", "node");
        key0.setAttribute("id", "d0");
        key0.setAttribute("yfiles.type", "nodegraphics");
        Element key1 = this.doc.createElement("key");
        key1.setAttribute("for", "edge");
        key1.setAttribute("id", "d1");
        key1.setAttribute("yfiles.type", "edgegraphics");
        graphmlTag.appendChild(key0);
        graphmlTag.appendChild(key1);
        graphmlTag.appendChild(this.readGraph());
        this.doc.appendChild(graphmlTag);
        try {
            this.writeReport(outStream);
        }
        catch (TransformerException e) {
            problems.add(new UnableToBuildReportProblem(e));
        }
    }
}

