/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.swf;

import com.adobe.flash.compiler.fxg.FXGVersion;
import com.adobe.flash.compiler.internal.embedding.transcoders.JPEGTranscoder;
import com.adobe.flash.compiler.internal.fxg.dom.BitmapGraphicNode;
import com.adobe.flash.compiler.internal.fxg.dom.IFillNode;
import com.adobe.flash.compiler.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.FillMode;
import com.adobe.flash.compiler.internal.fxg.swf.DefineImage;
import com.adobe.flash.compiler.internal.fxg.swf.ShapeHelper;
import com.adobe.flash.compiler.internal.fxg.swf.TypeHelper;
import com.adobe.flash.swf.tags.DefineBitsJPEG2Tag;
import com.adobe.flash.swf.tags.DefineBitsLossless2Tag;
import com.adobe.flash.swf.tags.DefineShape4Tag;
import com.adobe.flash.swf.tags.DefineShapeTag;
import com.adobe.flash.swf.types.FillStyle;
import com.adobe.flash.swf.types.FillStyleArray;
import com.adobe.flash.swf.types.LineStyleArray;
import com.adobe.flash.swf.types.Matrix;
import com.adobe.flash.swf.types.Rect;
import com.adobe.flash.swf.types.ShapeRecord;
import com.adobe.flash.swf.types.ShapeWithStyle;
import com.adobe.flash.swf.types.StraightEdgeRecord;
import com.adobe.flash.swf.types.StyleChangeRecord;
import com.adobe.flash.swf.types.Styles;
import com.adobe.flash.utils.FileUtils;
import com.adobe.flash.utils.Trace;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ImageHelper {
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_JPG = "image/jpg";
    public static final String MIME_PNG = "image/png";

    public static DefineShapeTag createShapeForImage(DefineImage image, BitmapGraphicNode node) {
        double width = node.width;
        double height = node.height;
        boolean repeat = node.repeat;
        FillMode fillMode = node.fillMode;
        FXGVersion fileVersion = node.getFileVersion();
        if (Double.isNaN(width)) {
            width = image.getWidth();
        }
        if (Double.isNaN(height)) {
            height = image.getHeight();
        }
        Matrix matrix = new Matrix();
        double twx = 20.0;
        matrix.setScale(twx, twx);
        FillStyle fs = null;
        if (fileVersion.equalTo(FXGVersion.v1_0)) {
            fs = repeat ? new FillStyle(64, matrix, image.getTag()) : new FillStyle(65, matrix, image.getTag());
        } else if (fillMode.equals((Object)FillMode.REPEAT)) {
            fs = new FillStyle(64, matrix, image.getTag());
        } else if (fillMode.equals((Object)FillMode.CLIP)) {
            fs = new FillStyle(65, matrix, image.getTag());
        } else if (fillMode.equals((Object)FillMode.SCALE)) {
            double fwidth = width * 20.0 / (double)image.getWidth();
            double fheight = height * 20.0 / (double)image.getHeight();
            fwidth = StrictMath.rint(65536.0 * fwidth) / 65536.0;
            fheight = StrictMath.rint(65536.0 * fheight) / 65536.0;
            matrix.setScale(fwidth, fheight);
            fs = new FillStyle(65, matrix, image.getTag());
        }
        FillStyleArray styleArray = new FillStyleArray();
        styleArray.add(fs);
        LineStyleArray lineStyleArray = new LineStyleArray();
        Styles styles = new Styles(styleArray, lineStyleArray);
        ShapeWithStyle sws = new ShapeWithStyle(styles);
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(width, height);
        ShapeHelper.setStyles(shapeRecords, 0, 1, 0, styles);
        sws.addShapeRecords(shapeRecords);
        DefineShape4Tag defineShape = new DefineShape4Tag();
        defineShape.setShapeBounds(TypeHelper.rect(width, height));
        defineShape.setEdgeBounds(defineShape.getShapeBounds());
        defineShape.setShapes(sws);
        return defineShape;
    }

    public static boolean bitmapImageNeedsClipping(DefineImage defImage, BitmapGraphicNode node) {
        return (node.getFileVersion().equalTo(FXGVersion.v1_0) && !node.repeat || node.fillMode.equals((Object)FillMode.CLIP)) && ((double)defImage.getWidth() < node.width || (double)defImage.getHeight() < node.height);
    }

    public static boolean bitmapFillModeIsRepeat(BitmapFillNode node) {
        return node.getFileVersion().equalTo(FXGVersion.v1_0) && node.repeat || node.fillMode.equals((Object)FillMode.REPEAT);
    }

    public static boolean isBitmapFillWithClip(IFillNode fill) {
        if (fill == null) {
            return false;
        }
        if (fill instanceof BitmapFillNode) {
            BitmapFillNode bFill = (BitmapFillNode)fill;
            if (ImageHelper.bitmapFillModeIsRepeat(bFill)) {
                return false;
            }
            if (bFill.getFileVersion().equalTo(FXGVersion.v2_0) && bFill.fillMode == FillMode.SCALE) {
                return !Double.isNaN(bFill.scaleX) || !Double.isNaN(bFill.scaleY) || !Double.isNaN(bFill.x) || !Double.isNaN(bFill.y) || !Double.isNaN(bFill.rotation) && !(Math.abs(bFill.rotation) < 1.0E-5) || bFill.matrix != null;
            }
            return true;
        }
        return false;
    }

    public static DefineImage createDefineBits(InputStream in, String mimeType) throws IOException {
        byte[] bytes = FileUtils.toByteArray(in);
        Image image = ImageHelper.getImage(bytes);
        if (mimeType == null) {
            throw new IOException("Unsupported MIME type");
        }
        PixelGrabber pixelGrabber = null;
        try {
            pixelGrabber = ImageHelper.getPixelGrabber(image, null);
        }
        catch (Exception e) {
            throw new IOException("Error reading image");
        }
        int width = pixelGrabber.getWidth();
        int height = pixelGrabber.getHeight();
        if (MIME_JPG.equals(mimeType) || MIME_JPEG.equals(mimeType)) {
            DefineBitsJPEG2Tag imageTag = new DefineBitsJPEG2Tag();
            imageTag.setImageData(bytes);
            return new DefineImage(imageTag, width, height);
        }
        if (MIME_PNG.equals(mimeType) || MIME_GIF.equals(mimeType)) {
            int[] pixels = (int[])pixelGrabber.getPixels();
            DefineImage defimage = ImageHelper.createDefineBitsLossless(pixels, width, height);
            return defimage;
        }
        throw new IOException("Unsupported MIME type: " + mimeType);
    }

    public static DefineImage createDefineBitsLossless(int[] pixels, int width, int height) throws IOException {
        DefineBitsLossless2Tag defineBitsLossless = new DefineBitsLossless2Tag();
        defineBitsLossless.setBitmapFormat(5);
        defineBitsLossless.setBitmapWidth(width);
        defineBitsLossless.setBitmapHeight(height);
        byte[] data = new byte[pixels.length * 4];
        for (int i = 0; i < pixels.length; ++i) {
            int offset = i * 4;
            int alpha = pixels[i] >> 24 & 0xFF;
            data[offset] = (byte)alpha;
            if (data[offset] == 0) continue;
            int red = pixels[i] >> 16 & 0xFF;
            data[offset + 1] = (byte)(red * alpha / 255);
            int green = pixels[i] >> 8 & 0xFF;
            data[offset + 2] = (byte)(green * alpha / 255);
            int blue = pixels[i] & 0xFF;
            data[offset + 3] = (byte)(blue * alpha / 255);
        }
        defineBitsLossless.setZlibBitmapData(JPEGTranscoder.deflate(data));
        return new DefineImage(defineBitsLossless, width, height);
    }

    public static DefineShapeTag create9SlicedShape(DefineImage bitmap, Rect r, double width, double height) {
        if (Double.isNaN(width)) {
            width = bitmap.getWidth();
        }
        if (Double.isNaN(height)) {
            height = bitmap.getHeight();
        }
        int slt = r.xMin();
        int srt = r.xMax();
        int stt = r.yMin();
        int sbt = r.yMax();
        FillStyleArray fillStyleArray = new FillStyleArray(9);
        LineStyleArray lineStyleArray = new LineStyleArray();
        ArrayList<ShapeRecord> shapeRecords = new ArrayList<ShapeRecord>(50);
        Matrix matrix = new Matrix();
        double twx = 20.0;
        matrix.setScale(twx, twx);
        for (int i = 0; i < 9; ++i) {
            FillStyle fs = new FillStyle(66, matrix, bitmap.getTag());
            fillStyleArray.add(fs);
        }
        Styles styles = new Styles(fillStyleArray, lineStyleArray);
        int dxa = slt;
        int dxb = srt - slt;
        int dxc = bitmap.getWidth() * 20 - srt;
        int dya = stt;
        int dyb = sbt - stt;
        int dyc = bitmap.getHeight() * 20 - sbt;
        StyleChangeRecord scr = new StyleChangeRecord();
        scr.setMove(0, dya);
        scr.setDefinedStyles(-1, 1, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, -dya));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 2, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 3, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 6, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 9, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StraightEdgeRecord(-dxc, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 8, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(-dxb, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 7, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(-dxa, 0));
        shapeRecords.add(new StraightEdgeRecord(0, -dyc));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(-1, 4, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, -dyb));
        scr = new StyleChangeRecord();
        scr.setMove(dxa, 0);
        scr.setDefinedStyles(2, 1, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(5, 4, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(8, 7, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        scr = new StyleChangeRecord();
        scr.setMove(dxa + dxb, 0);
        scr.setDefinedStyles(3, 2, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(6, 5, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(9, 8, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        scr = new StyleChangeRecord();
        scr.setMove(0, dya);
        scr.setDefinedStyles(1, 4, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(2, 5, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(3, 6, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        scr = new StyleChangeRecord();
        scr.setMove(0, dya + dyb);
        scr.setDefinedStyles(4, 7, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(5, 8, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        scr = new StyleChangeRecord();
        scr.setDefinedStyles(6, 9, -1, styles);
        shapeRecords.add(scr);
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        ShapeWithStyle sws = new ShapeWithStyle(styles);
        sws.addShapeRecords(shapeRecords);
        DefineShape4Tag shape = new DefineShape4Tag();
        shape.setShapeBounds(TypeHelper.rect(width, height));
        shape.setEdgeBounds(shape.getShapeBounds());
        shape.setShapes(sws);
        return shape;
    }

    public static String guessMimeType(String path) {
        if (path != null) {
            if ((path = path.toLowerCase()).endsWith(".png")) {
                return MIME_PNG;
            }
            if (path.endsWith(".gif")) {
                return MIME_GIF;
            }
            if (path.endsWith(".jpg")) {
                return MIME_JPG;
            }
            if (path.endsWith(".jpeg")) {
                return MIME_JPEG;
            }
        }
        return null;
    }

    private static Image getImage(byte[] bytes) {
        Image image;
        try {
            image = Toolkit.getDefaultToolkit().createImage(bytes);
        }
        catch (InternalError ie) {
            if (Trace.error) {
                ie.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the Flex configuration file to true.");
        }
        catch (NoClassDefFoundError ce) {
            if (Trace.error) {
                ce.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the Flex configuration file to true.");
        }
        return image;
    }

    private static PixelGrabber getPixelGrabber(Image image, String location) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (Trace.error) {
                interruptedException.printStackTrace();
            }
            throw new RuntimeException("Failed to grab pixels for image " + location);
        }
        if ((pixelGrabber.getStatus() & 1) == 0 || (pixelGrabber.getStatus() & 2) == 0) {
            throw new RuntimeException("Failed to grab pixels for image " + location);
        }
        return pixelGrabber;
    }
}

