/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.sax;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.CDATANode;
import com.adobe.flash.compiler.internal.fxg.dom.DefinitionNode;
import com.adobe.flash.compiler.internal.fxg.dom.DelegateNode;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicNode;
import com.adobe.flash.compiler.internal.fxg.dom.IPreserveWhiteSpaceNode;
import com.adobe.flash.compiler.internal.fxg.sax.FXGVersionHandlerRegistry;
import com.adobe.flash.compiler.internal.fxg.sax.IFXGVersionHandler;
import com.adobe.flash.compiler.problems.FXGInvalidRootNodeProblem;
import com.adobe.flash.compiler.problems.FXGInvalidVersionProblem;
import com.adobe.flash.compiler.problems.FXGMissingAttributeProblem;
import com.adobe.flash.compiler.problems.FXGMultipleElementProblem;
import com.adobe.flash.compiler.problems.FXGPrivateElementNotChildOfGraphicProblem;
import com.adobe.flash.compiler.problems.FXGPrivateElementNotLastProblem;
import com.adobe.flash.compiler.problems.FXGScanningProblem;
import com.adobe.flash.compiler.problems.FXGUnknownElementInVersionProblem;
import com.adobe.flash.compiler.problems.FXGVersionHandlerNotRegisteredProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXGSAXScanner
extends DefaultHandler {
    private static boolean REJECT_MAJOR_VERSION_MISMATCH = false;
    private static final String FXG_GROUP_DEFINITION_ELEMENT = "[GroupDefinition]";
    private GraphicNode root;
    private Stack<IFXGNode> stack;
    private int skippedElementCount;
    private boolean seenPrivateElement = false;
    private boolean inMaskAfterPrivateElement = false;
    private Locator locator;
    private int startLine = 0;
    private int startColumn = 0;
    private String documentPath = null;
    private String unknownElement = null;
    private Collection<ICompilerProblem> problems;
    private IFXGVersionHandler versionHandler = null;

    public FXGSAXScanner(Collection<ICompilerProblem> problems) {
        this.problems = problems;
        this.versionHandler = FXGVersionHandlerRegistry.getDefaultHandler();
        if (this.versionHandler == null) {
            problems.add(new FXGVersionHandlerNotRegisteredProblem(FXGVersionHandlerRegistry.defaultVersion.asDouble()));
        }
    }

    public IFXGNode getRootNode() {
        return this.root;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public String getDocumentPath() {
        return this.documentPath;
    }

    public void setDocumentPath(String documentPath) {
        this.documentPath = documentPath;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        block33: {
            if (this.isSkippedElement(uri, localName, true)) {
                ++this.skippedElementCount;
            }
            if (this.inSkippedElement()) {
                return;
            }
            if (this.unknownElement != null) {
                return;
            }
            this.startLine = this.locator.getLineNumber();
            this.startColumn = this.locator.getColumnNumber();
            IFXGNode parent = null;
            if (this.stack.size() > 0 && (parent = this.stack.peek()) == null) {
                return;
            }
            if (this.isFXGNamespace(uri) && parent instanceof DefinitionNode && "Group".equals(localName)) {
                localName = FXG_GROUP_DEFINITION_ELEMENT;
            }
            IFXGNode node = this.createNode(uri, localName);
            try {
                if (node == null) {
                    if (this.root != null) {
                        if (this.root.isVersionGreaterThanCompiler()) {
                            this.unknownElement = localName;
                        } else {
                            this.problems.add(new FXGUnknownElementInVersionProblem(this.documentPath, this.startLine, this.startColumn, localName, this.root.getFileVersion().asDouble()));
                        }
                    } else {
                        this.problems.add(new FXGInvalidRootNodeProblem(this.documentPath, this.startLine, this.startColumn));
                    }
                    return;
                }
                if (this.root != null) {
                    node.setDocumentNode(this.root);
                }
                if (node instanceof DelegateNode) {
                    DelegateNode propertyNode = (DelegateNode)node;
                    propertyNode.setName(localName);
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attributeURI = attributes.getURI(i);
                    if (attributeURI != null && attributeURI != "" && !this.isFXGNamespace(attributeURI)) continue;
                    String attributeName = attributes.getLocalName(i);
                    String attributeValue = attributes.getValue(i);
                    node.setAttribute(attributeName, attributeValue, this.problems);
                }
                if (parent != null) {
                    if (node instanceof DelegateNode) {
                        DelegateNode propertyNode = (DelegateNode)node;
                        propertyNode.setDelegate(parent, this.problems);
                    } else {
                        parent.addChild(node, this.problems);
                    }
                    break block33;
                }
                if (node instanceof GraphicNode) {
                    this.root = (GraphicNode)node;
                    node.setDocumentNode(this.root);
                    if (this.root.getVersion() == null) {
                        for (ICompilerProblem problem : this.problems) {
                            if (!(problem instanceof FXGInvalidVersionProblem)) continue;
                            return;
                        }
                        this.problems.add(new FXGMissingAttributeProblem(this.documentPath, this.startLine, this.startColumn, "version", this.root.getNodeName()));
                        return;
                    }
                    if (!this.isMajorVersionMatch(this.root)) {
                        IFXGVersionHandler newVHandler = FXGVersionHandlerRegistry.getVersionHandler(this.root.getVersion());
                        if (newVHandler == null) {
                            if (REJECT_MAJOR_VERSION_MISMATCH) {
                                this.problems.add(new FXGInvalidVersionProblem(this.documentPath, this.startLine, this.startColumn, this.root.getVersion().asString()));
                                return;
                            }
                            this.versionHandler = FXGVersionHandlerRegistry.getLatestVersionHandler();
                            if (this.versionHandler == null) {
                                this.problems.add(new FXGVersionHandlerNotRegisteredProblem(this.root.getVersion().asDouble()));
                                return;
                            }
                        } else {
                            this.versionHandler = newVHandler;
                        }
                    }
                    this.root.setDocumentPath(this.documentPath);
                    this.root.setVersionGreaterThanCompiler(this.root.getVersion().greaterThan(this.versionHandler.getVersion()));
                    this.root.setReservedNodes(this.versionHandler.getElementNodes(uri));
                    break block33;
                }
                if (this.root == null) {
                    this.problems.add(new FXGInvalidRootNodeProblem(this.documentPath, this.startLine, this.startColumn));
                }
            }
            finally {
                this.stack.push(node);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.stack != null && this.stack.size() > 0 && this.stack.peek() != null && !this.inSkippedElement() && this.unknownElement == null) {
            IFXGNode node = this.stack.peek();
            String content = new String(ch, start, length);
            if (!(node instanceof IPreserveWhiteSpaceNode)) {
                content = content.trim();
            }
            if (content.length() > 0) {
                CDATANode cdata = new CDATANode();
                cdata.content = content;
                this.assignNodeLocation(cdata);
                node.addChild(cdata, this.problems);
            }
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.isSkippedElement(uri, localName, false)) {
            --this.skippedElementCount;
        } else if (this.unknownElement != null) {
            if (this.unknownElement.equals(localName)) {
                this.unknownElement = null;
            }
        } else if (!this.inSkippedElement() && this.stack.peek() != null) {
            this.stack.pop();
        }
        this.startLine = this.locator.getLineNumber();
        this.startColumn = this.locator.getColumnNumber();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    protected boolean isFXGNamespace(String uri) {
        return "http://ns.adobe.com/fxg/2008".equals(uri);
    }

    protected boolean isSkippedElement(String uri, String localName, boolean startElement) {
        Set<String> skippedElements = this.versionHandler.getSkippedElements(uri);
        if (skippedElements != null) {
            if (skippedElements.contains("Private")) {
                this.validatePrivateElement(localName, startElement);
            }
            if (skippedElements.contains(localName)) {
                return true;
            }
        }
        return false;
    }

    protected IFXGNode createNode(String uri, String localName) {
        IFXGNode node = null;
        try {
            Map<String, Class<? extends IFXGNode>> elementNodes = this.getElementNodes(uri);
            if (elementNodes != null) {
                Class<? extends IFXGNode> nodeClass = elementNodes.get(localName);
                if (nodeClass != null) {
                    node = nodeClass.newInstance();
                } else if (this.root != null) {
                    node = this.root.getDefinitionInstance(localName);
                }
            }
        }
        catch (Throwable t) {
            this.problems.add(new FXGScanningProblem(this.documentPath, this.startLine, this.startColumn, t.getLocalizedMessage()));
        }
        if (node != null) {
            this.assignNodeLocation(node);
        }
        return node;
    }

    private boolean inSkippedElement() {
        return this.skippedElementCount > 0;
    }

    private void assignNodeLocation(IFXGNode node) {
        if (node != null) {
            node.setStartLine(this.startLine);
            node.setStartColumn(this.startColumn);
            node.setEndLine(this.locator.getLineNumber());
            node.setEndColumn(this.locator.getColumnNumber());
        }
    }

    private Map<String, Class<? extends IFXGNode>> getElementNodes(String uri) {
        return this.versionHandler.getElementNodes(uri);
    }

    private void validatePrivateElement(String localName, boolean startElement) {
        if (!startElement) {
            if (this.inMaskAfterPrivateElement && localName.equals("mask")) {
                this.inMaskAfterPrivateElement = false;
            }
            return;
        }
        if (localName.equals("Private")) {
            if (this.seenPrivateElement) {
                this.problems.add(new FXGMultipleElementProblem(this.documentPath, this.startLine, this.startColumn, localName));
            } else if (!this.inSkippedElement() && this.stack.size() == 1) {
                this.seenPrivateElement = true;
            } else {
                this.problems.add(new FXGPrivateElementNotChildOfGraphicProblem(this.documentPath, this.startLine, this.startColumn));
            }
        } else if (this.seenPrivateElement && !this.inSkippedElement()) {
            if (!this.inMaskAfterPrivateElement && localName.equals("mask")) {
                this.inMaskAfterPrivateElement = true;
            } else if (!this.inMaskAfterPrivateElement) {
                this.problems.add(new FXGPrivateElementNotLastProblem(this.documentPath, this.startLine, this.startColumn));
            }
        }
    }

    private boolean isMajorVersionMatch(GraphicNode root) {
        long compilerMajorVersion;
        long majorVersion = root.getVersion().getMajorVersion();
        return majorVersion == (compilerMajorVersion = this.versionHandler.getVersion().getMajorVersion());
    }
}

