/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.sax;

import com.adobe.flash.compiler.fxg.IFXGParser;
import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.sax.FXGSAXScanner;
import com.adobe.flash.compiler.problems.FXGParserProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FXGSAXParser
implements IFXGParser {
    private FXGSAXScanner scanner = null;

    @Override
    public IFXGNode parse(Reader reader, Collection<ICompilerProblem> problems) {
        return this.parse(reader, null, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFXGNode parse(Reader reader, String documentPath, Collection<ICompilerProblem> problems) {
        try {
            IFXGNode node;
            this.scanner = new FXGSAXScanner(problems);
            this.scanner.setDocumentPath(documentPath);
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setValidating(false);
            saxFactory.setNamespaceAware(true);
            SAXParser parser = saxFactory.newSAXParser();
            InputSource is = new InputSource(reader);
            parser.parse(is, (DefaultHandler)this.scanner);
            IFXGNode iFXGNode = node = this.scanner.getRootNode();
            return iFXGNode;
        }
        catch (IOException ex) {
            problems.add(new FXGParserProblem(documentPath, this.scanner.getStartLine(), this.scanner.getStartColumn(), ex.getLocalizedMessage()));
        }
        catch (ParserConfigurationException ex) {
            problems.add(new FXGParserProblem(documentPath, this.scanner.getStartLine(), this.scanner.getStartColumn(), ex.getLocalizedMessage()));
        }
        catch (SAXException ex) {
            problems.add(new FXGParserProblem(documentPath, this.scanner.getStartLine(), this.scanner.getStartColumn(), ex.getLocalizedMessage()));
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {}
        }
        return null;
    }
}

