/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom.transforms;

import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.transforms.AbstractTransformNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;

public class ColorTransformNode
extends AbstractTransformNode
implements Cloneable {
    private static final double MIN_OFFSET_INCLUSIVE = -255.0;
    private static final double MAX_OFFSET_INCLUSIVE = 255.0;
    public double alphaMultiplier = 1.0;
    public double redMultiplier = 1.0;
    public double blueMultiplier = 1.0;
    public double greenMultiplier = 1.0;
    public double alphaOffset = 0.0;
    public double redOffset = 0.0;
    public double blueOffset = 0.0;
    public double greenOffset = 0.0;

    @Override
    public String getNodeName() {
        return "ColorTransform";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("alphaMultiplier".equals(name)) {
            this.alphaMultiplier = DOMParserHelper.parseDouble(this, value, name, this.alphaMultiplier, problems);
        } else if ("redMultiplier".equals(name)) {
            this.redMultiplier = DOMParserHelper.parseDouble(this, value, name, this.redMultiplier, problems);
        } else if ("blueMultiplier".equals(name)) {
            this.blueMultiplier = DOMParserHelper.parseDouble(this, value, name, this.blueMultiplier, problems);
        } else if ("greenMultiplier".equals(name)) {
            this.greenMultiplier = DOMParserHelper.parseDouble(this, value, name, this.greenMultiplier, problems);
        } else if ("alphaOffset".equals(name)) {
            this.alphaOffset = DOMParserHelper.parseDouble(this, value, name, -255.0, 255.0, this.alphaOffset, problems);
        } else if ("redOffset".equals(name)) {
            this.redOffset = DOMParserHelper.parseDouble(this, value, name, -255.0, 255.0, this.redOffset, problems);
        } else if ("blueOffset".equals(name)) {
            this.blueOffset = DOMParserHelper.parseDouble(this, value, name, -255.0, 255.0, this.blueOffset, problems);
        } else if ("greenOffset".equals(name)) {
            this.greenOffset = DOMParserHelper.parseDouble(this, value, name, -255.0, 255.0, this.greenOffset, problems);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ColorTransformNode copy = (ColorTransformNode)super.clone();
        copy.alphaMultiplier = this.alphaMultiplier;
        copy.redMultiplier = this.redMultiplier;
        copy.blueMultiplier = this.blueMultiplier;
        copy.greenMultiplier = this.greenMultiplier;
        copy.alphaOffset = this.alphaOffset;
        copy.redOffset = this.redOffset;
        copy.blueOffset = this.blueOffset;
        copy.greenOffset = this.greenOffset;
        return copy;
    }
}

