/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom.text;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicNode;
import com.adobe.flash.compiler.internal.fxg.dom.text.AbstractTextNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.Kerning;
import com.adobe.flash.compiler.internal.fxg.dom.types.LineBreak;
import com.adobe.flash.compiler.internal.fxg.dom.types.WhiteSpaceCollapse;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;

public abstract class AbstractCharacterTextNode
extends AbstractTextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    public String fontFamily = "Times New Roman";
    public double fontSize = 12.0;
    public String fontStyle = "normal";
    public String fontWeight = "normal";
    public double lineHeight = 120.0;
    public String textDecoration = "none";
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.PRESERVE;
    public LineBreak lineBreak = LineBreak.TOFIT;
    public double tracking = 0.0;
    public Kerning kerning = Kerning.AUTO;
    public double textAlpha = 1.0;
    public int color = -16777216;
    public boolean lineThrough = false;

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize, problems);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = value;
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = value;
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parsePercent(this, value, name, this.lineHeight, problems);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = value;
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = AbstractCharacterTextNode.getWhiteSpaceCollapse(this, value, problems);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = AbstractCharacterTextNode.getLineBreak(this, value, problems);
        } else if ("tracking".equals(name)) {
            this.tracking = DOMParserHelper.parsePercent(this, value, name, this.tracking, problems);
        } else if ("kerning".equals(name)) {
            this.kerning = AbstractCharacterTextNode.getKerning(this, value, problems);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha, problems);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name, this.color, problems);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name, this.lineThrough, problems);
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }

    public static Kerning getKerning(IFXGNode node, String value, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return Kerning.AUTO;
        }
        if ("on".equals(value)) {
            return Kerning.ON;
        }
        if ("off".equals(value)) {
            return Kerning.OFF;
        }
        problems.add(new FXGUnknownAttributeValueProblem(((GraphicNode)node.getDocumentNode()).getDocumentPath(), node.getStartLine(), node.getStartColumn(), "kerning", value));
        return Kerning.AUTO;
    }

    public static LineBreak getLineBreak(IFXGNode node, String value, Collection<ICompilerProblem> problems) {
        if ("toFit".equals(value)) {
            return LineBreak.TOFIT;
        }
        if ("explicit".equals(value)) {
            return LineBreak.EXPLICIT;
        }
        problems.add(new FXGUnknownAttributeValueProblem(((GraphicNode)node.getDocumentNode()).getDocumentPath(), node.getStartLine(), node.getStartColumn(), "lineBreak", value));
        return LineBreak.TOFIT;
    }

    public static WhiteSpaceCollapse getWhiteSpaceCollapse(IFXGNode node, String value, Collection<ICompilerProblem> problems) {
        if ("preserve".equals(value)) {
            return WhiteSpaceCollapse.PRESERVE;
        }
        if ("collapse".equals(value)) {
            return WhiteSpaceCollapse.COLLAPSE;
        }
        problems.add(new FXGUnknownAttributeValueProblem(((GraphicNode)node.getDocumentNode()).getDocumentPath(), node.getStartLine(), node.getStartColumn(), "whiteSpaceCollapse", value));
        return WhiteSpaceCollapse.PRESERVE;
    }
}

