/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom.richtext;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.CDATANode;
import com.adobe.flash.compiler.internal.fxg.dom.ITextNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.BRNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.ImgNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.LinkNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.SpanNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.TabNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.TextLayoutFormatNode;
import com.adobe.flash.compiler.problems.FXGInvalidNestingElementsProblem;
import com.adobe.flash.compiler.problems.FXGMissingAttributeProblem;
import com.adobe.flash.compiler.problems.FXGMultipleElementProblem;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class TCYNode
extends AbstractRichTextLeafNode {
    public TextLayoutFormatNode linkNormalFormat = null;
    public TextLayoutFormatNode linkHoverFormat = null;
    public TextLayoutFormatNode linkActiveFormat = null;
    protected HashMap<String, ITextNode> properties;

    public HashMap<String, ITextNode> getTextProperties() {
        return this.properties;
    }

    @Override
    public void addTextProperty(String propertyName, ITextNode node, Collection<ICompilerProblem> problems) {
        if (node instanceof TextLayoutFormatNode) {
            if ("linkActiveFormat".equals(propertyName)) {
                if (this.linkActiveFormat == null) {
                    this.linkActiveFormat = (TextLayoutFormatNode)node;
                    this.linkActiveFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkActiveFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkHoverFormat".equals(propertyName)) {
                if (this.linkHoverFormat == null) {
                    this.linkHoverFormat = (TextLayoutFormatNode)node;
                    this.linkHoverFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkHoverFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else if ("linkNormalFormat".equals(propertyName)) {
                if (this.linkNormalFormat == null) {
                    this.linkNormalFormat = (TextLayoutFormatNode)node;
                    this.linkNormalFormat.setParent(this);
                    if (this.properties == null) {
                        this.properties = new HashMap(3);
                    }
                    this.properties.put(propertyName, this.linkNormalFormat);
                } else {
                    problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), propertyName));
                }
            } else {
                problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), node.getStartLine(), node.getStartColumn(), node.getNodeName(), propertyName));
            }
        } else {
            super.addTextProperty(propertyName, node, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "tcy";
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof SpanNode || child instanceof BRNode || child instanceof TabNode || child instanceof ImgNode || child instanceof LinkNode || child instanceof CDATANode) {
            if (child instanceof LinkNode && ((LinkNode)child).href == null) {
                problems.add(new FXGMissingAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "href", child.getNodeName()));
                return;
            }
            if (child instanceof LinkNode && this.parentNode instanceof LinkNode) {
                problems.add(new FXGInvalidNestingElementsProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
                return;
            }
            if (this.content == null) {
                this.content = new ArrayList();
            }
        } else {
            super.addChild(child, problems);
            return;
        }
        this.content.add((ITextNode)child);
        if (child instanceof AbstractRichTextNode) {
            ((AbstractRichTextNode)child).setParent(this);
        }
    }
}

