/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom.richtext;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.AbstractRichTextLeafNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.NumberPercentAuto;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;

public class ImgNode
extends AbstractRichTextLeafNode {
    public NumberPercentAuto width = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public NumberPercentAuto height = NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
    public String source = "";

    @Override
    public String getNodeName() {
        return "img";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = this.getNumberPercentAuto(this, name, value, this.width.getNumberPercentAutoAsEnum(), problems);
        } else if ("height".equals(name)) {
            this.height = this.getNumberPercentAuto(this, name, value, this.height.getNumberPercentAutoAsEnum(), problems);
        } else if ("source".equals(name)) {
            this.source = value;
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private NumberPercentAuto getNumberPercentAuto(IFXGNode node, String name, String value, NumberPercentAuto.NumberPercentAutoAsEnum defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberPercentAuto.newInstance(DOMParserHelper.parseNumberPercent(this, value, Double.MIN_VALUE, Double.MAX_VALUE));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberPercentAuto.newInstance(NumberPercentAuto.NumberPercentAutoAsEnum.AUTO);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberPercentAuto.newInstance(defaultValue);
        }
    }
}

