/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom.richtext;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.AbstractRichParagraphNode;
import com.adobe.flash.compiler.internal.fxg.dom.richtext.TextHelper;
import com.adobe.flash.compiler.internal.fxg.dom.types.BaselineOffset;
import com.adobe.flash.compiler.internal.fxg.dom.types.BlockProgression;
import com.adobe.flash.compiler.internal.fxg.dom.types.LineBreak;
import com.adobe.flash.compiler.internal.fxg.dom.types.NumberAuto;
import com.adobe.flash.compiler.internal.fxg.dom.types.NumberInherit;
import com.adobe.flash.compiler.internal.fxg.dom.types.VerticalAlign;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;

public abstract class AbstractRichBlockTextNode
extends AbstractRichParagraphNode {
    protected static final double PADDING_MIN_INCLUSIVE = 0.0;
    protected static final double PADDING_MAX_INCLUSIVE = 1000.0;
    protected static final double BASELINEOFFSET_MIN_INCLUSIVE = 0.0;
    protected static final double BASELINEOFFSET_MAX_INCLUSIVE = 1000.0;
    protected static final int COLUMNCOUNT_MIN_INCLUSIVE = 0;
    protected static final int COLUMNCOUNT_MAX_INCLUSIVE = 50;
    protected static final double COLUMNGAP_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNGAP_MAX_INCLUSIVE = 1000.0;
    protected static final double COLUMNWIDTH_MIN_INCLUSIVE = 0.0;
    protected static final double COLUMNWIDTH_MAX_INCLUSIVE = 8000.0;
    public BlockProgression blockProgression = BlockProgression.TB;
    public NumberInherit paddingLeft = NumberInherit.newInstance(0.0);
    public NumberInherit paddingRight = NumberInherit.newInstance(0.0);
    public NumberInherit paddingTop = NumberInherit.newInstance(0.0);
    public NumberInherit paddingBottom = NumberInherit.newInstance(0.0);
    public LineBreak lineBreak = LineBreak.TOFIT;
    public NumberInherit columnGap = NumberInherit.newInstance(20.0);
    public NumberAuto columnCount = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public NumberAuto columnWidth = NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
    public BaselineOffset firstBaselineOffset = BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
    public VerticalAlign verticalAlign = VerticalAlign.TOP;

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("blockProgression".equals(name)) {
            this.blockProgression = TextHelper.getBlockProgression(this, value, this.blockProgression, problems);
        } else if ("paddingLeft".equals(name)) {
            this.paddingLeft = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingLeft.getNumberInheritAsDbl(), problems);
        } else if ("paddingRight".equals(name)) {
            this.paddingRight = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingRight.getNumberInheritAsDbl(), problems);
        } else if ("paddingTop".equals(name)) {
            this.paddingTop = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingTop.getNumberInheritAsDbl(), problems);
        } else if ("paddingBottom".equals(name)) {
            this.paddingBottom = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.paddingBottom.getNumberInheritAsDbl(), problems);
        } else if ("lineBreak".equals(name)) {
            this.lineBreak = TextHelper.getLineBreak(this, value, this.lineBreak, problems);
        } else if ("columnGap".equals(name)) {
            this.columnGap = this.getNumberInherit(this, name, value, 0.0, 1000.0, this.columnGap.getNumberInheritAsDbl(), problems);
        } else if ("columnCount".equals(name)) {
            this.columnCount = this.getNumberAutoInt(this, name, value, 0, 50, this.columnCount.getNumberAutoAsInt(), problems);
        } else if ("columnWidth".equals(name)) {
            this.columnWidth = this.getNumberAutoDbl(this, name, value, 0.0, 8000.0, this.columnWidth.getNumberAutoAsDbl(), problems);
        } else if ("firstBaselineOffset".equals(name)) {
            this.firstBaselineOffset = this.getFirstBaselineOffset(this, name, value, 0.0, 1000.0, this.firstBaselineOffset.getBaselineOffsetAsDbl(), problems);
        } else if ("verticalAlign".equals(name)) {
            this.verticalAlign = TextHelper.getVerticalAlign(this, value, this.verticalAlign, problems);
        } else {
            super.setAttribute(name, value, problems);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private BaselineOffset getFirstBaselineOffset(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        if ("auto".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.AUTO);
        }
        if ("ascent".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.ASCENT);
        }
        if ("lineHeight".equals(value)) {
            return BaselineOffset.newInstance(BaselineOffset.BaselineOffsetAsEnum.LINEHEIGHT);
        }
        try {
            return BaselineOffset.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return BaselineOffset.newInstance(defaultValue);
        }
    }

    private NumberAuto getNumberAutoDbl(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberAuto.newInstance(defaultValue);
        }
    }

    private NumberAuto getNumberAutoInt(IFXGNode node, String name, String value, int min, int max, int defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberAuto.newInstance(DOMParserHelper.parseInt(this, value, min, max));
        }
        catch (Exception e) {
            if ("auto".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.AUTO);
            }
            if ("inherit".equals(value)) {
                return NumberAuto.newInstance(NumberAuto.NumberAutoAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberAuto.newInstance(defaultValue);
        }
    }

    private NumberInherit getNumberInherit(IFXGNode node, String name, String value, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, min, max));
        }
        catch (Exception e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return NumberInherit.newInstance(defaultValue);
        }
    }
}

