/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicContentNode;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicContext;
import com.adobe.flash.compiler.internal.fxg.dom.IMaskingNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.ScalingGrid;
import com.adobe.flash.compiler.problems.FXGInvalidScaleGridGroupChildProblem;
import com.adobe.flash.compiler.problems.FXGInvalidScaleGridRotationAttributeProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupNode
extends GraphicContentNode
implements IMaskingNode {
    public double scaleGridLeft = 0.0;
    public double scaleGridRight = 0.0;
    public double scaleGridTop = 0.0;
    public double scaleGridBottom = 0.0;
    public List<GraphicContentNode> children;
    private boolean definesScaleGrid;
    private boolean insideScaleGrid;
    private int maskIndex;

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> childrenRes = new ArrayList<IFXGNode>();
        childrenRes.addAll(super.getChildren());
        if (this.children != null) {
            childrenRes.addAll(this.children);
        }
        return childrenRes;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof GraphicContentNode) {
            if (this.children == null) {
                this.children = new ArrayList<GraphicContentNode>();
            }
            GraphicContentNode graphicContent = (GraphicContentNode)child;
            graphicContent.setParentGraphicContext(this.createGraphicContext());
            if (child instanceof GroupNode && this.isInsideScaleGrid()) {
                problems.add(new FXGInvalidScaleGridGroupChildProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            this.children.add(graphicContent);
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public String getNodeName() {
        return "Group";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("scaleGridLeft".equals(name)) {
            this.scaleGridLeft = DOMParserHelper.parseDouble(this, value, name, this.scaleGridLeft, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridTop".equals(name)) {
            this.scaleGridTop = DOMParserHelper.parseDouble(this, value, name, this.scaleGridTop, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridRight".equals(name)) {
            this.scaleGridRight = DOMParserHelper.parseDouble(this, value, name, this.scaleGridRight, problems);
            this.definesScaleGrid = true;
        } else if ("scaleGridBottom".equals(name)) {
            this.scaleGridBottom = DOMParserHelper.parseDouble(this, value, name, this.scaleGridBottom, problems);
            this.definesScaleGrid = true;
        } else {
            super.setAttribute(name, value, problems);
        }
        if (this.definesScaleGrid && this.rotationSet) {
            problems.add(new FXGInvalidScaleGridRotationAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn()));
            return;
        }
    }

    @Override
    public GraphicContext createGraphicContext() {
        GraphicContext context = super.createGraphicContext();
        if (this.definesScaleGrid()) {
            ScalingGrid scalingGrid = new ScalingGrid();
            scalingGrid.scaleGridLeft = this.scaleGridLeft;
            scalingGrid.scaleGridTop = this.scaleGridTop;
            scalingGrid.scaleGridRight = this.scaleGridRight;
            scalingGrid.scaleGridBottom = this.scaleGridBottom;
            context.scalingGrid = scalingGrid;
        }
        return context;
    }

    public boolean definesScaleGrid() {
        return this.definesScaleGrid;
    }

    public boolean isInsideScaleGrid() {
        return this.insideScaleGrid || this.definesScaleGrid;
    }

    public void setInsideScaleGrid(boolean value) {
        this.insideScaleGrid = value;
    }

    @Override
    public int getMaskIndex() {
        return this.maskIndex;
    }

    @Override
    public void setMaskIndex(int index) {
        this.maskIndex = index;
    }
}

