/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.fxg.FXGVersion;
import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.fxg.logging.FXGLog;
import com.adobe.flash.compiler.internal.fxg.dom.AbstractFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicContext;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicNode;
import com.adobe.flash.compiler.internal.fxg.dom.IFilterNode;
import com.adobe.flash.compiler.internal.fxg.dom.IMaskableNode;
import com.adobe.flash.compiler.internal.fxg.dom.IMaskingNode;
import com.adobe.flash.compiler.internal.fxg.dom.MaskPropertyNode;
import com.adobe.flash.compiler.internal.fxg.dom.transforms.ColorTransformNode;
import com.adobe.flash.compiler.internal.fxg.dom.transforms.MatrixNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.BlendMode;
import com.adobe.flash.compiler.internal.fxg.dom.types.MaskType;
import com.adobe.flash.compiler.internal.fxg.types.FXGMatrix;
import com.adobe.flash.compiler.problems.FXGInvalidChildColorTransformNodeProblem;
import com.adobe.flash.compiler.problems.FXGInvalidChildMatrixNodeProblem;
import com.adobe.flash.compiler.problems.FXGInvalidNodeAttributeProblem;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class GraphicContentNode
extends AbstractFXGNode
implements IMaskableNode {
    protected String id = "undefined";
    public boolean visible = true;
    public double x = 0.0;
    public double y = 0.0;
    public double scaleX = 1.0;
    public double scaleY = 1.0;
    public double rotation = 0.0;
    public double alpha = 1.0;
    public BlendMode blendMode = BlendMode.AUTO;
    public MaskType maskType = MaskType.CLIP;
    public boolean luminosityClip = false;
    public boolean luminosityInvert = false;
    protected boolean translateSet;
    protected boolean scaleSet;
    protected boolean rotationSet;
    protected boolean alphaSet;
    protected boolean maskTypeSet;
    public boolean isPartofClipMask = false;
    public List<IFilterNode> filters;
    public IMaskingNode mask;
    public MatrixNode matrix;
    public ColorTransformNode colorTransform;
    private GraphicContext parentGraphicContext;

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.filters != null) {
            children.addAll(this.filters);
        }
        children.add(this.mask);
        children.add(this.matrix);
        children.add(this.colorTransform);
        return children;
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof IFilterNode) {
            if (this.filters == null) {
                this.filters = new ArrayList<IFilterNode>();
            }
            this.filters.add((IFilterNode)child);
        } else if (child instanceof MaskPropertyNode) {
            this.mask = ((MaskPropertyNode)child).mask;
            if (this.mask instanceof GraphicContentNode) {
                ((GraphicContentNode)((Object)this.mask)).setParentGraphicContext(this.createGraphicContext());
            }
        } else if (child instanceof MatrixNode) {
            if (this.translateSet || this.scaleSet || this.rotationSet) {
                problems.add(new FXGInvalidChildMatrixNodeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            this.matrix = (MatrixNode)child;
        } else if (child instanceof ColorTransformNode) {
            if (this.alphaSet) {
                problems.add(new FXGInvalidChildColorTransformNodeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            this.colorTransform = (ColorTransformNode)child;
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name, this.x, problems);
            this.translateSet = true;
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name, this.y, problems);
            this.translateSet = true;
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name, this.rotation, problems);
            this.rotationSet = true;
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name, this.scaleX, problems);
            this.scaleSet = true;
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name, this.scaleY, problems);
            this.scaleSet = true;
        } else if ("alpha".equals(name)) {
            this.alpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.alpha, problems);
            this.alphaSet = true;
        } else if ("blendMode".equals(name)) {
            this.blendMode = this.parseBlendMode(value, this.blendMode, problems);
        } else if ("visible".equals(name)) {
            this.visible = DOMParserHelper.parseBoolean(this, value, name, this.visible, problems);
        } else if ("id".equals(name)) {
            this.id = value;
        } else if ("maskType".equals(name)) {
            this.maskType = DOMParserHelper.parseMaskType(this, value, this.maskType, problems);
            this.maskTypeSet = true;
        } else {
            if (this.getFileVersion().equalTo(FXGVersion.v1_0)) {
                problems.add(new FXGInvalidNodeAttributeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), name, this.getNodeName()));
                return;
            }
            if ("luminosityClip".equals(name)) {
                this.luminosityClip = DOMParserHelper.parseBoolean(this, value, name, this.luminosityClip, problems);
            } else if ("luminosityInvert".equals(name)) {
                this.luminosityInvert = DOMParserHelper.parseBoolean(this, value, name, this.luminosityInvert, problems);
            } else {
                super.setAttribute(name, value, problems);
            }
        }
    }

    @Override
    public IMaskingNode getMask() {
        return this.mask;
    }

    @Override
    public MaskType getMaskType() {
        return this.maskType;
    }

    @Override
    public boolean getLuminosityClip() {
        return this.luminosityClip;
    }

    @Override
    public boolean getLuminosityInvert() {
        return this.luminosityInvert;
    }

    public GraphicContext createGraphicContext() {
        GraphicContext graphicContext = new GraphicContext();
        if (this.parentGraphicContext != null) {
            graphicContext.scalingGrid = this.parentGraphicContext.scalingGrid;
        }
        FXGMatrix transform = graphicContext.getTransform();
        if (this.matrix != null) {
            FXGMatrix t = new FXGMatrix(this.matrix);
            transform.concat(t);
        } else {
            if (this.scaleSet) {
                transform.scale(this.scaleX, this.scaleY);
            }
            if (this.rotationSet) {
                transform.rotate(this.rotation);
            }
            if (this.translateSet) {
                transform.translate(this.x, this.y);
            }
        }
        if (this.colorTransform != null) {
            graphicContext.colorTransform = this.colorTransform;
        } else if (this.alphaSet) {
            if (graphicContext.colorTransform == null) {
                graphicContext.colorTransform = new ColorTransformNode();
            }
            graphicContext.colorTransform.alphaMultiplier = this.alpha;
        }
        graphicContext.blendMode = this.blendMode;
        if (this.filters != null) {
            graphicContext.addFilters(this.filters);
        }
        if (this.maskTypeSet) {
            graphicContext.maskType = this.maskType;
        } else if (this.parentGraphicContext != null) {
            graphicContext.maskType = this.parentGraphicContext.maskType;
        }
        return graphicContext;
    }

    public void setParentGraphicContext(GraphicContext context) {
        this.parentGraphicContext = context;
    }

    protected BlendMode parseBlendMode(String value, BlendMode defMode, Collection<ICompilerProblem> problems) {
        FXGVersion fileVersion = ((GraphicNode)this.getDocumentNode()).getVersion();
        if ("add".equals(value)) {
            return BlendMode.ADD;
        }
        if ("alpha".equals(value)) {
            return BlendMode.ALPHA;
        }
        if ("darken".equals(value)) {
            return BlendMode.DARKEN;
        }
        if ("difference".equals(value)) {
            return BlendMode.DIFFERENCE;
        }
        if ("erase".equals(value)) {
            return BlendMode.ERASE;
        }
        if ("hardlight".equals(value)) {
            return BlendMode.HARDLIGHT;
        }
        if ("invert".equals(value)) {
            return BlendMode.INVERT;
        }
        if ("layer".equals(value)) {
            return BlendMode.LAYER;
        }
        if ("lighten".equals(value)) {
            return BlendMode.LIGHTEN;
        }
        if ("multiply".equals(value)) {
            return BlendMode.MULTIPLY;
        }
        if ("normal".equals(value)) {
            return BlendMode.NORMAL;
        }
        if ("overlay".equals(value)) {
            return BlendMode.OVERLAY;
        }
        if ("screen".equals(value)) {
            return BlendMode.SCREEN;
        }
        if ("subtract".equals(value)) {
            return BlendMode.SUBTRACT;
        }
        if (fileVersion.equalTo(FXGVersion.v1_0)) {
            problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "blendMode", value));
        } else {
            if ("colordodge".equals(value)) {
                return BlendMode.COLORDODGE;
            }
            if ("colorburn".equals(value)) {
                return BlendMode.COLORBURN;
            }
            if ("exclusion".equals(value)) {
                return BlendMode.EXCLUSION;
            }
            if ("softlight".equals(value)) {
                return BlendMode.SOFTLIGHT;
            }
            if ("hue".equals(value)) {
                return BlendMode.HUE;
            }
            if ("saturation".equals(value)) {
                return BlendMode.SATURATION;
            }
            if ("color".equals(value)) {
                return BlendMode.COLOR;
            }
            if ("luminosity".equals(value)) {
                return BlendMode.LUMINOSITY;
            }
            if ("auto".equals(value)) {
                return BlendMode.AUTO;
            }
            if (this.isVersionGreaterThanCompiler()) {
                FXGLog.getLogger().log(30000, "UnknownBlendMode", null, this.getDocumentPath(), this.startLine, this.startColumn);
            } else {
                problems.add(new FXGUnknownAttributeValueProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "blendMode", value));
            }
        }
        return defMode;
    }

    public void convertTransformAttrToMatrix(Collection<ICompilerProblem> problems) {
        try {
            MatrixNode matrixNode = (MatrixNode)MatrixNode.class.newInstance();
            FXGMatrix matrix = FXGMatrix.convertToMatrix(this.scaleX, this.scaleY, this.rotation, this.x, this.y);
            matrix.setMatrixNodeValue(matrixNode);
            this.resetTransformAttr();
            this.addChild(matrixNode, problems);
        }
        catch (Throwable t) {
            problems.add(new FXGInvalidChildMatrixNodeProblem(this.mask.getDocumentPath(), this.mask.getStartLine(), this.mask.getStartColumn()));
        }
    }

    private void resetTransformAttr() {
        this.x = 0.0;
        this.y = 0.0;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.rotation = 0.0;
        this.translateSet = false;
        this.scaleSet = false;
        this.rotationSet = false;
    }
}

