/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.internal.fxg.dom.AbstractShapeNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.swf.types.LineStyle;
import com.adobe.flash.swf.types.Rect;
import com.adobe.flash.swf.types.ShapeRecord;
import java.util.Collection;
import java.util.List;

public class EllipseNode
extends AbstractShapeNode {
    public double width = 0.0;
    public double height = 0.0;

    @Override
    public String getNodeName() {
        return "Ellipse";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name, this.width, problems);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name, this.height, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }

    @Override
    public Rect getBounds(List<ShapeRecord> records, LineStyle ls) {
        int x1 = 0;
        int y1 = 0;
        int x2 = (int)(this.width * 20.0);
        int y2 = (int)(this.height * 20.0);
        if (ls != null) {
            int width = 20;
            if (width < ls.getWidth()) {
                width = ls.getWidth();
            }
            int stroke = (int)Math.rint((double)width / 2.0);
            x1 -= stroke;
            y1 -= stroke;
            x2 += stroke;
            y2 += stroke;
        }
        return new Rect(x1, x2, y1, y2);
    }
}

