/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.AbstractFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DOMParserHelper;
import com.adobe.flash.compiler.internal.fxg.dom.GraphicNode;
import com.adobe.flash.compiler.internal.fxg.dom.GroupDefinitionNode;
import com.adobe.flash.compiler.problems.FXGInvalidDefinitionNameProblem;
import com.adobe.flash.compiler.problems.FXGMissingGroupChildNodeProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefinitionNode
extends AbstractFXGNode {
    public String name;
    public GroupDefinitionNode groupDefinition;

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof GroupDefinitionNode) {
            if (this.groupDefinition != null) {
                problems.add(new FXGMissingGroupChildNodeProblem(this.getDocumentPath(), child.getStartLine(), child.getStartColumn()));
                return;
            }
            this.groupDefinition = (GroupDefinitionNode)child;
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        if (this.groupDefinition != null) {
            children.add(this.groupDefinition);
        }
        return children;
    }

    @Override
    public String getNodeName() {
        return "Definition";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("name".equals(name)) {
            this.name = DOMParserHelper.parseIdentifier(this, name, value, this.name, problems);
            if (((GraphicNode)this.getDocumentNode()).reservedNodes.containsKey(value)) {
                problems.add(new FXGInvalidDefinitionNameProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), value));
                return;
            }
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

