/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.fxg.FXGVersion;
import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.fxg.logging.FXGLog;
import com.adobe.flash.compiler.internal.fxg.dom.AbstractFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.types.FillMode;
import com.adobe.flash.compiler.internal.fxg.dom.types.InterpolationMethod;
import com.adobe.flash.compiler.internal.fxg.dom.types.MaskType;
import com.adobe.flash.compiler.internal.fxg.dom.types.SpreadMethod;
import com.adobe.flash.compiler.problems.FXGInvalidBooleanValueProblem;
import com.adobe.flash.compiler.problems.FXGInvalidColorValueProblem;
import com.adobe.flash.compiler.problems.FXGInvalidDoubleValueProblem;
import com.adobe.flash.compiler.problems.FXGInvalidFloatValueProblem;
import com.adobe.flash.compiler.problems.FXGInvalidIntegerValueProblem;
import com.adobe.flash.compiler.problems.FXGInvalidPercentValueProblem;
import com.adobe.flash.compiler.problems.FXGOutOfRangeValueProblem;
import com.adobe.flash.compiler.problems.FXGUnknownAttributeValueProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DOMParserHelper {
    public static Pattern idPattern = Pattern.compile("[a-zA-Z_][a-zA-Z_0-9]*");
    public static Pattern rgbPattern = Pattern.compile("#[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]");

    public static boolean parseBoolean(IFXGNode node, String value, String name, boolean defaultValue, Collection<ICompilerProblem> problems) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        problems.add(new FXGInvalidBooleanValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
        return defaultValue;
    }

    public static int parseRGB(IFXGNode node, String value, String name, int defaultValue, Collection<ICompilerProblem> problems) {
        Matcher m = rgbPattern.matcher(value);
        if (!m.matches()) {
            problems.add(new FXGInvalidColorValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return defaultValue;
        }
        value = value.substring(1);
        int a = 255;
        int r = Integer.parseInt(value.substring(0, 2), 16) & 0xFF;
        int g = Integer.parseInt(value.substring(2, 4), 16) & 0xFF;
        int b = Integer.parseInt(value.substring(4, 6), 16) & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static double parseDouble(IFXGNode node, String value, String name, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            problems.add(new FXGInvalidDoubleValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return defaultValue;
        }
    }

    public static double parsePercent(IFXGNode node, String value, String name, double defaultValue, Collection<ICompilerProblem> problems) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            try {
                String doubleValue = value.substring(0, value.length() - 1);
                return DOMParserHelper.parseDouble(node, doubleValue, Double.MIN_VALUE, Double.MAX_VALUE);
            }
            catch (Exception e) {
                problems.add(new FXGInvalidPercentValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
                return defaultValue;
            }
        }
        return DOMParserHelper.parseDouble(node, value, name, defaultValue, problems);
    }

    public static double parseNumberPercent(IFXGNode node, String value, String name, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            try {
                String doubleValue = value.substring(0, value.length() - 1);
                return DOMParserHelper.parseDouble(node, doubleValue, min, max);
            }
            catch (Exception e) {
                problems.add(new FXGInvalidPercentValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
                return defaultValue;
            }
        }
        return DOMParserHelper.parseDouble(node, value, name, min, max, defaultValue, problems);
    }

    public static double parseNumberPercent(IFXGNode node, String value, double min, double max) throws NumberFormatException {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            String doubleValue = value.substring(0, value.length() - 1);
            return DOMParserHelper.parseDouble(node, doubleValue, min, max);
        }
        return DOMParserHelper.parseDouble(node, value, min, max);
    }

    public static double parseNumberPercentWithSeparateRange(IFXGNode node, String value, String name, double minNumber, double maxNumber, double minPercent, double maxPercent, double defaultValue, Collection<ICompilerProblem> problems) {
        if (value.length() != 0 && value.charAt(value.length() - 1) == '%') {
            try {
                String doubleValue = value.substring(0, value.length() - 1);
                return DOMParserHelper.parseDouble(node, doubleValue, minPercent, maxPercent);
            }
            catch (Exception e) {
                problems.add(new FXGInvalidPercentValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
                return defaultValue;
            }
        }
        return DOMParserHelper.parseDouble(node, value, name, minNumber, maxNumber, defaultValue, problems);
    }

    public static double parseDouble(IFXGNode node, String value, double min, double max) throws NumberFormatException {
        double d = Double.parseDouble(value);
        if (d >= min && d <= max) {
            return d;
        }
        throw new NumberFormatException("Double is out of bounds");
    }

    public static double parseDouble(IFXGNode node, String value, String name, double min, double max, double defaultValue, Collection<ICompilerProblem> problems) {
        try {
            double d = Double.parseDouble(value);
            if (d >= min && d <= max) {
                return d;
            }
        }
        catch (NumberFormatException e) {
            problems.add(new FXGInvalidDoubleValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return defaultValue;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGOutOfRangeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value, min, max));
        }
        return defaultValue;
    }

    public static float parseFloat(IFXGNode node, String name, String value, float defaultValue, Collection<ICompilerProblem> problems) {
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            problems.add(new FXGInvalidFloatValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return defaultValue;
        }
    }

    public static float parseFloat(IFXGNode node, String value) throws NumberFormatException {
        return Float.parseFloat(value);
    }

    public static int parseInt(IFXGNode node, String value, String name, int min, int max, int defaultValue, Collection<ICompilerProblem> problems) {
        try {
            int i = Integer.parseInt(value);
            if (i >= min && i <= max) {
                return i;
            }
        }
        catch (NumberFormatException e) {
            problems.add(new FXGInvalidIntegerValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
            return defaultValue;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGOutOfRangeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value, min, max));
        }
        return defaultValue;
    }

    public static int parseInt(IFXGNode node, String value, int min, int max) throws NumberFormatException {
        int i = Integer.parseInt(value);
        if (i >= min && i <= max) {
            return i;
        }
        throw new NumberFormatException("Integer is out of bounds");
    }

    public static InterpolationMethod parseInterpolationMethod(IFXGNode node, String value, InterpolationMethod defaultValue, Collection<ICompilerProblem> problems) {
        if ("rgb".equals(value)) {
            return InterpolationMethod.RGB;
        }
        if ("linearRGB".equals(value)) {
            return InterpolationMethod.LINEAR_RGB;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "interpolationMethod", value));
        }
        return defaultValue;
    }

    public static MaskType parseMaskType(IFXGNode node, String value, MaskType defaultValue, Collection<ICompilerProblem> problems) {
        if ("clip".equals(value)) {
            return MaskType.CLIP;
        }
        if ("alpha".equals(value)) {
            return MaskType.ALPHA;
        }
        if (((AbstractFXGNode)node).getFileVersion().equalTo(FXGVersion.v1_0)) {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "maskType", value));
            return defaultValue;
        }
        if ("luminosity".equals(value)) {
            return MaskType.LUMINOSITY;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "maskType", value));
        }
        return defaultValue;
    }

    public static FillMode parseFillMode(IFXGNode node, String value, FillMode defaultValue, Collection<ICompilerProblem> problems) {
        if ("clip".equals(value)) {
            return FillMode.CLIP;
        }
        if ("repeat".equals(value)) {
            return FillMode.REPEAT;
        }
        if ("scale".equals(value)) {
            return FillMode.SCALE;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "fillMode", value));
        }
        return defaultValue;
    }

    public static SpreadMethod parseSpreadMethod(IFXGNode node, String value, SpreadMethod defaultValue, Collection<ICompilerProblem> problems) {
        if ("pad".equals(value)) {
            return SpreadMethod.PAD;
        }
        if ("reflect".equals(value)) {
            return SpreadMethod.REFLECT;
        }
        if ("repeat".equals(value)) {
            return SpreadMethod.REPEAT;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "spreadMethod", value));
        }
        return defaultValue;
    }

    public static String parseIdentifier(IFXGNode node, String name, String value, String defaultValue, Collection<ICompilerProblem> problems) {
        Matcher m = idPattern.matcher(value);
        if (m.matches()) {
            return value;
        }
        if (((AbstractFXGNode)node).isVersionGreaterThanCompiler()) {
            FXGLog.getLogger().log(30000, "DefaultAttributeValue", null, ((AbstractFXGNode)node).getDocumentPath(), node.getStartLine(), node.getStartColumn());
        } else {
            problems.add(new FXGUnknownAttributeValueProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), name, value));
        }
        return defaultValue;
    }
}

