/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.fxg.dom;

import com.adobe.flash.compiler.fxg.dom.IFXGNode;
import com.adobe.flash.compiler.internal.fxg.dom.DelegateNode;
import com.adobe.flash.compiler.internal.fxg.dom.IPreserveWhiteSpaceNode;
import com.adobe.flash.compiler.internal.fxg.dom.ITextNode;
import com.adobe.flash.compiler.internal.fxg.dom.RichTextNode;
import com.adobe.flash.compiler.internal.fxg.dom.TextGraphicNode;
import com.adobe.flash.compiler.problems.FXGInvalidChildNodeProblem;
import com.adobe.flash.compiler.problems.FXGMultipleElementProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import java.util.Collection;

public class ContentPropertyNode
extends DelegateNode
implements IPreserveWhiteSpaceNode {
    @Override
    public void setDelegate(IFXGNode delegate, Collection<ICompilerProblem> problems) {
        if (!(delegate instanceof ITextNode)) {
            problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), this.getNodeName(), delegate.getNodeName()));
            return;
        }
        if (delegate instanceof RichTextNode && ((RichTextNode)delegate).content != null) {
            problems.add(new FXGMultipleElementProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), "content"));
            return;
        }
        super.setDelegate(delegate, problems);
    }

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (this.delegate instanceof TextGraphicNode) {
            ((TextGraphicNode)this.delegate).addContentChild(child, problems);
        } else if (this.delegate instanceof RichTextNode) {
            ((RichTextNode)this.delegate).addContentChild(child, problems);
        } else {
            problems.add(new FXGInvalidChildNodeProblem(this.getDocumentPath(), this.getStartLine(), this.getStartColumn(), child.getNodeName(), this.getNodeName()));
        }
    }
}

