/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.filespecs;

import com.adobe.flash.compiler.filespecs.IFileSpecification;
import com.adobe.flash.utils.FilenameNormalization;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;

public class StringFileSpecification
implements IFileSpecification {
    private final String content;
    private final String name;
    private final long lastModified;

    public StringFileSpecification(String name, String content) {
        this(name, content, 0L);
    }

    public StringFileSpecification(String name, String content, long lastModified) {
        this.name = FilenameNormalization.normalize(name);
        this.content = content;
        this.lastModified = lastModified;
    }

    public StringFileSpecification(String content) {
        this("", content, 0L);
    }

    @Override
    public String getPath() {
        return this.name;
    }

    @Override
    public Reader createReader() throws FileNotFoundException {
        return new StringReader(this.content);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isOpenDocument() {
        return false;
    }
}

