/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.embedding.transcoders;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.embedding.transcoders.TranscoderBase;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.EmbedCouldNotDetermineSampleFrameCountProblem;
import com.adobe.flash.compiler.problems.EmbedUnsupportedSamplingRateProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.swf.tags.DefineSoundTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.utils.DAByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class SoundTranscoder
extends TranscoderBase {
    private static final int[][] mp3frequencies = new int[][]{{11025, 0, 22050, 44100}, {12000, 0, 24000, 48000}, {8000, 0, 16000, 32000}, {0, 0, 0, 0}};
    private static final int[][] mp3bitrates = new int[][]{{0, 0, 0, 0, 0}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private static final int[][] mp3bitrateIndices = new int[][]{{-1, 4, 4, 3}, {-1, -1, -1, -1}, {-1, 4, 4, 3}, {-1, 2, 1, 0}};

    public SoundTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        this.baseClassQName = "flash.media.Sound";
        return result;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        InputStream strm = this.getDataStream(problems);
        if (strm == null) {
            return null;
        }
        DefineSoundTag assetTag = this.buildSound(strm, problems);
        if (assetTag == null) {
            return null;
        }
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(this.data.getQName(), assetTag);
        return symbolTags;
    }

    private DefineSoundTag buildSound(InputStream strm, Collection<ICompilerProblem> problems) {
        int rate;
        byte[] soundData = this.readFully(strm);
        if (soundData == null) {
            return null;
        }
        DefineSoundTag tag = new DefineSoundTag();
        tag.setSoundData(soundData);
        tag.setSoundFormat(2);
        tag.setSoundSize(1);
        int version = soundData[3] >> 3 & 3;
        int layer = soundData[3] >> 1 & 3;
        int samplingRate = soundData[4] >> 2 & 3;
        int channelMode = soundData[5] >> 6 & 3;
        int frequency = mp3frequencies[samplingRate][version];
        switch (frequency) {
            case 11025: {
                rate = 1;
                break;
            }
            case 22050: {
                rate = 2;
                break;
            }
            case 44100: {
                rate = 3;
                break;
            }
            default: {
                problems.add(new EmbedUnsupportedSamplingRateProblem(this.data, frequency));
                return null;
            }
        }
        tag.setSoundRate(rate);
        tag.setSoundType(channelMode == 3 ? 0 : 1);
        long sampleCount = this.countFrames(soundData) * (layer == 3 ? 384 : 1152);
        tag.setSoundSampleCount(sampleCount);
        if (sampleCount < 0L) {
            problems.add(new EmbedCouldNotDetermineSampleFrameCountProblem(this.data));
            return null;
        }
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFully(InputStream inputStream) {
        BufferedInputStream in = new BufferedInputStream(inputStream);
        DAByteArrayOutputStream baos = new DAByteArrayOutputStream();
        baos.write(0);
        baos.write(0);
        int state = 0;
        try {
            int b;
            while ((b = in.read()) != -1) {
                if (state == 0) {
                    if (b != 255) continue;
                    state = 1;
                    continue;
                }
                if (state == 1) {
                    if ((b >> 5 & 7) == 7) {
                        baos.write(255);
                        baos.write(b);
                        state = 2;
                        continue;
                    }
                    state = 0;
                    continue;
                }
                if (state != 2) continue;
                baos.write(b);
            }
            byte[] byArray = baos.getDirectByteArray();
            return byArray;
        }
        catch (IOException e) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baos);
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
        return new byte[0];
    }

    private int countFrames(byte[] bytes) {
        int count = 0;
        int start = 2;
        boolean skipped = false;
        while (start + 2 < bytes.length) {
            int frameLength;
            int bitrate;
            int b1 = bytes[start] & 0xFF;
            int b2 = bytes[start + 1] & 0xFF;
            int b3 = bytes[start + 2] & 0xFF;
            if (b1 != 255 || (b2 >> 5 & 7) != 7) {
                if (!skipped && start > 0) {
                    b3 = b2;
                    b2 = b1;
                    b1 = bytes[start - 1] & 0xFF;
                    if (b1 != 255 || (b2 >> 5 & 7) != 7) {
                        ++start;
                        continue;
                    }
                    --start;
                } else {
                    ++start;
                    continue;
                }
            }
            int version = b2 >> 3 & 3;
            int layer = b2 >> 1 & 3;
            int bits = b3 >> 4 & 0xF;
            int bitrateIndex = mp3bitrateIndices[version][layer];
            int n = bitrate = bitrateIndex != -1 ? mp3bitrates[bits][bitrateIndex] * 1000 : -1;
            if (bitrate == -1) {
                skipped = true;
                ++start;
                continue;
            }
            int samplingRate = b3 >> 2 & 3;
            int frequency = mp3frequencies[samplingRate][version];
            if (frequency == 0) {
                skipped = true;
                ++start;
                continue;
            }
            int padding = b3 >> 1 & 1;
            int n2 = frameLength = layer == 3 ? (12 * bitrate / frequency + padding) * 4 : 144 * bitrate / frequency + padding;
            if (frameLength == 0) break;
            start += frameLength;
            skipped = false;
            ++count;
        }
        return count;
    }
}

