/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.embedding.transcoders;

import com.adobe.flash.compiler.common.IFileSpecificationGetter;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.caches.SWFCache;
import com.adobe.flash.compiler.internal.embedding.EmbedAttribute;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.embedding.transcoders.ScalableTranscoder;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.targets.FlexFontInfo;
import com.adobe.flash.compiler.internal.targets.TagSorter;
import com.adobe.flash.compiler.internal.tree.as.ClassNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionCallNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.ImportNode;
import com.adobe.flash.compiler.internal.tree.as.LanguageIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NumericLiteralNode;
import com.adobe.flash.compiler.internal.tree.as.PackageNode;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.EmbedAS2TagsModifiedProblem;
import com.adobe.flash.compiler.problems.EmbedBadScalingGridTargetProblem;
import com.adobe.flash.compiler.problems.EmbedMissingSymbolProblem;
import com.adobe.flash.compiler.problems.EmbedMovieScalingNoSymbolProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCManager;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.io.SWFReader;
import com.adobe.flash.swf.tags.DefineBitsLosslessTag;
import com.adobe.flash.swf.tags.DefineBitsTag;
import com.adobe.flash.swf.tags.DefineButtonTag;
import com.adobe.flash.swf.tags.DefineFont2Tag;
import com.adobe.flash.swf.tags.DefineFont4Tag;
import com.adobe.flash.swf.tags.DefineFontTag;
import com.adobe.flash.swf.tags.DefineScalingGridTag;
import com.adobe.flash.swf.tags.DefineSoundTag;
import com.adobe.flash.swf.tags.DefineSpriteTag;
import com.adobe.flash.swf.tags.DefineTextTag;
import com.adobe.flash.swf.tags.ExportAssetsTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.swf.tags.PlaceObject2Tag;
import com.adobe.flash.swf.tags.SymbolClassTag;
import com.adobe.flash.swf.types.Rect;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;

public class MovieTranscoder
extends ScalableTranscoder {
    private String symbol = null;
    private ICharacterTag symbolTag = null;
    private FlexFontInfo flexFontInfo = null;
    private int swfWidth = 0;
    private int swfHeight = 0;

    public MovieTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        Rect swfSize;
        boolean result = super.analyze(location, problems);
        if (!result) {
            return false;
        }
        SWFReader swfReader = this.getSWFReader(problems);
        if (swfReader == null) {
            return false;
        }
        ISWF swf = swfReader.getSWF();
        if (swf == null) {
            return false;
        }
        if (this.symbol == null) {
            this.baseClassQName = "flash.compiler.embed.EmbeddedMovieClip";
            if (this.scaling) {
                problems.add(new EmbedMovieScalingNoSymbolProblem(location));
            }
        } else {
            this.symbolTag = this.getSWFTag(swfReader, this.symbol, problems);
            if (this.symbolTag == null) {
                problems.add(new EmbedMissingSymbolProblem(location, this.source, this.symbol));
                return false;
            }
            if (this.scaling && !(this.symbolTag instanceof DefineSpriteTag)) {
                problems.add(new EmbedBadScalingGridTargetProblem(location, this.symbol));
                return false;
            }
            this.baseClassQName = this.symbolTag instanceof DefineSpriteTag && ((DefineSpriteTag)this.symbolTag).getFrameCount() > 1 ? "flash.display.MovieClip" : this.getAssociatedClass(this.symbolTag);
            if (this.symbolTag instanceof DefineFont2Tag) {
                this.flexFontInfo = new FlexFontInfo(((DefineFont2Tag)this.symbolTag).isFontFlagsBold(), ((DefineFont2Tag)this.symbolTag).isFontFlagsItalic());
            } else if (this.symbolTag instanceof DefineFont4Tag) {
                this.flexFontInfo = new FlexFontInfo(((DefineFont4Tag)this.symbolTag).isFontFlagsBold(), ((DefineFont4Tag)this.symbolTag).isFontFlagsItalic());
            }
        }
        if ((swfSize = swf.getFrameSize()) != null) {
            this.swfWidth = swfSize.getWidth() / 20;
            this.swfHeight = swfSize.getHeight() / 20;
        } else {
            result = false;
        }
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case SYMBOL: {
                this.symbol = (String)this.data.getAttribute(EmbedAttribute.SYMBOL);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        String symbolName;
        ICharacterTag assetTag = null;
        if (this.symbolTag != null) {
            symbolName = this.data.getQName();
            LinkedHashSet<ITag> sortedTags = new LinkedHashSet<ITag>();
            sortedTags.addAll(TagSorter.sortFullGraph(Collections.singletonList(this.symbolTag)));
            if (this.scaling) {
                tags.addAll(sortedTags);
                assetTag = this.scaleExistingSprite((DefineSpriteTag)this.symbolTag, tags, problems);
            } else {
                sortedTags.remove(this.symbolTag);
                tags.addAll(sortedTags);
                assetTag = this.symbolTag;
            }
        } else {
            symbolName = this.data.getQName() + "ByteArray";
            assetTag = this.buildBinaryDataTag(problems);
            if (assetTag == null) {
                return null;
            }
        }
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(symbolName, assetTag);
        return symbolTags;
    }

    @Override
    public FileNode buildAST(Collection<ICompilerProblem> problems, String filename) {
        if (this.symbolTag != null) {
            return super.buildAST(problems, filename);
        }
        FileNode fileNode = new FileNode((IFileSpecificationGetter)this.workspace, filename);
        PackageNode packageNode = new PackageNode(new IdentifierNode(""), null);
        fileNode.addItem(packageNode);
        ScopedBlockNode packageContents = packageNode.getScopedNode();
        ImportNode importNode = ImportNode.buildImportNode(this.getBaseClassQName());
        packageContents.addItem(importNode);
        importNode = ImportNode.buildImportNode("flash.utils.ByteArray");
        packageContents.addItem(importNode);
        String byteArrayClassName = this.data.getQName() + "ByteArray";
        ClassNode classNodeByteArray = new ClassNode(new IdentifierNode(byteArrayClassName));
        classNodeByteArray.setBaseClass(new IdentifierNode("ByteArray"));
        classNodeByteArray.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodeByteArray);
        String movieClassName = this.data.getQName();
        ClassNode classNodeMovie = new ClassNode(new IdentifierNode(movieClassName));
        classNodeMovie.setBaseClass(new IdentifierNode(this.getBaseClassName()));
        classNodeMovie.setNamespace(new NamespaceIdentifierNode("public"));
        packageContents.addItem(classNodeMovie);
        IdentifierNode constructorNameNode = new IdentifierNode(movieClassName);
        constructorNameNode.setReferenceValue(classNodeMovie.getDefinition());
        FunctionNode constructorNode = new FunctionNode(null, constructorNameNode);
        constructorNode.setNamespace(new NamespaceIdentifierNode("public"));
        ScopedBlockNode constructorContents = constructorNode.getScopedNode();
        FunctionCallNode superCall = new FunctionCallNode(LanguageIdentifierNode.buildSuper());
        ASToken newToken = new ASToken(152, -1, -1, -1, -1, "new");
        FunctionCallNode newBytes = new FunctionCallNode(newToken, new IdentifierNode(byteArrayClassName));
        ContainerNode args = superCall.getArgumentsNode();
        args.addChild(newBytes);
        args.addChild(new NumericLiteralNode(Integer.toString(this.swfWidth)));
        args.addChild(new NumericLiteralNode(Integer.toString(this.swfHeight)));
        constructorContents.addItem(superCall);
        classNodeMovie.getScopedNode().addItem(constructorNode);
        fileNode.runPostProcess(EnumSet.of(PostProcessStep.POPULATE_SCOPE));
        return fileNode;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public FlexFontInfo getFlexFontInfo() {
        return this.flexFontInfo;
    }

    private SWFReader getSWFReader(Collection<ICompilerProblem> problems) {
        SWFCache.SWFCacheKey cacheKey;
        ISWCManager swcManager = this.workspace.getSWCManager();
        if (this.swcSource == null) {
            cacheKey = SWFCache.createKey(this.source);
        } else {
            ISWC swc = swcManager.get(new File(this.swcSource.getContainingSWCPath()));
            cacheKey = SWFCache.createKey(swc, this.source);
        }
        SWFCache swfCache = this.workspace.getSWCManager().getSWFCache();
        SWFReader swfReader = (SWFReader)swfCache.get(cacheKey);
        return swfReader;
    }

    private ICharacterTag getSWFTag(SWFReader swfReader, String tagName, Collection<ICompilerProblem> problems) {
        boolean tagsModified;
        ICharacterTag characterTag = null;
        for (ITag tag : swfReader) {
            ExportAssetsTag exportAssetsTag;
            SymbolClassTag symbolClassTag;
            if (tag instanceof SymbolClassTag ? (characterTag = (symbolClassTag = (SymbolClassTag)tag).getSymbol(tagName)) != null : tag instanceof ExportAssetsTag && (characterTag = (exportAssetsTag = (ExportAssetsTag)tag).getCharacterTagByName(tagName)) != null) break;
        }
        if (characterTag != null && (tagsModified = this.modifyTagsForEmbedding(characterTag))) {
            problems.add(new EmbedAS2TagsModifiedProblem(this.symbol));
        }
        return characterTag;
    }

    private boolean modifyTagsForEmbedding(ICharacterTag tag) {
        DefineButtonTag buttonTag;
        byte[] actions;
        boolean tagsModified = false;
        if (tag instanceof DefineSpriteTag) {
            DefineSpriteTag spriteTag = (DefineSpriteTag)tag;
            for (ITag controlTag : spriteTag.getControlTags()) {
                if (!(controlTag instanceof PlaceObject2Tag)) continue;
                PlaceObject2Tag placeObject = (PlaceObject2Tag)controlTag;
                if (placeObject.isHasClipActions()) {
                    placeObject.setCharacter(null);
                    tagsModified = true;
                }
                if (placeObject.isHasCharacter()) {
                    tagsModified |= this.modifyTagsForEmbedding(placeObject.getCharacter());
                }
                if (!placeObject.isHasName()) continue;
                this.embedProps.add(placeObject.getName());
            }
        } else if (tag instanceof DefineButtonTag && (actions = (buttonTag = (DefineButtonTag)tag).getActions()) != null && actions.length > 0) {
            buttonTag.setActions(null);
            tagsModified = true;
        }
        return tagsModified;
    }

    private String getAssociatedClass(ICharacterTag tag) {
        String associatedClass = "flash.display.Sprite";
        if (tag instanceof DefineButtonTag) {
            associatedClass = "flash.display.SimpleButton";
        } else if (tag instanceof DefineFontTag || tag instanceof DefineFont4Tag) {
            associatedClass = "flash.text.Font";
        } else if (tag instanceof DefineTextTag) {
            associatedClass = "flash.text.TextField";
        } else if (tag instanceof DefineSoundTag) {
            associatedClass = "flash.media.Sound";
        } else if (tag instanceof DefineBitsTag || tag instanceof DefineBitsLosslessTag) {
            associatedClass = "flash.display.Bitmap";
        } else if (tag instanceof DefineSpriteTag) {
            associatedClass = "flash.display.Sprite";
        }
        return associatedClass;
    }

    private DefineSpriteTag scaleExistingSprite(DefineSpriteTag sprite, Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        DefineScalingGridTag scalingGrid = this.buildScalingGrid();
        return this.buildSprite(sprite.getControlTags(), sprite.getFrameCount(), scalingGrid, tags);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof MovieTranscoder)) {
            return false;
        }
        MovieTranscoder t = (MovieTranscoder)o;
        return this.symbol != null ? this.symbol.equals(t.symbol) : t.symbol == null;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (this.symbol != null) {
            hashCode ^= this.symbol.hashCode();
        }
        return hashCode;
    }
}

