/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.embedding.transcoders;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.embedding.EmbedAttribute;
import com.adobe.flash.compiler.internal.embedding.EmbedData;
import com.adobe.flash.compiler.internal.embedding.transcoders.TranscoderBase;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.EmbedBadFontParametersProblem;
import com.adobe.flash.compiler.problems.EmbedExceptionWhileTranscodingProblem;
import com.adobe.flash.compiler.problems.EmbedUnableToBuildFontProblem;
import com.adobe.flash.compiler.problems.EmbedUnableToReadSourceProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.fonts.DefineFont3FontManager;
import com.adobe.flash.fonts.DefineFont4FontManager;
import com.adobe.flash.fonts.FontDescription;
import com.adobe.flash.fonts.FontManager;
import com.adobe.flash.swf.tags.CharacterTag;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import com.adobe.flash.utils.FileUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class FontTranscoder
extends TranscoderBase {
    private String alias = "";
    private URI[] locations = new URI[0];
    private int fontStyle = 0;
    private int fontWeight = 0;
    private boolean embedAsCff = true;
    private boolean advancedAntiAliasing = true;
    private String fontName;
    private String fontFamily;
    private String unicodeRange;
    private String[] sourceList;

    public FontTranscoder(EmbedData data, Workspace workspace) {
        super(data, workspace);
    }

    @Override
    public boolean analyze(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.analyze(location, problems);
        if (!result) {
            return false;
        }
        this.baseClassQName = "flash.text.Font";
        if (this.source != null) {
            URI srcUrl = this.getURI(this.source, problems);
            if (srcUrl == null) {
                return false;
            }
            this.locations = new URI[]{srcUrl};
        } else if (this.sourceList != null) {
            LinkedList<URI> srcURLs = new LinkedList<URI>();
            for (int i = 0; i < this.sourceList.length; ++i) {
                URI srcUrl = this.getURI(this.sourceList[i], problems);
                if (srcUrl == null) continue;
                srcURLs.add(srcUrl);
            }
            this.locations = srcURLs.toArray(new URI[srcURLs.size()]);
        }
        if (this.locations.length == 0) {
            return false;
        }
        this.alias = this.fontName;
        if (this.alias == null) {
            this.alias = this.fontFamily;
        }
        if (this.alias == null) {
            problems.add(new EmbedBadFontParametersProblem(location));
            return false;
        }
        return result;
    }

    @Override
    protected boolean setAttribute(EmbedAttribute attribute) {
        boolean isSupported = true;
        switch (attribute) {
            case FONT_NAME: {
                this.fontName = (String)this.data.getAttribute(EmbedAttribute.FONT_NAME);
                break;
            }
            case FONT_STYLE: {
                this.fontStyle = (Integer)this.data.getAttribute(EmbedAttribute.FONT_STYLE);
                break;
            }
            case FONT_WEIGHT: {
                this.fontWeight = (Integer)this.data.getAttribute(EmbedAttribute.FONT_WEIGHT);
                break;
            }
            case FONT_FAMILY: {
                this.fontFamily = (String)this.data.getAttribute(EmbedAttribute.FONT_FAMILY);
                break;
            }
            case UNICODE_RANGE: {
                this.unicodeRange = (String)this.data.getAttribute(EmbedAttribute.UNICODE_RANGE);
                break;
            }
            case FLASH_TYPE: {
                if (this.data.getAttribute(EmbedAttribute.ADV_ANTI_ALIASING) != null) break;
                this.advancedAntiAliasing = (Boolean)this.data.getAttribute(EmbedAttribute.FLASH_TYPE);
                break;
            }
            case ADV_ANTI_ALIASING: {
                this.advancedAntiAliasing = (Boolean)this.data.getAttribute(EmbedAttribute.ADV_ANTI_ALIASING);
                break;
            }
            case EMBED_AS_CFF: {
                this.embedAsCff = (Boolean)this.data.getAttribute(EmbedAttribute.EMBED_AS_CFF);
                break;
            }
            case SOURCE_LIST: {
                this.sourceList = (String[])this.data.getAttribute(EmbedAttribute.SOURCE_LIST);
                break;
            }
            default: {
                isSupported = super.setAttribute(attribute);
            }
        }
        return isSupported;
    }

    @Override
    protected boolean checkAttributeValues(ISourceLocation location, Collection<ICompilerProblem> problems) {
        boolean result = super.checkAttributeValues(location, problems);
        if (!result) {
            return false;
        }
        if (this.source != null) {
            if (this.sourceList != null) {
                problems.add(new EmbedBadFontParametersProblem(location));
                result = false;
            }
        } else if (this.sourceList == null) {
            problems.add(new EmbedBadFontParametersProblem(location));
            result = false;
        }
        return result;
    }

    @Override
    protected Map<String, ICharacterTag> doTranscode(Collection<ITag> tags, Collection<ICompilerProblem> problems) {
        FontDescription fontDesc = new FontDescription();
        fontDesc.alias = this.alias;
        fontDesc.style = this.fontStyle + this.fontWeight;
        fontDesc.unicodeRanges = this.unicodeRange;
        fontDesc.advancedAntiAliasing = this.advancedAntiAliasing;
        fontDesc.compactFontFormat = this.embedAsCff;
        ICharacterTag assetTag = this.buildFontTag(fontDesc, problems);
        Map<String, ICharacterTag> symbolTags = Collections.singletonMap(this.data.getQName(), assetTag);
        return symbolTags;
    }

    private ICharacterTag buildFontTag(FontDescription fontDesc, Collection<ICompilerProblem> problems) {
        FontManager fontManager = this.getFontManager();
        CharacterTag defineFont = null;
        for (URI fontSource : this.locations) {
            try {
                fontDesc.source = fontSource;
                defineFont = fontManager.createDefineFont(fontDesc, problems);
            }
            catch (FontManager.FontManagerException e) {
                problems.add(new EmbedExceptionWhileTranscodingProblem(e));
            }
            if (defineFont == null) continue;
            return defineFont;
        }
        problems.add(new EmbedUnableToBuildFontProblem(fontDesc.alias));
        return null;
    }

    private FontManager getFontManager() {
        if (this.embedAsCff) {
            return new DefineFont4FontManager();
        }
        return new DefineFont3FontManager();
    }

    private URI getURI(String name, Collection<ICompilerProblem> problems) {
        URI result = null;
        try {
            result = FileUtils.toURI(new File(name));
        }
        catch (URISyntaxException e) {
            problems.add(new EmbedUnableToReadSourceProblem(e, name));
        }
        return result;
    }

    public boolean isBold() {
        return this.fontWeight > 0;
    }

    public boolean isItalic() {
        return this.fontStyle > 0;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof FontTranscoder)) {
            return false;
        }
        FontTranscoder t = (FontTranscoder)o;
        if (this.fontStyle != t.fontStyle || this.fontWeight != t.fontWeight || this.embedAsCff != t.embedAsCff || this.advancedAntiAliasing != t.advancedAntiAliasing || !this.alias.equals(t.alias)) {
            return false;
        }
        return Arrays.equals(this.locations, t.locations);
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode += this.fontStyle;
        hashCode += this.fontWeight;
        hashCode += this.embedAsCff ? 1 : 0;
        hashCode += this.advancedAntiAliasing ? 1 : 0;
        hashCode ^= this.alias.hashCode();
        return hashCode ^= Arrays.hashCode(this.locations);
    }
}

