/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.embedding;

import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.internal.embedding.EmbedAttribute;
import com.adobe.flash.compiler.internal.embedding.EmbedMIMEType;
import com.adobe.flash.compiler.internal.embedding.transcoders.DataTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.FontTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.ImageTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.JPEGTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.MovieTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.PBJTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.SoundTranscoder;
import com.adobe.flash.compiler.internal.embedding.transcoders.TranscoderBase;
import com.adobe.flash.compiler.internal.embedding.transcoders.XMLTranscoder;
import com.adobe.flash.compiler.internal.projects.ASProject;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.SourcePathManager;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.EmbedInvalidAttributeValueProblem;
import com.adobe.flash.compiler.problems.EmbedNoSourceAttributeProblem;
import com.adobe.flash.compiler.problems.EmbedQualityValueProblem;
import com.adobe.flash.compiler.problems.EmbedScalingGridValueProblem;
import com.adobe.flash.compiler.problems.EmbedSourceAttributeDoesNotExistProblem;
import com.adobe.flash.compiler.problems.EmbedSystemFontsNotSupportedProblem;
import com.adobe.flash.compiler.problems.EmbedUnknownAttributeProblem;
import com.adobe.flash.compiler.problems.EmbedUnknownMimeTypeProblem;
import com.adobe.flash.compiler.problems.EmbedUnrecogniedFileTypeProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.SkinEmbeddingNotSupported;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.utils.FilenameNormalization;
import com.adobe.flash.utils.StringEncoder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class EmbedData {
    private static final String EMBED_SWC_SEP = "|";
    private final String containingSourceFilename;
    private final HashMap<EmbedAttribute, Object> attributes;
    private final String specifiedName;
    private TranscoderBase transcoder;
    private ISWCFileEntry swcSource;

    public EmbedData(String containingSourceFilename, String specifiedQName) {
        this.containingSourceFilename = containingSourceFilename;
        this.attributes = new HashMap();
        this.specifiedName = specifiedQName;
        this.swcSource = null;
    }

    public boolean addAttribute(CompilerProject project, ISourceLocation location, String key, String value, Collection<ICompilerProblem> problems) {
        boolean hadError = false;
        try {
            if (EmbedAttribute.SOURCE.equals(key) || key == null) {
                LinkedList<ICompilerProblem> resolveProblems = new LinkedList<ICompilerProblem>();
                String source = this.getResolvedSourcePath((ICompilerProject)project, location, value, resolveProblems);
                if (source == null) {
                    int octothorpe = value.indexOf("#");
                    if (octothorpe != -1) {
                        source = this.getResolvedSourcePath((ICompilerProject)project, location, value.substring(0, octothorpe), problems);
                        String symbol = value.substring(octothorpe + 1);
                        this.attributes.put(EmbedAttribute.SYMBOL, symbol);
                    } else {
                        problems.addAll(resolveProblems);
                    }
                }
                if (source != null) {
                    this.attributes.put(EmbedAttribute.SOURCE, source);
                    if (!this.attributes.containsKey((Object)EmbedAttribute.MIME_TYPE)) {
                        this.attributes.put(EmbedAttribute.MIME_TYPE, (Object)EmbedMIMEType.getMimeTypeFromFilename(source));
                    }
                } else {
                    Collection<ICompilationUnit> referencingCUs = project.getCompilationUnits(this.containingSourceFilename);
                    for (ICompilationUnit cu : referencingCUs) {
                        project.addUnfoundReferencedSourceFileDependency(value, cu);
                    }
                    hadError = true;
                }
            } else if (EmbedAttribute.MIME_TYPE.equals(key)) {
                this.attributes.put(EmbedAttribute.MIME_TYPE, (Object)EmbedMIMEType.getMimeTypeFromMimeString(value));
            } else if (EmbedAttribute.COMPRESSION.equals(key)) {
                this.attributes.put(EmbedAttribute.COMPRESSION, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.ENCODING.equals(key)) {
                this.attributes.put(EmbedAttribute.ENCODING, value);
            } else if (EmbedAttribute.EXPORT_SYMBOL.equals(key)) {
                this.attributes.put(EmbedAttribute.EXPORT_SYMBOL, value);
            } else if (EmbedAttribute.FLASH_TYPE.equals(key)) {
                this.attributes.put(EmbedAttribute.FLASH_TYPE, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.ORIGINAL.equals(key)) {
                this.attributes.put(EmbedAttribute.ORIGINAL, value);
            } else if (EmbedAttribute.QUALITY.equals(key)) {
                double doubleValue = Double.parseDouble(value);
                if (doubleValue < 0.0 || doubleValue > 100.0) {
                    problems.add(new EmbedQualityValueProblem(location, doubleValue));
                    hadError = true;
                } else {
                    Float floatValue = Float.valueOf((float)(doubleValue / 100.0));
                    this.attributes.put(EmbedAttribute.QUALITY, floatValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_BOTTOM.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_BOTTOM, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_BOTTOM, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_LEFT.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_LEFT, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_LEFT, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_RIGHT.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_RIGHT, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_RIGHT, intValue);
                }
            } else if (EmbedAttribute.SCALE_GRID_TOP.equals(key)) {
                Integer intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    problems.add(new EmbedScalingGridValueProblem(location, EmbedAttribute.SCALE_GRID_TOP, intValue));
                    hadError = true;
                } else {
                    intValue = intValue * 20;
                    this.attributes.put(EmbedAttribute.SCALE_GRID_TOP, intValue);
                }
            } else if (EmbedAttribute.SMOOTHING.equals(key)) {
                this.attributes.put(EmbedAttribute.SMOOTHING, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.SYMBOL.equals(key)) {
                this.attributes.put(EmbedAttribute.SYMBOL, value);
            } else if (EmbedAttribute.ADV_ANTI_ALIASING.equals(key)) {
                this.attributes.put(EmbedAttribute.ADV_ANTI_ALIASING, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.EMBED_AS_CFF.equals(key)) {
                this.attributes.put(EmbedAttribute.EMBED_AS_CFF, Boolean.parseBoolean(value));
            } else if (EmbedAttribute.FONT_FAMILY.equals(key)) {
                this.attributes.put(EmbedAttribute.FONT_FAMILY, value);
            } else if (EmbedAttribute.FONT_NAME.equals(key)) {
                this.attributes.put(EmbedAttribute.FONT_NAME, value);
            } else if (EmbedAttribute.FONT_STYLE.equals(key)) {
                if (EmbedData.isItalic(value)) {
                    this.attributes.put(EmbedAttribute.FONT_STYLE, 2);
                } else {
                    this.attributes.put(EmbedAttribute.FONT_STYLE, 0);
                }
            } else if (EmbedAttribute.FONT_WEIGHT.equals(key)) {
                if (EmbedData.isBold(value)) {
                    this.attributes.put(EmbedAttribute.FONT_WEIGHT, 1);
                } else {
                    this.attributes.put(EmbedAttribute.FONT_WEIGHT, 0);
                }
            } else if (EmbedAttribute.UNICODE_RANGE.equals(key)) {
                this.attributes.put(EmbedAttribute.UNICODE_RANGE, value);
            } else if (EmbedAttribute.SOURCE_LIST.equals(key)) {
                this.attributes.put(EmbedAttribute.SOURCE_LIST, value);
            } else if (EmbedAttribute.SYSTEM_FONT.equals(key)) {
                problems.add(new EmbedSystemFontsNotSupportedProblem(location));
                hadError = true;
            } else if (!EmbedAttribute.SKIN_CLASS.equals(key)) {
                problems.add(new EmbedUnknownAttributeProblem(location, key));
                hadError = true;
            }
        }
        catch (NumberFormatException e) {
            problems.add(new EmbedInvalidAttributeValueProblem(location, key, value));
            hadError = true;
        }
        return hadError;
    }

    public Object getAttribute(EmbedAttribute attribute) {
        return this.attributes.get((Object)attribute);
    }

    public EmbedAttribute[] getAttributes() {
        return this.attributes.keySet().toArray(new EmbedAttribute[this.attributes.size()]);
    }

    public boolean createTranscoder(CompilerProject project, ISourceLocation location, Collection<ICompilerProblem> problems) {
        String source = (String)this.getAttribute(EmbedAttribute.SOURCE);
        if (source == null && this.getAttribute(EmbedAttribute.SOURCE_LIST) == null) {
            problems.add(new EmbedNoSourceAttributeProblem(location));
            return false;
        }
        EmbedMIMEType mimeType = (EmbedMIMEType)((Object)this.getAttribute(EmbedAttribute.MIME_TYPE));
        if (mimeType == null) {
            problems.add(new EmbedUnrecogniedFileTypeProblem(location, source));
            return false;
        }
        Workspace workspace = project.getWorkspace();
        switch (mimeType) {
            case JPEG: 
            case JPG: 
            case PNG: 
            case GIF: {
                Boolean compression = (Boolean)this.getAttribute(EmbedAttribute.COMPRESSION);
                Float quality = (Float)this.getAttribute(EmbedAttribute.QUALITY);
                if (compression != null && compression.booleanValue() || quality != null) {
                    this.transcoder = new JPEGTranscoder(this, workspace);
                    break;
                }
                this.transcoder = new ImageTranscoder(this, workspace);
                break;
            }
            case MP3: {
                this.transcoder = new SoundTranscoder(this, workspace);
                break;
            }
            case FLASH: {
                this.transcoder = new MovieTranscoder(this, workspace);
                break;
            }
            case PBJ: {
                this.transcoder = new PBJTranscoder(this, workspace);
                break;
            }
            case OCT_STRM: {
                this.transcoder = new DataTranscoder(this, workspace);
                break;
            }
            case XML: {
                this.transcoder = new XMLTranscoder(this, workspace);
                break;
            }
            case TTF: 
            case TTC: 
            case OTF: 
            case FONT: 
            case DFONT: {
                this.transcoder = new FontTranscoder(this, workspace);
                break;
            }
            case SKIN: {
                problems.add(new SkinEmbeddingNotSupported(location));
                this.transcoder = null;
                break;
            }
            default: {
                problems.add(new EmbedUnknownMimeTypeProblem(location, mimeType));
                this.transcoder = null;
            }
        }
        if (this.transcoder == null) {
            return false;
        }
        if (!this.transcoder.analyze(location, problems)) {
            this.transcoder = null;
            return false;
        }
        return true;
    }

    public String getQName() {
        if (this.specifiedName != null) {
            return this.specifiedName;
        }
        String source = (String)this.getAttribute(EmbedAttribute.SOURCE);
        if (this.swcSource != null) {
            source = EMBED_SWC_SEP.concat(source);
            source = this.swcSource.getContainingSWCPath().concat(source);
        }
        String filename = FilenameUtils.getName((String)source);
        filename = filename.replaceAll("[`^.@]", "_");
        String qname = filename + "$" + StringEncoder.stringToMD5String(source);
        qname = qname + this.transcoder.hashCode();
        return qname;
    }

    public boolean generatedClassExtendsAnother() {
        String baseClassQname = this.transcoder.getBaseClassQName();
        return !baseClassQname.isEmpty();
    }

    public final TranscoderBase getTranscoder() {
        return this.transcoder;
    }

    public final ISWCFileEntry getSWCSource() {
        return this.swcSource;
    }

    public boolean equals(Object o) {
        assert (this.transcoder != null) : "equals called on EmbedData with null transcoder";
        if (!(o instanceof EmbedData)) {
            return false;
        }
        if (this.specifiedName == null && ((EmbedData)o).specifiedName != null) {
            return false;
        }
        if (this.specifiedName != null) {
            return this.specifiedName.equals(((EmbedData)o).specifiedName);
        }
        return this.transcoder.equals(((EmbedData)o).getTranscoder());
    }

    public int hashCode() {
        assert (this.transcoder != null) : "hashCode called on EmbedData with null transcoder";
        if (this.specifiedName != null) {
            return this.specifiedName.hashCode();
        }
        return this.transcoder.hashCode();
    }

    private static boolean isItalic(String value) {
        String i;
        boolean italic = false;
        if (value != null && ((i = value.trim().toLowerCase()).equals("italic") || i.equals("oblique"))) {
            italic = true;
        }
        return italic;
    }

    private static boolean isBold(String value) {
        boolean bold = false;
        if (value != null) {
            String b = value.trim().toLowerCase();
            if (b.startsWith("bold")) {
                bold = true;
            } else {
                try {
                    int w = Integer.parseInt(b);
                    if (w >= 700) {
                        bold = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return bold;
    }

    private String getResolvedSourcePath(ICompilerProject project, ISourceLocation location, String sourceValue, Collection<ICompilerProblem> problems) {
        if (sourceValue == null || sourceValue.isEmpty()) {
            problems.add(new EmbedNoSourceAttributeProblem(location));
            return null;
        }
        LinkedHashMap<String, String> searchedLocations = new LinkedHashMap<String, String>();
        String containingSourcePath = new File(this.containingSourceFilename).getParent();
        String sourceFile = this.getResolvedSourcePath(project, containingSourcePath, sourceValue, searchedLocations);
        if (sourceFile == null) {
            problems.add(new EmbedSourceAttributeDoesNotExistProblem(location, sourceValue, searchedLocations));
        }
        return sourceFile;
    }

    private String getResolvedSourcePath(ICompilerProject project, String containingSourcePath, String filename, Map<String, String> searchedLocations) {
        String sourceFile = null;
        if (new File(filename).isAbsolute()) {
            searchedLocations.put(FilenameNormalization.normalize(filename), "QuotedPath");
            sourceFile = SourcePathManager.getSourceFileInPath(null, filename);
            if (sourceFile != null) {
                return sourceFile;
            }
        }
        if (containingSourcePath != null) {
            File file = new File(containingSourcePath, filename);
            searchedLocations.put(FilenameNormalization.normalize(file).getAbsolutePath(), "QuotedPath");
            sourceFile = SourcePathManager.getSourceFileInPath(new File(containingSourcePath), filename);
        }
        if (sourceFile != null) {
            return sourceFile;
        }
        if (project instanceof ASProject) {
            sourceFile = this.getResolvedSourcePath((ASProject)project, filename, searchedLocations);
        }
        return sourceFile;
    }

    private String getResolvedSourcePath(ASProject project, String filename, Map<String, String> searchedLocations) {
        String sourceFile = null;
        boolean isAbsolute = filename.startsWith("/");
        if (isAbsolute) {
            searchedLocations.put(filename.substring(1), "EmbedOnSourcePath");
            sourceFile = project.getSourceFileFromSourcePath(filename.substring(1));
        }
        if (sourceFile != null) {
            return sourceFile;
        }
        if (!isAbsolute) {
            searchedLocations.put(filename, "EmbedOnLibraryPath");
            this.swcSource = project.getSourceFileFromLibraryPath(filename);
            if (this.swcSource != null) {
                sourceFile = this.swcSource.getPath();
            }
        }
        return sourceFile;
    }
}

