/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions.references;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.internal.definitions.AmbiguousDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ResolvedQualifiersReference
implements IResolvedQualifiersReference {
    private final ImmutableSet<INamespaceDefinition> qualifiers;
    private final String baseName;

    public ResolvedQualifiersReference(ImmutableSet<INamespaceDefinition> qualifiers, String baseName) {
        assert (baseName != null);
        this.qualifiers = qualifiers;
        this.baseName = baseName;
    }

    @Override
    public String getName() {
        return this.baseName;
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        if (this.qualifiers.size() == 1) {
            INamespaceDefinition qualifier = (INamespaceDefinition)Iterables.getOnlyElement(this.qualifiers);
            return scope.findPropertyQualified(project, qualifier, this.getName(), dependencyType, canEscapeWith);
        }
        return ((CompilerProject)project).getCacheForScope(scope).findPropertyMultiname(this, dependencyType);
    }

    @Override
    public String getDisplayString() {
        INamespaceDefinition namespace;
        String packageName = null;
        Iterator i$ = this.qualifiers.iterator();
        while (i$.hasNext() && (!(namespace = (INamespaceDefinition)i$.next()).isPublicOrInternalNamespace() || (packageName = namespace.getURI()).length() <= 0)) {
        }
        return packageName != null && packageName.length() > 0 ? packageName + '.' + this.baseName : this.baseName;
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        return this.getMName();
    }

    private IDefinition resolveAmbiguities(ICompilerProject project, List<IDefinition> defs) {
        switch (defs.size()) {
            case 0: {
                return null;
            }
            case 1: {
                assert (((IDefinition)Iterables.getOnlyElement(defs)).isInProject(project));
                return (IDefinition)Iterables.getOnlyElement(defs);
            }
        }
        IDefinition d = AmbiguousDefinition.resolveAmbiguities(project, defs);
        if (d == null) {
            return AmbiguousDefinition.get();
        }
        return d;
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ICompilationUnit referencingCompilationUnit, DependencyType dt) {
        CompilerProject compilerProject = (CompilerProject)project;
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(2);
        compilerProject.getScope().findDefinitionByName(referencingCompilationUnit, (Collection<IDefinition>)defs, this.baseName, (Set<INamespaceDefinition>)this.qualifiers, dt);
        return this.resolveAmbiguities(project, defs);
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        CompilerProject compilerProject = (CompilerProject)project;
        ArrayList<IDefinition> defs = new ArrayList<IDefinition>(2);
        compilerProject.getScope().findDefinitionByName((Collection<IDefinition>)defs, this.baseName, (Set<INamespaceDefinition>)this.qualifiers);
        return this.resolveAmbiguities(project, defs);
    }

    @Override
    public Name getMName() {
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(this.qualifiers.size());
        for (INamespaceDefinition namespace : this.qualifiers) {
            ns_set.add(((NamespaceDefinition)namespace).getAETNamespace());
        }
        int nameType = ns_set.size() == 1 ? 7 : 9;
        return new Name(nameType, new Nsset(ns_set), this.baseName);
    }

    @Override
    public ImmutableSet<INamespaceDefinition> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public boolean matches(IResolvedQualifiersReference toMatch) {
        if (!this.baseName.equals(toMatch.getName())) {
            return false;
        }
        for (INamespaceDefinition qualifierToMatch : toMatch.getQualifiers()) {
            if (!this.qualifiers.contains((Object)qualifierToMatch)) continue;
            return true;
        }
        return false;
    }
}

