/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions.references;

import com.adobe.flash.compiler.internal.definitions.references.LexicalReference;
import com.google.common.collect.MapMaker;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;

public class ReferenceCache {
    private final ConcurrentMap<String, LexicalReference> lexicalCache = new MapMaker().weakValues().makeMap();
    private final ThreadLocal<Map<String, WeakReference<LexicalReference>>> threadLocalLexicalCache = new ThreadLocal<Map<String, WeakReference<LexicalReference>>>(){

        @Override
        protected Map<String, WeakReference<LexicalReference>> initialValue() {
            return new WeakHashMap<String, WeakReference<LexicalReference>>();
        }
    };

    public LexicalReference getLexicalReference(String name) {
        LexicalReference ref;
        Map<String, WeakReference<LexicalReference>> cache = this.threadLocalLexicalCache.get();
        WeakReference<LexicalReference> weakRef = cache.get(name);
        LexicalReference lexicalReference = ref = weakRef != null ? (LexicalReference)weakRef.get() : null;
        if (ref != null) {
            return ref;
        }
        LexicalReference newref = new LexicalReference(name);
        ref = this.lexicalCache.putIfAbsent(name, newref);
        if (ref == null) {
            ref = newref;
        }
        cache.put(name, new WeakReference<LexicalReference>(ref));
        return ref;
    }
}

