/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions.references;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.AppliedVectorDefinitionFactory;
import com.adobe.flash.compiler.definitions.IAppliedVectorDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.projects.ICompilerProject;

public class ParameterizedReference
implements IReference {
    private final IReference name;
    private final IReference param;

    public ParameterizedReference(IReference name, IReference param) {
        this.name = name;
        this.param = param;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition vectorType;
        ITypeDefinition baseType;
        if (this.param == null) {
            return null;
        }
        IDefinition base = this.name.resolve(project, scope, dependencyType, canEscapeWith);
        IDefinition typeParam = this.param.resolve(project, scope, dependencyType, canEscapeWith);
        IAppliedVectorDefinition resolvedType = null;
        if (base instanceof ITypeDefinition && typeParam instanceof ITypeDefinition && (baseType = (ITypeDefinition)base) == (vectorType = project.getBuiltinType(IASLanguageConstants.BuiltinType.VECTOR))) {
            resolvedType = AppliedVectorDefinitionFactory.newVector(project, (ITypeDefinition)typeParam);
        }
        return resolvedType;
    }

    @Override
    public String getDisplayString() {
        return this.name.getDisplayString() + ".<" + (this.param == null ? "" : this.param.getDisplayString()) + ">";
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        Name baseName = this.name.getMName(project, scope);
        Name paramName = this.param.getMName(project, scope);
        return new Name(baseName, paramName);
    }
}

