/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions.references;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.projects.ICompilerProject;
import java.util.ArrayList;
import java.util.Set;

public class LexicalReference
implements IReference {
    private final String name;

    public LexicalReference(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<INamespaceDefinition> getNamespaceSet(ICompilerProject project, ASScope scope) {
        return scope.getNamespaceSetForName(project, this.getName());
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType depencencyType, boolean canEscapeWith) {
        return scope.findProperty(project, this.getName(), depencencyType, canEscapeWith);
    }

    @Override
    public String getDisplayString() {
        return this.name;
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        Name n = null;
        Set<INamespaceDefinition> namespaceSet = scope.getNamespaceSetForName(project, this.name);
        ArrayList<Namespace> ns_set = new ArrayList<Namespace>(namespaceSet.size());
        for (INamespaceDefinition namespace : namespaceSet) {
            ns_set.add(((NamespaceDefinition)namespace).resolveAETNamespace(project));
        }
        n = new Name(9, new Nsset(ns_set), this.name);
        return n;
    }

    public String toString() {
        return this.getName();
    }
}

