/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions.references;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.projects.ICompilerProject;

public class BuiltinReference
implements IReference {
    private final IASLanguageConstants.BuiltinType builtinType;

    public BuiltinReference(IASLanguageConstants.BuiltinType type) {
        this.builtinType = type;
    }

    @Override
    public String getName() {
        return this.builtinType.getName();
    }

    @Override
    public IDefinition resolve(ICompilerProject project, ASScope scope, DependencyType dependencyType, boolean canEscapeWith) {
        ITypeDefinition definition = project.getBuiltinType(this.builtinType);
        scope.addDependencyOnBuiltinType(project, this.builtinType, dependencyType);
        return definition;
    }

    @Override
    public String getDisplayString() {
        return this.builtinType.getName();
    }

    @Override
    public Name getMName(ICompilerProject project, ASScope scope) {
        ITypeDefinition def = project.getBuiltinType(this.builtinType);
        if (def == null) {
            return null;
        }
        return ((DefinitionBase)((Object)def)).getMName(project);
    }
}

