/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.internal.tree.as.GetterNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.ParameterNode;
import com.adobe.flash.compiler.internal.tree.as.SetterNode;
import com.adobe.flash.compiler.internal.tree.as.VariableNode;
import com.adobe.flash.compiler.tree.as.IDefinitionNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class VectorInformation {
    private static VectorInformation instance;
    private HashSet<String> excludedMethods = new HashSet();
    private HashMap<String, FunctionInfo> info = new HashMap();
    private ArrayList<FunctionInfo> additionalInfo = new ArrayList();

    public static VectorInformation getInformation() {
        if (instance == null) {
            instance = new VectorInformation();
        }
        return instance;
    }

    public FunctionInfo getFunctionInfo(String funcName) {
        return this.info.get(funcName);
    }

    public FunctionInfo[] getAdditionalInfo() {
        return this.additionalInfo.toArray(new FunctionInfo[0]);
    }

    public IDefinitionNode[] getDefinitions() {
        IDefinitionNode[] retVal = new IDefinitionNode[4];
        VariableNode thisNode = new VariableNode(new IdentifierNode("this"));
        thisNode.setType(null, new IdentifierNode("Vector"));
        retVal[0] = thisNode;
        VariableNode superNode = new VariableNode(new IdentifierNode("super"));
        superNode.setType(null, new IdentifierNode("Object"));
        retVal[1] = superNode;
        GetterNode fixGetter = new GetterNode(null, null, new IdentifierNode("fixed"));
        NamespaceIdentifierNode pub = new NamespaceIdentifierNode("public");
        pub.span(-1, -1, -1, -1);
        fixGetter.setNamespace(pub);
        fixGetter.setType(null, new IdentifierNode("Boolean"));
        retVal[2] = fixGetter;
        SetterNode fixSetter = new SetterNode(null, null, new IdentifierNode("fixed"));
        pub = new NamespaceIdentifierNode("public");
        pub.span(-1, -1, -1, -1);
        fixSetter.setNamespace(pub);
        fixSetter.setType(null, new IdentifierNode("void"));
        ParameterNode value = new ParameterNode(new IdentifierNode("value"));
        value.setType(null, new IdentifierNode("Boolean"));
        fixSetter.getParametersContainerNode().addChild(value);
        retVal[3] = fixSetter;
        return retVal;
    }

    public boolean isExcluded(String name) {
        return this.excludedMethods.contains(name);
    }

    private VectorInformation() {
        this.excludedMethods.add("sortOn");
        this.excludedMethods.add("Array");
        this.excludedMethods.add("Object");
        FunctionInfo concat = new FunctionInfo("concat", Type.VECTOR_TYPE);
        this.info.put("concat", concat);
        concat.addArgumentType(new ArgumentInfo("parameters", Type.DEFAULT_TYPE));
        FunctionInfo everyInfo = new FunctionInfo("every", Type.VECTOR_TYPE);
        this.info.put("every", everyInfo);
        everyInfo.addArgumentType(new ArgumentInfo("callback", Type.DEFAULT_TYPE));
        everyInfo.addArgumentType(new ArgumentInfo("thisObject", Type.DEFAULT_TYPE, "null"));
        FunctionInfo filter = new FunctionInfo("filter", Type.VECTOR_TYPE);
        this.info.put("filter", filter);
        filter.addArgumentType(new ArgumentInfo("callback", Type.DEFAULT_TYPE));
        filter.addArgumentType(new ArgumentInfo("thisObject", Type.DEFAULT_TYPE, "null"));
        FunctionInfo forEach = new FunctionInfo("forEach", Type.DEFAULT_TYPE);
        this.info.put("forEach", forEach);
        forEach.addArgumentType(new ArgumentInfo("callback", Type.DEFAULT_TYPE));
        forEach.addArgumentType(new ArgumentInfo("thisObject", Type.DEFAULT_TYPE, "null"));
        FunctionInfo indexOf = new FunctionInfo("indexOf", Type.DEFAULT_TYPE);
        this.info.put("indexOf", indexOf);
        indexOf.addArgumentType(new ArgumentInfo("searchElement", Type.VECTOR_COLLECTION_TYPE));
        indexOf.addArgumentType(new ArgumentInfo("fromIndex", Type.DEFAULT_TYPE, "0"));
        FunctionInfo joinInfo = new FunctionInfo("join", Type.DEFAULT_TYPE);
        joinInfo.addArgumentType(new ArgumentInfo("sep", Type.DEFAULT_TYPE, "\",\""));
        this.info.put("join", joinInfo);
        FunctionInfo lastIndexOf = new FunctionInfo("lastIndexOf", Type.DEFAULT_TYPE);
        this.info.put("lastIndexOf", lastIndexOf);
        lastIndexOf.addArgumentType(new ArgumentInfo("searchElement", Type.VECTOR_COLLECTION_TYPE));
        lastIndexOf.addArgumentType(new ArgumentInfo("fromIndex", Type.DEFAULT_TYPE, "0x7fffffff"));
        FunctionInfo map = new FunctionInfo("map", Type.VECTOR_TYPE);
        this.info.put("map", map);
        map.addArgumentType(new ArgumentInfo("callback", Type.DEFAULT_TYPE));
        map.addArgumentType(new ArgumentInfo("thisObject", Type.DEFAULT_TYPE, "null"));
        this.info.put("pop", new FunctionInfo("pop", Type.VECTOR_COLLECTION_TYPE));
        FunctionInfo push = new FunctionInfo("push", Type.DEFAULT_TYPE);
        push.addArgumentType(new ArgumentInfo("parameters", Type.DEFAULT_TYPE));
        this.info.put("push", push);
        this.info.put("reverse", new FunctionInfo("reverse", Type.VECTOR_TYPE));
        this.info.put("shift", new FunctionInfo("shift", Type.VECTOR_COLLECTION_TYPE));
        FunctionInfo slice = new FunctionInfo("slice", Type.VECTOR_TYPE);
        this.info.put("slice", slice);
        slice.addArgumentType(new ArgumentInfo("startIndex", Type.DEFAULT_TYPE, "0"));
        slice.addArgumentType(new ArgumentInfo("endIndex", Type.DEFAULT_TYPE, "16777215"));
        FunctionInfo some = new FunctionInfo("some", Type.DEFAULT_TYPE);
        this.info.put("some", some);
        some.addArgumentType(new ArgumentInfo("callback", Type.DEFAULT_TYPE));
        some.addArgumentType(new ArgumentInfo("thisObject", Type.DEFAULT_TYPE, "null"));
        FunctionInfo sort = new FunctionInfo("sort", Type.VECTOR_TYPE);
        this.info.put("sort", sort);
        sort.addArgumentType(new ArgumentInfo("compareFunction", Type.DEFAULT_TYPE));
        FunctionInfo splice = new FunctionInfo("splice", Type.VECTOR_TYPE);
        this.info.put("splice", splice);
        splice.addArgumentType(new ArgumentInfo("startIndex", Type.DEFAULT_TYPE));
        splice.addArgumentType(new ArgumentInfo("deleteCount", Type.DEFAULT_TYPE));
        splice.addArgumentType(new ArgumentInfo("items", Type.DEFAULT_TYPE));
        FunctionInfo unshift = new FunctionInfo("unshift", Type.DEFAULT_TYPE);
        this.info.put("unshift", unshift);
        unshift.addArgumentType(new ArgumentInfo("parameters", Type.DEFAULT_TYPE));
        this.additionalInfo.add(new FunctionInfo("toLocaleString", Type.DEFAULT_TYPE));
    }

    Set<Map.Entry<String, FunctionInfo>> getFunctionInfos() {
        return this.info.entrySet();
    }

    public static class ArgumentInfo {
        private String name;
        private Enum<Type> type;
        private String defaultValue;

        public ArgumentInfo(String name, Type type) {
            this.name = name;
            this.type = type;
        }

        public ArgumentInfo(String name, Type type, String defaultValue) {
            this(name, type);
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean returnIsVector() {
            return this.type == Type.VECTOR_TYPE;
        }

        public boolean returnIsTypeOfCollection() {
            return this.type == Type.VECTOR_COLLECTION_TYPE;
        }
    }

    public static class FunctionInfo {
        private String name;
        private List<ArgumentInfo> arguments = new ArrayList<ArgumentInfo>();
        Enum<Type> t;

        public FunctionInfo(Type retType) {
            this.t = retType;
        }

        public FunctionInfo(String name, Type retType) {
            this.name = name;
            this.t = retType;
        }

        public void addArgumentType(ArgumentInfo info) {
            this.arguments.add(info);
        }

        public String getName() {
            return this.name;
        }

        public boolean returnIsVector() {
            return this.t == Type.VECTOR_TYPE;
        }

        public boolean returnIsTypeOfCollection() {
            return this.t == Type.VECTOR_COLLECTION_TYPE;
        }

        public ArgumentInfo[] getArgumentInfo() {
            return this.arguments.toArray(new ArgumentInfo[0]);
        }

        public boolean needsAdjustments() {
            if (this.returnIsVector() || this.returnIsTypeOfCollection()) {
                return true;
            }
            for (ArgumentInfo arg : this.getArgumentInfo()) {
                if (!arg.returnIsVector() && !arg.returnIsTypeOfCollection()) continue;
                return true;
            }
            return false;
        }
    }

    static enum Type {
        DEFAULT_TYPE,
        VECTOR_TYPE,
        VECTOR_COLLECTION_TYPE;

    }
}

