/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IInterfaceDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.internal.definitions.ClassTraitsDefinition;
import com.adobe.flash.compiler.internal.definitions.MemberedDefinition;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.ITypeNode;
import com.adobe.flash.utils.FastStack;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class TypeDefinitionBase
extends MemberedDefinition
implements ITypeDefinition {
    private ClassTraitsDefinition classTraits;

    public TypeDefinitionBase(String name) {
        super(name);
        this.classTraits = new ClassTraitsDefinition(this);
    }

    protected TypeDefinitionBase(String name, ClassTraitsDefinition ctraits) {
        super(name);
        this.classTraits = ctraits;
    }

    @Override
    public boolean isInstanceOf(String qualifiedName, ICompilerProject project) {
        TypeDefinitionBase t = this.resolveType(qualifiedName, project, null);
        if (t == null) {
            return false;
        }
        return this.isInstanceOf(t, project);
    }

    @Override
    public ITypeNode getNode() {
        return (ITypeNode)super.getNode();
    }

    @Override
    public int getNameStart() {
        IMetaTag goToDefinitionHelp = this.getMetaTagByName("__go_to_definition_help");
        if (goToDefinitionHelp != null) {
            String value = goToDefinitionHelp.getAttributeValue("pos");
            if (Strings.isNullOrEmpty((String)value)) {
                return -1;
            }
            return Integer.valueOf(value);
        }
        return super.getNameStart();
    }

    @Override
    public String getPackageName() {
        INamespaceReference namespaceRef = this.getNamespaceReference();
        if (namespaceRef instanceof INamespaceDefinition.INamespaceWithPackageName) {
            return ((INamespaceDefinition.INamespaceWithPackageName)namespaceRef).getNamespacePackageName();
        }
        return "";
    }

    protected IInterfaceDefinition[] filterNullInterfaces(IInterfaceDefinition[] in) {
        ArrayList<IInterfaceDefinition> result = new ArrayList<IInterfaceDefinition>(in.length);
        for (IInterfaceDefinition i : in) {
            if (i == null) continue;
            result.add(i);
        }
        return result.toArray(new IInterfaceDefinition[result.size()]);
    }

    @Override
    public Iterable<ITypeDefinition> typeIteratable(final ICompilerProject project, final boolean skipThis) {
        final TypeDefinitionBase myThis = this;
        return new Iterable<ITypeDefinition>(){

            @Override
            public Iterator<ITypeDefinition> iterator() {
                return new TypeIterator(project, myThis, skipThis);
            }
        };
    }

    public Iterable<ITypeDefinition> staticTypeIterable(final ICompilerProject project, final boolean skipThis) {
        final TypeDefinitionBase myThis = this;
        return new Iterable<ITypeDefinition>(){

            @Override
            public Iterator<ITypeDefinition> iterator() {
                return new StaticTypeIterator(project, myThis, skipThis);
            }
        };
    }

    @Override
    public TypeDefinitionBase resolveType(ICompilerProject project) {
        return this.classTraits;
    }

    public abstract IInterfaceDefinition[] resolveInterfacesImpl(ICompilerProject var1);

    protected static class StaticTypeIterator
    extends TypeIterator {
        private ITypeDefinition initialType;

        public StaticTypeIterator(ICompilerProject project, ITypeDefinition initialType, boolean skipInitial) {
            super(project, initialType, skipInitial);
        }

        @Override
        protected void init(ITypeDefinition initialType, boolean skipThis) {
            this.initialType = initialType;
            this.stack.push(initialType);
            ITypeDefinition classType = this.project.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS);
            this.stack.push(classType);
            if (skipThis) {
                this.next();
            }
        }

        @Override
        protected void pushChildren(ITypeDefinition type) {
            if (type == this.initialType) {
                return;
            }
            super.pushChildren(type);
        }
    }

    protected static class TypeIterator
    implements Iterator<ITypeDefinition> {
        private static final int INITIAL_STACK_SIZE = 10;
        protected final ICompilerProject project;
        protected final FastStack<ITypeDefinition> stack;
        protected final Set<ITypeDefinition> visited;
        protected final FastStack<IClassDefinition> classesWithInterfaces;

        public TypeIterator(ICompilerProject project, ITypeDefinition initialType, boolean skipInitial) {
            this.project = project;
            this.stack = new FastStack(10);
            this.visited = new HashSet<ITypeDefinition>();
            this.classesWithInterfaces = new FastStack();
            this.init(initialType, skipInitial);
        }

        @Override
        public boolean hasNext() {
            if (!this.stack.isEmpty()) {
                return true;
            }
            this.pushInterfaces();
            return !this.stack.isEmpty();
        }

        @Override
        public ITypeDefinition next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ITypeDefinition next = this.stack.pop();
            this.visited.add(next);
            this.pushChildren(next);
            return next;
        }

        protected void pushInterfaces() {
            boolean pushedInterface = false;
            while (!pushedInterface && !this.classesWithInterfaces.isEmpty()) {
                IClassDefinition clazz = this.classesWithInterfaces.pop();
                IInterfaceDefinition[] interfaces = clazz.resolveImplementedInterfaces(this.project);
                for (int i = interfaces.length - 1; i >= 0; --i) {
                    if (interfaces[i] == null) continue;
                    pushedInterface = true;
                    this.push(interfaces[i]);
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void init(ITypeDefinition initialType, boolean skipThis) {
            this.stack.push(initialType);
            if (skipThis) {
                this.next();
            }
        }

        protected void push(ITypeDefinition type) {
            if (!this.visited.contains(type)) {
                this.stack.push(type);
            }
        }

        protected void pushChildren(ITypeDefinition type) {
            if (type instanceof IClassDefinition) {
                IClassDefinition baseClass;
                IClassDefinition classDef = (IClassDefinition)type;
                if (classDef.getImplementedInterfaceReferences().length > 0) {
                    this.classesWithInterfaces.push(classDef);
                }
                if ((baseClass = classDef.resolveBaseClass(this.project)) != null) {
                    this.push(baseClass);
                }
            } else if (type instanceof IInterfaceDefinition) {
                IInterfaceDefinition interfaceDef = (IInterfaceDefinition)type;
                IInterfaceDefinition[] baseInterfaces = interfaceDef.resolveExtendedInterfaces(this.project);
                for (int i = baseInterfaces.length - 1; i >= 0; --i) {
                    if (baseInterfaces[i] == null) continue;
                    this.push(baseInterfaces[i]);
                }
            }
        }
    }
}

