/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IStyleDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.definitions.MetadataDefinitionBase;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.metadata.IStyleTagNode;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

public class StyleDefinition
extends MetadataDefinitionBase
implements IStyleDefinition {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String arrayType;
    private String[] enumeration = EMPTY_STRING_ARRAY;
    private String format;
    private String inherit;
    private String[] states = EMPTY_STRING_ARRAY;
    private String[] themes = EMPTY_STRING_ARRAY;
    private String minValue;
    private String minValueExclusive;
    private String maxValue;
    private String maxValueExclusive;

    public StyleDefinition(String name, IClassDefinition decoratedDefinition) {
        super(name, "Style", decoratedDefinition);
    }

    @Override
    public IStyleTagNode getNode() {
        return (IStyleTagNode)super.getNode();
    }

    @Override
    public String getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(String arrayType) {
        this.arrayType = arrayType;
    }

    @Override
    public ITypeDefinition resolveArrayType(ICompilerProject project) {
        assert (false);
        return null;
    }

    @Override
    public String[] getEnumeration() {
        return this.enumeration;
    }

    public void setEnumeration(String[] enumeration) {
        assert (enumeration != null);
        this.enumeration = enumeration;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public boolean isColor() {
        return this.format.equals("Color");
    }

    @Override
    public String getInherit() {
        return this.inherit;
    }

    public void setInherit(String inherit) {
        this.inherit = inherit;
    }

    @Override
    public boolean isInheriting() {
        return this.inherit != null && this.inherit.equals("yes");
    }

    @Override
    public String[] getStates() {
        return this.states;
    }

    public void setStates(String[] states) {
        this.states = states;
    }

    @Override
    public String[] getThemes() {
        return this.themes;
    }

    public void setThemes(String themes) {
        if (themes == null) {
            this.themes = new String[0];
        } else {
            Iterable split = Splitter.onPattern((String)"[,\\s]").trimResults().omitEmptyStrings().split((CharSequence)themes);
            this.themes = (String[])Iterables.toArray((Iterable)split, String.class);
        }
    }

    @Override
    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    @Override
    public String getMinValueExclusive() {
        return this.minValueExclusive;
    }

    public void setMinValueExclusive(String minValueExclusive) {
        this.minValueExclusive = minValueExclusive;
    }

    @Override
    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public String getMaxValueExclusive() {
        return this.maxValueExclusive;
    }

    public void setMaxValueExclusive(String maxValueExclusive) {
        this.maxValueExclusive = maxValueExclusive;
    }
}

