/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.definitions;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IParameterDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.scopes.CatchScope;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.as.IParameterNode;

public class ParameterDefinition
extends VariableDefinition
implements IParameterDefinition {
    public ParameterDefinition(String name) {
        super(name);
    }

    @Override
    public boolean isRest() {
        return (this.flags & 0x80) != 0;
    }

    public void setRest() {
        this.flags = (short)(this.flags | 0x80);
        IReference arrayTypeReference = ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY);
        this.setTypeReference(arrayTypeReference);
    }

    @Override
    public boolean hasDefaultValue() {
        return (this.flags & 0x200) != 0;
    }

    public void setHasDefault() {
        this.flags = (short)(this.flags | 0x200);
    }

    public void setDefaultValue(Object value) {
        this.initValue = value;
        this.flags = (short)(this.flags | 0x200);
    }

    @Override
    public Object resolveDefaultValue(ICompilerProject project) {
        if (this.hasDefaultValue()) {
            return this.resolveInitialValue(project);
        }
        return null;
    }

    @Override
    protected DependencyType getTypeDependencyType() {
        return DependencyType.SIGNATURE;
    }

    @Override
    public IParameterNode getNode() {
        return (IParameterNode)super.getNode();
    }

    @Override
    public boolean matches(DefinitionBase node) {
        boolean matches = super.matches(node);
        if (!matches) {
            return false;
        }
        return node.getNameStart() == this.getNameStart() && node.getNameEnd() == this.getNameEnd();
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getBaseName());
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public final IVariableDefinition.VariableClassification getVariableClassification() {
        IASScope containingScope = this.getContainingScope();
        if (containingScope instanceof CatchScope) {
            return IVariableDefinition.VariableClassification.LOCAL;
        }
        return IVariableDefinition.VariableClassification.PARAMETER;
    }
}

